/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.server.namenode.BlocksMap;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeFileUnderConstructionWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;

public class INodeFileUnderConstruction
extends INodeFile {
    String clientName;
    private final String clientMachine;
    private final DatanodeDescriptor clientNode;
    private int primaryNodeIndex = -1;
    private DatanodeDescriptor[] targets = null;
    private long lastRecoveryTime = 0L;

    public static INodeFileUnderConstruction valueOf(INode inode, String path) throws FileNotFoundException {
        INodeFile file = INodeFile.valueOf(inode, path);
        if (!file.isUnderConstruction()) {
            throw new FileNotFoundException("File is not under construction: " + path);
        }
        return (INodeFileUnderConstruction)file;
    }

    INodeFileUnderConstruction(long id, PermissionStatus permissions, short replication, long preferredBlockSize, long modTime, String clientName, String clientMachine, DatanodeDescriptor clientNode) {
        this(id, null, replication, modTime, preferredBlockSize, BlocksMap.BlockInfo.EMPTY_ARRAY, permissions, clientName, clientMachine, clientNode);
    }

    public INodeFileUnderConstruction(long id, byte[] name, short blockReplication, long modificationTime, long preferredBlockSize, BlocksMap.BlockInfo[] blocks, PermissionStatus perm, String clientName, String clientMachine, DatanodeDescriptor clientNode) {
        super(id, name, perm, modificationTime, modificationTime, blocks, blockReplication, preferredBlockSize);
        this.clientName = clientName;
        this.clientMachine = clientMachine;
        this.clientNode = clientNode;
    }

    public INodeFileUnderConstruction(INodeFile that, String clientName, String clientMachine, DatanodeDescriptor clientNode) {
        super(that);
        this.clientName = clientName;
        this.clientMachine = clientMachine;
        this.clientNode = clientNode;
    }

    public String getClientName() {
        return this.clientName;
    }

    void setClientName(String newName) {
        this.clientName = newName;
    }

    public String getClientMachine() {
        return this.clientMachine;
    }

    public DatanodeDescriptor getClientNode() {
        return this.clientNode;
    }

    @Override
    public final boolean isUnderConstruction() {
        return true;
    }

    @Override
    public INodeFileUnderConstruction recordModification(Snapshot latest, INodeMap inodeMap) throws QuotaExceededException {
        if (this.isInLatestSnapshot(latest)) {
            INodeFileUnderConstructionWithSnapshot newFile = this.getParent().replaceChild4INodeFileUcWithSnapshot(this, inodeMap).recordModification(latest, inodeMap);
            return newFile;
        }
        return this;
    }

    DatanodeDescriptor[] getTargets() {
        return this.targets;
    }

    void setTargets(DatanodeDescriptor[] targets) {
        this.targets = targets;
        this.primaryNodeIndex = -1;
    }

    void addTarget(DatanodeDescriptor node) {
        if (this.targets == null) {
            this.targets = new DatanodeDescriptor[0];
        }
        for (int j = 0; j < this.targets.length; ++j) {
            if (!this.targets[j].equals(node)) continue;
            return;
        }
        DatanodeDescriptor[] newt = new DatanodeDescriptor[this.targets.length + 1];
        for (int i = 0; i < this.targets.length; ++i) {
            newt[i] = this.targets[i];
        }
        newt[this.targets.length] = node;
        this.targets = newt;
        this.primaryNodeIndex = -1;
    }

    protected INodeFile toINodeFile(long mtime) {
        INodeFile f = new INodeFile(this.getId(), this.getLocalNameBytes(), this.getPermissionStatus(), mtime, this.getModificationTime(), this.getBlocks(), this.getFileReplication(), this.getPreferredBlockSize());
        f.setParent(this.getParent());
        return f;
    }

    void removeBlock(Block oldblock) throws IOException {
        BlocksMap.BlockInfo[] blocks = this.getBlocks();
        if (blocks == null) {
            throw new IOException("Trying to delete non-existant block " + oldblock);
        }
        int size_1 = blocks.length - 1;
        if (!blocks[size_1].equals(oldblock)) {
            throw new IOException("Trying to delete non-last block " + oldblock);
        }
        BlocksMap.BlockInfo[] newlist = new BlocksMap.BlockInfo[size_1];
        System.arraycopy(blocks, 0, newlist, 0, size_1);
        this.setBlocks(newlist);
        this.targets = null;
    }

    synchronized void setLastBlock(BlocksMap.BlockInfo newblock, DatanodeDescriptor[] newtargets) throws IOException {
        BlocksMap.BlockInfo[] blocks = this.getBlocks();
        if (blocks == null || blocks.length == 0) {
            throw new IOException("Trying to update non-existant block (newblock=" + newblock + ")");
        }
        BlocksMap.BlockInfo oldLast = blocks[blocks.length - 1];
        if (oldLast.getBlockId() != newblock.getBlockId()) {
            NameNode.stateChangeLog.error((Object)("Trying to commit block synchronization for an internal block on inode=" + this + " newblock=" + newblock + " oldLast=" + oldLast));
            throw new IOException("Trying to update an internal block of pending file " + this);
        }
        if (oldLast.getGenerationStamp() > newblock.getGenerationStamp()) {
            NameNode.stateChangeLog.warn((Object)("Updating last block " + oldLast + " of inode " + "under construction " + this + " with a block that " + "has an older generation stamp: " + newblock));
        }
        blocks[blocks.length - 1] = newblock;
        this.setTargets(newtargets);
        this.lastRecoveryTime = 0L;
    }

    void assignPrimaryDatanode() {
        if (this.targets.length == 0) {
            NameNode.stateChangeLog.warn((Object)"BLOCK* INodeFileUnderConstruction.initLeaseRecovery: No blocks found, lease removed.");
        }
        int previous = this.primaryNodeIndex;
        for (int i = 1; i <= this.targets.length; ++i) {
            int j = (previous + i) % this.targets.length;
            if (!this.targets[j].isAlive) continue;
            this.primaryNodeIndex = j;
            DatanodeDescriptor primary = this.targets[this.primaryNodeIndex];
            BlocksMap.BlockInfo[] blocks = this.getBlocks();
            primary.addBlockToBeRecovered(blocks[blocks.length - 1], this.targets);
            NameNode.stateChangeLog.info((Object)("BLOCK* " + blocks[blocks.length - 1] + " recovery started, primary=" + primary));
            return;
        }
    }

    synchronized boolean setLastRecoveryTime(long now) {
        boolean expired;
        boolean bl = expired = now - this.lastRecoveryTime > 10000L;
        if (expired) {
            this.lastRecoveryTime = now;
        }
        return expired;
    }

    void updateLengthOfLastBlock(long lastBlockLength) throws IOException {
        BlocksMap.BlockInfo[] blocks = this.getBlocks();
        assert (blocks != null) : "Blocks for path " + this.getFullPathName() + " is null when updating its last block length";
        BlocksMap.BlockInfo lastBlock = blocks[blocks.length - 1];
        assert (lastBlock != null) : "The last block for path " + this.getFullPathName() + " is null when updating its length";
        lastBlock.setNumBytes(lastBlockLength);
    }
}

