/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class INodeId
implements Comparable<INodeId> {
    public static final long LAST_RESERVED_ID = 16384L;
    public static final long ROOT_INODE_ID = 16385L;
    public static final long GRANDFATHER_INODE_ID = 0L;
    private AtomicLong lastInodeId = new AtomicLong();

    INodeId() {
        this.lastInodeId.set(16385L);
    }

    void resetLastInodeId(long newValue) throws IOException {
        if (newValue < this.getLastInodeId()) {
            throw new IOException("Can't reset lastInodeId to be less than its current value " + this.getLastInodeId() + ", newValue=" + newValue);
        }
        this.lastInodeId.set(newValue);
    }

    void resetLastInodeIdWithoutChecking(long newValue) {
        this.lastInodeId.set(newValue);
    }

    long getLastInodeId() {
        return this.lastInodeId.get();
    }

    long allocateNewInodeId() {
        return this.lastInodeId.incrementAndGet();
    }

    @Override
    public int compareTo(INodeId that) {
        long id2;
        long id1 = this.getLastInodeId();
        return id1 < (id2 = that.getLastInodeId()) ? -1 : (id1 > id2 ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (!(o instanceof INodeId)) {
            return false;
        }
        return this.compareTo((INodeId)o) == 0;
    }

    public int hashCode() {
        long id = this.getLastInodeId();
        return (int)(id ^ id >>> 32);
    }
}

