/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeFileUnderConstruction;
import org.apache.hadoop.hdfs.server.namenode.snapshot.AbstractINodeDiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.INodeFileUnderConstructionWithSnapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;

@InterfaceAudience.Private
public class FileDiffList
extends AbstractINodeDiffList<INodeFile, FileWithSnapshot.FileDiff> {
    @Override
    FileWithSnapshot.FileDiff createDiff(Snapshot snapshot, INodeFile file) {
        return new FileWithSnapshot.FileDiff(snapshot, file);
    }

    @Override
    INodeFile createSnapshotCopy(INodeFile currentINode) {
        if (currentINode instanceof INodeFileUnderConstructionWithSnapshot) {
            INodeFileUnderConstruction uc = (INodeFileUnderConstruction)currentINode;
            INodeFileUnderConstruction copy = new INodeFileUnderConstruction(uc, uc.getClientName(), uc.getClientMachine(), uc.getClientNode());
            copy.setBlocks(null);
            return copy;
        }
        INodeFile copy = new INodeFile(currentINode);
        copy.setBlocks(null);
        return copy;
    }
}

