/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.namenode.BlocksMap;
import org.apache.hadoop.hdfs.server.namenode.FSImageSerialization;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.Quota;
import org.apache.hadoop.hdfs.server.namenode.snapshot.AbstractINodeDiff;
import org.apache.hadoop.hdfs.server.namenode.snapshot.FileDiffList;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotFSImageFormat;

@InterfaceAudience.Private
public interface FileWithSnapshot {
    public INodeFile asINodeFile();

    public FileDiffList getDiffs();

    public boolean isCurrentFileDeleted();

    public void deleteCurrentFile();

    public static class Util {
        public static short getBlockReplication(FileWithSnapshot file) {
            short max = file.isCurrentFileDeleted() ? (short)0 : file.asINodeFile().getFileReplication();
            for (FileDiff d : file.getDiffs()) {
                short replication;
                if (d.snapshotINode == null || (replication = ((INodeFile)d.snapshotINode).getFileReplication()) <= max) continue;
                max = replication;
            }
            return max;
        }

        static void collectBlocksAndClear(FileWithSnapshot file, INode.BlocksMapUpdateInfo info, List<INode> removedINodes) {
            FileDiff last;
            if (file.isCurrentFileDeleted() && file.getDiffs().asList().isEmpty()) {
                file.asINodeFile().destroyAndCollectBlocks(info, removedINodes);
                return;
            }
            long max = file.isCurrentFileDeleted() ? ((last = (FileDiff)file.getDiffs().getLast()) == null ? 0L : last.fileSize) : file.asINodeFile().computeFileSize();
            Util.collectBlocksBeyondMax(file, max, info);
        }

        private static void collectBlocksBeyondMax(FileWithSnapshot file, long max, INode.BlocksMapUpdateInfo collectedBlocks) {
            BlocksMap.BlockInfo[] oldBlocks = file.asINodeFile().getBlocks();
            if (oldBlocks != null) {
                int n = 0;
                for (long size = 0L; n < oldBlocks.length && max > size; size += oldBlocks[n].getNumBytes(), ++n) {
                }
                if (n < oldBlocks.length) {
                    BlocksMap.BlockInfo[] newBlocks;
                    if (n == 0) {
                        newBlocks = null;
                    } else {
                        newBlocks = new BlocksMap.BlockInfo[n];
                        System.arraycopy(oldBlocks, 0, newBlocks, 0, n);
                    }
                    file.asINodeFile().setBlocks(newBlocks);
                    if (collectedBlocks != null) {
                        while (n < oldBlocks.length) {
                            collectedBlocks.addDeleteBlock(oldBlocks[n]);
                            ++n;
                        }
                    }
                }
            }
        }
    }

    public static class FileDiff
    extends AbstractINodeDiff<INodeFile, FileDiff> {
        private final long fileSize;

        FileDiff(Snapshot snapshot, INodeFile file) {
            super(snapshot, null, null);
            this.fileSize = file.computeFileSize();
        }

        FileDiff(Snapshot snapshot, INodeFile snapshotINode, FileDiff posteriorDiff, long fileSize) {
            super(snapshot, snapshotINode, posteriorDiff);
            this.fileSize = fileSize;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        private static Quota.Counts updateQuotaAndCollectBlocks(INodeFile currentINode, FileDiff removed, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
            FileWithSnapshot sFile = (FileWithSnapshot)((Object)currentINode);
            long oldDiskspace = currentINode.diskspaceConsumed();
            if (removed.snapshotINode != null) {
                short replication = ((INodeFile)removed.snapshotINode).getFileReplication();
                short currentRepl = currentINode.getBlockReplication();
                if (currentRepl == 0) {
                    oldDiskspace = currentINode.computeFileSize(true, true) * (long)replication;
                } else if (replication > currentRepl) {
                    oldDiskspace = oldDiskspace / (long)currentINode.getBlockReplication() * (long)replication;
                }
            }
            Util.collectBlocksAndClear(sFile, collectedBlocks, removedINodes);
            long dsDelta = oldDiskspace - currentINode.diskspaceConsumed();
            return Quota.Counts.newInstance(0L, dsDelta);
        }

        @Override
        Quota.Counts combinePosteriorAndCollectBlocks(INodeFile currentINode, FileDiff posterior, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
            return FileDiff.updateQuotaAndCollectBlocks(currentINode, posterior, collectedBlocks, removedINodes);
        }

        @Override
        public String toString() {
            return super.toString() + " fileSize=" + this.fileSize + ", rep=" + (this.snapshotINode == null ? "?" : Short.valueOf(((INodeFile)this.snapshotINode).getFileReplication()));
        }

        @Override
        void write(DataOutput out, SnapshotFSImageFormat.ReferenceMap referenceMap) throws IOException {
            this.writeSnapshot(out);
            out.writeLong(this.fileSize);
            if (this.snapshotINode != null) {
                out.writeBoolean(true);
                FSImageSerialization.writeINodeFile((INodeFile)this.snapshotINode, out, true);
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        Quota.Counts destroyDiffAndCollectBlocks(INodeFile currentINode, INode.BlocksMapUpdateInfo collectedBlocks, List<INode> removedINodes) {
            return FileDiff.updateQuotaAndCollectBlocks(currentINode, this, collectedBlocks, removedINodes);
        }
    }
}

