/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.filecache.TaskDistributedCacheManager;
import org.apache.hadoop.filecache.TrackerDistributedCacheManager;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.DefaultTaskController;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.JobEndNotifier;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobLocalizer;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobQueueInfo;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.JobSubmissionProtocol;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.hadoop.mapred.JobTrackerInstrumentation;
import org.apache.hadoop.mapred.JvmContext;
import org.apache.hadoop.mapred.JvmTask;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.MapTaskCompletionEventsUpdate;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.QueueAclsInfo;
import org.apache.hadoop.mapred.QueueMetrics;
import org.apache.hadoop.mapred.ReduceTask;
import org.apache.hadoop.mapred.SortedRanges;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapred.TaskReport;
import org.apache.hadoop.mapred.TaskRunner;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.split.SplitMetaInfoReader;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.token.Token;

public class LocalJobRunner
implements JobSubmissionProtocol {
    public static final Log LOG = LogFactory.getLog(LocalJobRunner.class);
    public static final String LOCAL_MAX_MAPS = "mapreduce.local.map.tasks.maximum";
    private FileSystem fs;
    private HashMap<JobID, Job> jobs = new HashMap();
    private JobConf conf;
    private AtomicInteger map_tasks = new AtomicInteger(0);
    private int reduce_tasks = 0;
    final Random rand = new Random();
    private final TaskController taskController = new DefaultTaskController();
    private JobTrackerInstrumentation myMetrics = null;
    private QueueMetrics queueMetrics = null;
    private static final String jobDir = "localRunner/";
    private static int jobid = 0;
    private int randid;

    @Override
    public long getProtocolVersion(String protocol, long clientVersion) {
        return 28L;
    }

    public LocalJobRunner(JobConf conf) throws IOException {
        this.fs = FileSystem.getLocal(conf);
        this.conf = conf;
        this.myMetrics = JobTrackerInstrumentation.create(null, new JobConf(conf));
        this.queueMetrics = QueueMetrics.create(conf.getQueueName(), new JobConf(conf));
        this.taskController.setConf(conf);
    }

    @Override
    public synchronized JobID getNewJobId() {
        return new JobID("local" + this.randid, ++jobid);
    }

    @Override
    public JobStatus submitJob(JobID jobid, String jobSubmitDir, Credentials credentials) throws IOException {
        Job job = new Job(jobid, jobSubmitDir);
        job.job.setCredentials(credentials);
        return job.status;
    }

    @Override
    public void killJob(JobID id) {
        this.jobs.get((Object)id).killed = true;
        this.jobs.get(id).interrupt();
    }

    @Override
    public void setJobPriority(JobID id, String jp) throws IOException {
        throw new UnsupportedOperationException("Changing job priority in LocalJobRunner is not supported.");
    }

    @Override
    public boolean killTask(TaskAttemptID taskId, boolean shouldFail) throws IOException {
        throw new UnsupportedOperationException("Killing tasks in LocalJobRunner is not supported");
    }

    @Override
    public JobProfile getJobProfile(JobID id) {
        Job job = this.jobs.get(id);
        if (job != null) {
            return job.getProfile();
        }
        return null;
    }

    @Override
    public TaskReport[] getMapTaskReports(JobID id) {
        return new TaskReport[0];
    }

    @Override
    public TaskReport[] getReduceTaskReports(JobID id) {
        return new TaskReport[0];
    }

    @Override
    public TaskReport[] getCleanupTaskReports(JobID id) {
        return new TaskReport[0];
    }

    @Override
    public TaskReport[] getSetupTaskReports(JobID id) {
        return new TaskReport[0];
    }

    @Override
    public JobStatus getJobStatus(JobID id) {
        Job job = this.jobs.get(id);
        if (job != null) {
            return job.status;
        }
        return null;
    }

    @Override
    public Counters getJobCounters(JobID id) {
        Job job = this.jobs.get(id);
        return job.getCurrentCounters();
    }

    @Override
    public String getFilesystemName() throws IOException {
        return this.fs.getUri().toString();
    }

    @Override
    public ClusterStatus getClusterStatus(boolean detailed) {
        int numMapTasks = this.map_tasks.get();
        return new ClusterStatus(1, 0, 0, 0L, numMapTasks, this.reduce_tasks, 1, 1, JobTracker.State.RUNNING);
    }

    @Override
    public JobStatus[] jobsToComplete() {
        return null;
    }

    @Override
    public TaskCompletionEvent[] getTaskCompletionEvents(JobID jobid, int fromEventId, int maxEvents) throws IOException {
        return TaskCompletionEvent.EMPTY_ARRAY;
    }

    @Override
    public JobStatus[] getAllJobs() {
        return null;
    }

    @Override
    public String[] getTaskDiagnostics(TaskAttemptID taskid) throws IOException {
        return new String[0];
    }

    @Override
    public String getSystemDir() {
        Path sysDir = new Path(this.conf.get("mapred.system.dir", "/tmp/hadoop/mapred/system"));
        return this.fs.makeQualified(sysDir).toString();
    }

    @Override
    public AccessControlList getQueueAdmins(String queueName) throws IOException {
        return new AccessControlList(" ");
    }

    @Override
    public String getStagingAreaDir() throws IOException {
        Path stagingRootDir = new Path(this.conf.get("mapreduce.jobtracker.staging.root.dir", "/tmp/hadoop/mapred/staging"));
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        this.randid = this.rand.nextInt(Integer.MAX_VALUE);
        String user = ugi != null ? ugi.getShortUserName() + this.randid : "dummy" + this.randid;
        return this.fs.makeQualified(new Path(stagingRootDir, user + "/.staging")).toString();
    }

    @Override
    public JobStatus[] getJobsFromQueue(String queue) throws IOException {
        return null;
    }

    @Override
    public JobQueueInfo[] getQueues() throws IOException {
        return null;
    }

    @Override
    public JobQueueInfo getQueueInfo(String queue) throws IOException {
        return null;
    }

    @Override
    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException {
        return null;
    }

    public static void setLocalMaxRunningMaps(org.apache.hadoop.mapreduce.JobContext job, int maxMaps) {
        job.getConfiguration().setInt(LOCAL_MAX_MAPS, maxMaps);
    }

    public static int getLocalMaxRunningMaps(org.apache.hadoop.mapreduce.JobContext job) {
        return job.getConfiguration().getInt(LOCAL_MAX_MAPS, 1);
    }

    @Override
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
    }

    @Override
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException, InterruptedException {
        return null;
    }

    @Override
    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
        return 0L;
    }

    private class Job
    extends Thread
    implements TaskUmbilicalProtocol {
        private Path systemJobDir;
        private Path systemJobFile;
        private Path localJobDir;
        private Path localJobFile;
        private JobID id;
        private JobConf job;
        private int numMapTasks;
        private float[] partialMapProgress;
        private Counters[] mapCounters;
        private Counters reduceCounters;
        private JobStatus status;
        private List<TaskAttemptID> mapIds = Collections.synchronizedList(new ArrayList());
        private JobProfile profile;
        private FileSystem localFs;
        boolean killed = false;
        private TrackerDistributedCacheManager trackerDistributedCacheManager;
        private TaskDistributedCacheManager taskDistributedCacheManager;

        @Override
        public long getProtocolVersion(String protocol, long clientVersion) {
            return 19L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Job(JobID jobid, String jobSubmitDir) throws IOException {
            this.systemJobDir = new Path(jobSubmitDir);
            this.systemJobFile = new Path(this.systemJobDir, "job.xml");
            this.id = jobid;
            this.localFs = FileSystem.getLocal(LocalJobRunner.this.conf);
            this.localJobDir = this.localFs.makeQualified(LocalJobRunner.this.conf.getLocalPath(LocalJobRunner.jobDir));
            this.localJobFile = new Path(this.localJobDir, this.id + ".xml");
            this.trackerDistributedCacheManager = new TrackerDistributedCacheManager(LocalJobRunner.this.conf, LocalJobRunner.this.taskController);
            this.taskDistributedCacheManager = this.trackerDistributedCacheManager.newTaskDistributedCacheManager(jobid, LocalJobRunner.this.conf);
            this.taskDistributedCacheManager.setupCache(LocalJobRunner.this.conf, "archive", "archive");
            JobLocalizer.downloadPrivateCache(LocalJobRunner.this.conf);
            if (DistributedCache.getSymlink(LocalJobRunner.this.conf)) {
                LOG.warn((Object)"LocalJobRunner does not support symlinking into current working dir.");
            }
            TaskRunner.setupWorkDir(LocalJobRunner.this.conf, new File(this.localJobDir.toUri()).getAbsoluteFile());
            FSDataOutputStream out = this.localFs.create(this.localJobFile);
            try {
                LocalJobRunner.this.conf.writeXml(out);
            }
            finally {
                ((OutputStream)out).close();
            }
            this.job = new JobConf(this.localJobFile);
            if (!this.taskDistributedCacheManager.getClassPaths().isEmpty()) {
                this.setContextClassLoader(this.taskDistributedCacheManager.makeClassLoader(this.getContextClassLoader()));
            }
            this.profile = new JobProfile(this.job.getUser(), this.id, this.systemJobFile.toString(), "http://localhost:8080/", this.job.getJobName());
            this.status = new JobStatus(this.id, 0.0f, 0.0f, 1);
            LocalJobRunner.this.jobs.put(this.id, this);
            this.start();
        }

        JobProfile getProfile() {
            return this.profile;
        }

        protected List<MapTaskRunnable> getMapTaskRunnables(JobSplit.TaskSplitMetaInfo[] taskInfo, JobID jobId, Map<TaskAttemptID, MapOutputFile> mapOutputFiles) {
            int numTasks = 0;
            ArrayList<MapTaskRunnable> list = new ArrayList<MapTaskRunnable>();
            for (JobSplit.TaskSplitMetaInfo task : taskInfo) {
                list.add(new MapTaskRunnable(task, numTasks++, jobId, mapOutputFiles));
            }
            return list;
        }

        private synchronized void initCounters(int numMaps) {
            this.partialMapProgress = new float[numMaps];
            this.mapCounters = new Counters[numMaps];
            for (int i = 0; i < numMaps; ++i) {
                this.mapCounters[i] = new Counters();
            }
            this.reduceCounters = new Counters();
        }

        protected ExecutorService createMapExecutor(int numMapTasks) {
            int maxMapThreads = this.job.getInt(LocalJobRunner.LOCAL_MAX_MAPS, 1);
            if (maxMapThreads < 1) {
                throw new IllegalArgumentException("Configured mapreduce.local.map.tasks.maximum must be >= 1");
            }
            this.numMapTasks = numMapTasks;
            maxMapThreads = Math.min(maxMapThreads, this.numMapTasks);
            maxMapThreads = Math.max(maxMapThreads, 1);
            this.initCounters(this.numMapTasks);
            LOG.debug((Object)"Starting thread pool executor.");
            LOG.debug((Object)("Max local threads: " + maxMapThreads));
            LOG.debug((Object)("Map tasks to process: " + this.numMapTasks));
            ExecutorService executor = Executors.newFixedThreadPool(maxMapThreads);
            return executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            JobID jobId = this.profile.getJobID();
            JobContext jContext = new JobContext(LocalJobRunner.this.conf, (org.apache.hadoop.mapreduce.JobID)jobId);
            OutputCommitter outputCommitter = this.job.getOutputCommitter();
            try {
                block30: {
                    JobSplit.TaskSplitMetaInfo[] taskSplitMetaInfos = SplitMetaInfoReader.readSplitMetaInfo(jobId, this.localFs, LocalJobRunner.this.conf, this.systemJobDir);
                    int numReduceTasks = this.job.getNumReduceTasks();
                    if (numReduceTasks > 1 || numReduceTasks < 0) {
                        numReduceTasks = 1;
                        this.job.setNumReduceTasks(1);
                    }
                    outputCommitter.setupJob(jContext);
                    this.status.setSetupProgress(1.0f);
                    Map<TaskAttemptID, MapOutputFile> mapOutputFiles = Collections.synchronizedMap(new HashMap());
                    List<MapTaskRunnable> taskRunnables = this.getMapTaskRunnables(taskSplitMetaInfos, jobId, mapOutputFiles);
                    ExecutorService mapService = this.createMapExecutor(taskRunnables.size());
                    for (MapTaskRunnable r : taskRunnables) {
                        mapService.submit(r);
                    }
                    try {
                        mapService.shutdown();
                        LOG.info((Object)"Waiting for map tasks");
                        mapService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                    }
                    catch (InterruptedException ie) {
                        mapService.shutdownNow();
                        throw ie;
                    }
                    LOG.info((Object)"Map task executor complete.");
                    for (MapTaskRunnable r : taskRunnables) {
                        if (r.storedException == null) continue;
                        throw new Exception(r.storedException);
                    }
                    TaskAttemptID reduceId = new TaskAttemptID(new TaskID(jobId, false, 0), 0);
                    try {
                        if (numReduceTasks <= 0) break block30;
                        ReduceTask reduce = new ReduceTask(this.systemJobFile.toString(), reduceId, 0, this.mapIds.size(), 1);
                        reduce.setUser(UserGroupInformation.getCurrentUser().getShortUserName());
                        JobConf localConf = new JobConf(this.job);
                        localConf.set("mapreduce.jobtracker.address", "local");
                        TaskRunner.setupChildMapredLocalDirs(reduce, localConf);
                        for (int i = 0; i < this.mapIds.size(); ++i) {
                            if (!this.isInterrupted()) {
                                TaskAttemptID mapId = this.mapIds.get(i);
                                Path mapOut = mapOutputFiles.get(mapId).getOutputFile();
                                MapOutputFile localOutputFile = new MapOutputFile();
                                localOutputFile.setConf(localConf);
                                Path reduceIn = localOutputFile.getInputFileForWrite(mapId.getTaskID(), this.localFs.getFileStatus(mapOut).getLen());
                                if (!this.localFs.mkdirs(reduceIn.getParent())) {
                                    throw new IOException("Mkdirs failed to create " + reduceIn.getParent().toString());
                                }
                                if (this.localFs.rename(mapOut, reduceIn)) continue;
                                throw new IOException("Couldn't rename " + mapOut);
                            }
                            throw new InterruptedException();
                        }
                        if (!this.isInterrupted()) {
                            reduce.setJobFile(this.localJobFile.toString());
                            localConf.setUser(reduce.getUser());
                            reduce.localizeConfiguration(localConf);
                            reduce.setConf(localConf);
                            LocalJobRunner.this.reduce_tasks += 1;
                            LocalJobRunner.this.myMetrics.launchReduce(reduce.getTaskID());
                            LocalJobRunner.this.queueMetrics.launchReduce(reduce.getTaskID());
                            reduce.run(localConf, this);
                            LocalJobRunner.this.myMetrics.completeReduce(reduce.getTaskID());
                            LocalJobRunner.this.queueMetrics.completeReduce(reduce.getTaskID());
                            LocalJobRunner.this.reduce_tasks -= 1;
                            break block30;
                        }
                        throw new InterruptedException();
                    }
                    finally {
                        for (MapOutputFile output : mapOutputFiles.values()) {
                            output.removeAll();
                        }
                    }
                }
                outputCommitter.commitJob(jContext);
                this.status.setCleanupProgress(1.0f);
                if (this.killed) {
                    this.status.setRunState(5);
                } else {
                    this.status.setRunState(2);
                }
                JobEndNotifier.localRunnerNotification(this.job, this.status);
            }
            catch (Throwable t) {
                try {
                    outputCommitter.abortJob(jContext, 3);
                }
                catch (IOException ioe) {
                    LOG.info((Object)("Error cleaning up job:" + this.id));
                }
                this.status.setCleanupProgress(1.0f);
                if (this.killed) {
                    this.status.setRunState(5);
                } else {
                    this.status.setRunState(3);
                }
                LOG.warn((Object)this.id, t);
                JobEndNotifier.localRunnerNotification(this.job, this.status);
            }
            finally {
                try {
                    LocalJobRunner.this.fs.delete(this.systemJobFile.getParent(), true);
                    this.localFs.delete(this.localJobFile, true);
                    this.taskDistributedCacheManager.release();
                    this.trackerDistributedCacheManager.purgeCache();
                }
                catch (IOException e) {
                    LOG.warn((Object)("Error cleaning up " + this.id + ": " + e));
                }
            }
        }

        @Override
        public JvmTask getTask(JvmContext context) {
            return null;
        }

        @Override
        public synchronized boolean statusUpdate(TaskAttemptID taskId, TaskStatus taskStatus, JvmContext context) throws IOException, InterruptedException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            TaskStatus.writeTaskStatus(dos, taskStatus);
            dos.close();
            taskStatus = TaskStatus.readTaskStatus(new DataInputStream(new ByteArrayInputStream(baos.toByteArray())));
            LOG.info((Object)taskStatus.getStateString());
            int taskIndex = this.mapIds.indexOf(taskId);
            if (taskIndex >= 0) {
                float numTasks = this.numMapTasks;
                this.partialMapProgress[taskIndex] = taskStatus.getProgress();
                this.mapCounters[taskIndex] = taskStatus.getCounters();
                float partialProgress = 0.0f;
                for (float f : this.partialMapProgress) {
                    partialProgress += f;
                }
                this.status.setMapProgress(partialProgress / numTasks);
            } else {
                this.reduceCounters = taskStatus.getCounters();
                this.status.setReduceProgress(taskStatus.getProgress());
            }
            return true;
        }

        public synchronized Counters getCurrentCounters() {
            if (null == this.mapCounters) {
                return new Counters();
            }
            Counters current = new Counters();
            for (Counters c : this.mapCounters) {
                current = Counters.sum(current, c);
            }
            current = Counters.sum(current, this.reduceCounters);
            return current;
        }

        @Override
        public void commitPending(TaskAttemptID taskid, TaskStatus taskStatus, JvmContext jvmContext) throws IOException, InterruptedException {
            this.statusUpdate(taskid, taskStatus, jvmContext);
        }

        @Override
        public void reportDiagnosticInfo(TaskAttemptID taskid, String trace, JvmContext jvmContext) {
        }

        @Override
        public void reportNextRecordRange(TaskAttemptID taskid, SortedRanges.Range range, JvmContext jvmContext) throws IOException {
            LOG.info((Object)("Task " + taskid + " reportedNextRecordRange " + range));
        }

        @Override
        public boolean ping(TaskAttemptID taskid, JvmContext jvmContext) throws IOException {
            return true;
        }

        @Override
        public boolean canCommit(TaskAttemptID taskid, JvmContext jvmContext) throws IOException {
            return true;
        }

        @Override
        public void done(TaskAttemptID taskId, JvmContext jvmContext) throws IOException {
        }

        @Override
        public synchronized void fsError(TaskAttemptID taskId, String message, JvmContext jvmContext) throws IOException {
            LOG.fatal((Object)("FSError: " + message + "from task: " + taskId));
        }

        @Override
        public void shuffleError(TaskAttemptID taskId, String message, JvmContext jvmContext) throws IOException {
            LOG.fatal((Object)("shuffleError: " + message + "from task: " + taskId));
        }

        @Override
        public synchronized void fatalError(TaskAttemptID taskId, String msg, JvmContext jvmContext) throws IOException {
            LOG.fatal((Object)("Fatal: " + msg + "from task: " + taskId));
        }

        @Override
        public MapTaskCompletionEventsUpdate getMapCompletionEvents(JobID jobId, int fromEventId, int maxLocs, TaskAttemptID id, JvmContext jvmContext) throws IOException {
            return new MapTaskCompletionEventsUpdate(TaskCompletionEvent.EMPTY_ARRAY, false);
        }

        @Override
        public void updatePrivateDistributedCacheSizes(org.apache.hadoop.mapreduce.JobID jobId, long[] sizes) throws IOException {
            this.trackerDistributedCacheManager.setArchiveSizes(jobId, sizes);
        }

        protected class MapTaskRunnable
        implements Runnable {
            private final int taskId;
            private final JobSplit.TaskSplitMetaInfo info;
            private final JobID jobId;
            private final JobConf localConf;
            private final Map<TaskAttemptID, MapOutputFile> mapOutputFiles;
            public volatile Throwable storedException;

            public MapTaskRunnable(JobSplit.TaskSplitMetaInfo info, int taskId, JobID jobId, Map<TaskAttemptID, MapOutputFile> mapOutputFiles) {
                this.info = info;
                this.taskId = taskId;
                this.mapOutputFiles = mapOutputFiles;
                this.jobId = jobId;
                this.localConf = new JobConf(Job.this.job);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    TaskAttemptID mapId = new TaskAttemptID(new TaskID(this.jobId, true, this.taskId), 0);
                    LOG.info((Object)("Starting task: " + mapId));
                    Job.this.mapIds.add(mapId);
                    MapTask map = new MapTask(Job.this.systemJobFile.toString(), mapId, this.taskId, this.info.getSplitIndex(), 1);
                    map.setUser(UserGroupInformation.getCurrentUser().getShortUserName());
                    TaskRunner.setupChildMapredLocalDirs(map, this.localConf);
                    MapOutputFile mapOutput = new MapOutputFile();
                    mapOutput.setConf(this.localConf);
                    this.mapOutputFiles.put(mapId, mapOutput);
                    map.setJobFile(Job.this.localJobFile.toString());
                    this.localConf.setUser(map.getUser());
                    map.localizeConfiguration(this.localConf);
                    map.setConf(this.localConf);
                    try {
                        LocalJobRunner.this.map_tasks.getAndIncrement();
                        LocalJobRunner.this.myMetrics.launchMap(mapId);
                        map.run(this.localConf, Job.this);
                        LocalJobRunner.this.myMetrics.completeMap(mapId);
                    }
                    finally {
                        LocalJobRunner.this.map_tasks.getAndDecrement();
                    }
                    LOG.info((Object)("Finishing task: " + mapId));
                }
                catch (Throwable e) {
                    this.storedException = e;
                }
            }
        }
    }
}

