/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mount;

import java.util.List;
import org.apache.hadoop.mount.MountEntry;
import org.apache.hadoop.oncrpc.RpcAcceptedReply;
import org.apache.hadoop.oncrpc.RpcAuthInfo;
import org.apache.hadoop.oncrpc.XDR;

public class MountResponse {
    public static int MNT_OK = 0;

    private MountResponse() {
    }

    public static XDR writeMNTResponse(int status, XDR xdr, int xid, byte[] handle) {
        RpcAcceptedReply.voidReply(xdr, xid);
        xdr.writeInt(status);
        if (status == MNT_OK) {
            xdr.writeInt(handle.length);
            xdr.writeFixedOpaque(handle);
            xdr.writeInt(1);
            xdr.writeInt(RpcAuthInfo.AuthFlavor.AUTH_SYS.getValue());
        }
        return xdr;
    }

    public static XDR writeMountList(XDR xdr, int xid, List<MountEntry> mounts) {
        RpcAcceptedReply.voidReply(xdr, xid);
        for (MountEntry mountEntry : mounts) {
            xdr.writeBoolean(true);
            xdr.writeString(mountEntry.host());
            xdr.writeString(mountEntry.path());
        }
        xdr.writeBoolean(false);
        return xdr;
    }

    public static XDR writeExportList(XDR xdr, int xid, List<String> exports) {
        RpcAcceptedReply.voidReply(xdr, xid);
        for (String export : exports) {
            xdr.writeBoolean(true);
            xdr.writeString(export);
            xdr.writeInt(0);
        }
        xdr.writeBoolean(false);
        return xdr;
    }
}

