/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IdUserGroup {
    static final Log LOG = LogFactory.getLog(IdUserGroup.class);
    private static final String OS = System.getProperty("os.name");
    static final String LINUX_GET_ALL_USERS_CMD = "getent passwd | cut -d: -f1,3";
    static final String LINUX_GET_ALL_GROUPS_CMD = "getent group | cut -d: -f1,3";
    static final String MAC_GET_ALL_USERS_CMD = "dscl . -list /Users UniqueID";
    static final String MAC_GET_ALL_GROUPS_CMD = "dscl . -list /Groups PrimaryGroupID";
    static final long TIMEOUT = 900000L;
    private static BiMap<Integer, String> uidNameMap = HashBiMap.create();
    private static BiMap<Integer, String> gidNameMap = HashBiMap.create();
    private long lastUpdateTime = 0L;

    public IdUserGroup() {
        this.updateMaps();
    }

    private boolean isExpired() {
        return this.lastUpdateTime - System.currentTimeMillis() > 900000L;
    }

    private void checkAndUpdateMaps() {
        if (this.isExpired()) {
            LOG.info((Object)"Update cache now");
            this.updateMaps();
        }
    }

    private void updateMapInternal(BiMap<Integer, String> map, String name, String command, String regex) throws IOException {
        Process process = Runtime.getRuntime().exec(new String[]{"bash", "-c", command});
        BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] nameId = line.split(regex);
            if (nameId == null || nameId.length != 2) {
                throw new IOException("Can't parse " + name + " list entry:" + line);
            }
            LOG.debug((Object)("add " + name + ":" + nameId[0] + " id:" + nameId[1]));
            map.put((Object)Integer.valueOf(nameId[1]), (Object)nameId[0]);
        }
        LOG.info((Object)("Updated " + name + " map size:" + map.size()));
    }

    public void updateMaps() {
        HashBiMap gMap;
        HashBiMap uMap;
        block4: {
            uMap = HashBiMap.create();
            gMap = HashBiMap.create();
            try {
                if (OS.startsWith("Linux")) {
                    this.updateMapInternal((BiMap<Integer, String>)uMap, "user", LINUX_GET_ALL_USERS_CMD, ":");
                    this.updateMapInternal((BiMap<Integer, String>)gMap, "group", LINUX_GET_ALL_GROUPS_CMD, ":");
                    break block4;
                }
                if (OS.startsWith("Mac")) {
                    this.updateMapInternal((BiMap<Integer, String>)uMap, "user", MAC_GET_ALL_USERS_CMD, "\\s+");
                    this.updateMapInternal((BiMap<Integer, String>)gMap, "group", MAC_GET_ALL_GROUPS_CMD, "\\s+");
                    break block4;
                }
                throw new IOException("Platform is not supported:" + OS);
            }
            catch (IOException e) {
                LOG.error((Object)("Can't update maps:" + e));
                return;
            }
        }
        uidNameMap = uMap;
        gidNameMap = gMap;
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public synchronized int getUid(String user) throws IOException {
        this.checkAndUpdateMaps();
        Integer id = (Integer)uidNameMap.inverse().get((Object)user);
        if (id == null) {
            throw new IOException("User just deleted?:" + user);
        }
        return id;
    }

    public synchronized int getGid(String group) throws IOException {
        this.checkAndUpdateMaps();
        Integer id = (Integer)gidNameMap.inverse().get((Object)group);
        if (id == null) {
            throw new IOException("No such group:" + group);
        }
        return id;
    }

    public synchronized String getUserName(int uid, String unknown) {
        this.checkAndUpdateMaps();
        String uname = (String)uidNameMap.get((Object)uid);
        if (uname == null) {
            uname = unknown;
        }
        return uname;
    }

    public synchronized String getGroupName(int gid, String unknown) {
        this.checkAndUpdateMaps();
        String gname = (String)gidNameMap.get((Object)gid);
        if (gname == null) {
            gname = unknown;
        }
        return gname;
    }

    public int getUidAllowingUnknown(String user) {
        int uid;
        this.checkAndUpdateMaps();
        try {
            uid = this.getUid(user);
        }
        catch (IOException e) {
            uid = user.hashCode();
            LOG.info((Object)("Can't map user " + user + ". Use its string hashcode:" + uid));
        }
        return uid;
    }

    public int getGidAllowingUnknown(String group) {
        int gid;
        this.checkAndUpdateMaps();
        try {
            gid = this.getGid(group);
        }
        catch (IOException e) {
            gid = group.hashCode();
            LOG.debug((Object)("Can't map group " + group + ". Use its string hashcode:" + gid));
        }
        return gid;
    }
}

