/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mount.MountdBase;
import org.apache.hadoop.oncrpc.RpcFrameDecoder;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.oncrpc.SimpleTcpServer;
import org.apache.hadoop.oncrpc.SimpleTcpServerHandler;
import org.apache.hadoop.portmap.PortmapMapping;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;

public abstract class Nfs3Base {
    public static final Log LOG = LogFactory.getLog(Nfs3Base.class);
    private final MountdBase mountd;
    private final RpcProgram rpcProgram;

    public MountdBase getMountBase() {
        return this.mountd;
    }

    public RpcProgram getRpcProgram() {
        return this.rpcProgram;
    }

    protected Nfs3Base(MountdBase mountd, RpcProgram program) {
        this.mountd = mountd;
        this.rpcProgram = program;
    }

    public void start() {
        this.mountd.start();
        this.rpcProgram.register(PortmapMapping.TRANSPORT_TCP);
        this.startTCPServer();
    }

    private void startTCPServer() {
        SimpleTcpServer tcpServer = new SimpleTcpServer(2049, this.rpcProgram, 0){

            @Override
            public ChannelPipelineFactory getPipelineFactory() {
                return new ChannelPipelineFactory(){

                    public ChannelPipeline getPipeline() {
                        return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new RpcFrameDecoder(), new SimpleTcpServerHandler(rpcProgram)});
                    }
                };
            }
        };
        tcpServer.run();
    }
}

