/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.response;

import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.Nfs3Status;
import org.apache.hadoop.nfs.nfs3.response.NFS3Response;
import org.apache.hadoop.nfs.nfs3.response.WccData;
import org.apache.hadoop.oncrpc.XDR;

public class CREATE3Response
extends NFS3Response {
    private final FileHandle objHandle;
    private final Nfs3FileAttributes postOpObjAttr;
    private WccData dirWcc;

    public CREATE3Response(int status) {
        this(status, null, null, null);
    }

    public CREATE3Response(int status, FileHandle handle, Nfs3FileAttributes postOpObjAttr, WccData dirWcc) {
        super(status);
        this.objHandle = handle;
        this.postOpObjAttr = postOpObjAttr;
        this.dirWcc = dirWcc;
    }

    public FileHandle getObjHandle() {
        return this.objHandle;
    }

    public Nfs3FileAttributes getPostOpObjAttr() {
        return this.postOpObjAttr;
    }

    public WccData getDirWcc() {
        return this.dirWcc;
    }

    @Override
    public XDR send(XDR out, int xid) {
        super.send(out, xid);
        if (this.getStatus() == Nfs3Status.NFS3_OK) {
            out.writeBoolean(true);
            this.objHandle.serialize(out);
            out.writeBoolean(true);
            this.postOpObjAttr.serialize(out);
        }
        if (this.dirWcc == null) {
            this.dirWcc = new WccData(null, null);
        }
        this.dirWcc.serialize(out);
        return out;
    }
}

