/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.response;

import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.Nfs3Status;
import org.apache.hadoop.nfs.nfs3.response.NFS3Response;
import org.apache.hadoop.oncrpc.XDR;

public class FSSTAT3Response
extends NFS3Response {
    private Nfs3FileAttributes postOpAttr;
    private final long tbytes;
    private final long fbytes;
    private final long abytes;
    private final long tfiles;
    private final long ffiles;
    private final long afiles;
    private final int invarsec;

    public FSSTAT3Response(int status) {
        this(status, null, 0L, 0L, 0L, 0L, 0L, 0L, 0);
    }

    public FSSTAT3Response(int status, Nfs3FileAttributes postOpAttr, long tbytes, long fbytes, long abytes, long tfiles, long ffiles, long afiles, int invarsec) {
        super(status);
        this.postOpAttr = postOpAttr;
        this.tbytes = tbytes;
        this.fbytes = fbytes;
        this.abytes = abytes;
        this.tfiles = tfiles;
        this.ffiles = ffiles;
        this.afiles = afiles;
        this.invarsec = invarsec;
    }

    @Override
    public XDR send(XDR out, int xid) {
        super.send(out, xid);
        out.writeBoolean(true);
        if (this.postOpAttr == null) {
            this.postOpAttr = new Nfs3FileAttributes();
        }
        this.postOpAttr.serialize(out);
        if (this.getStatus() == Nfs3Status.NFS3_OK) {
            out.writeLongAsHyper(this.tbytes);
            out.writeLongAsHyper(this.fbytes);
            out.writeLongAsHyper(this.abytes);
            out.writeLongAsHyper(this.tfiles);
            out.writeLongAsHyper(this.ffiles);
            out.writeLongAsHyper(this.afiles);
            out.writeInt(this.invarsec);
        }
        return out;
    }
}

