/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.response;

import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.Nfs3Status;
import org.apache.hadoop.nfs.nfs3.response.NFS3Response;
import org.apache.hadoop.oncrpc.XDR;

public class READDIR3Response
extends NFS3Response {
    private final Nfs3FileAttributes postOpDirAttr;
    private final long cookieVerf;
    private final DirList3 dirList;

    public READDIR3Response(int status) {
        this(status, new Nfs3FileAttributes());
    }

    public READDIR3Response(int status, Nfs3FileAttributes postOpAttr) {
        this(status, postOpAttr, 0L, null);
    }

    public READDIR3Response(int status, Nfs3FileAttributes postOpAttr, long cookieVerf, DirList3 dirList) {
        super(status);
        this.postOpDirAttr = postOpAttr;
        this.cookieVerf = cookieVerf;
        this.dirList = dirList;
    }

    public Nfs3FileAttributes getPostOpAttr() {
        return this.postOpDirAttr;
    }

    public long getCookieVerf() {
        return this.cookieVerf;
    }

    public DirList3 getDirList() {
        return this.dirList;
    }

    @Override
    public XDR send(XDR xdr, int xid) {
        super.send(xdr, xid);
        xdr.writeBoolean(true);
        this.postOpDirAttr.serialize(xdr);
        if (this.getStatus() == Nfs3Status.NFS3_OK) {
            xdr.writeLongAsHyper(this.cookieVerf);
            Entry3[] f = this.dirList.getEntries();
            for (int i = 0; i < f.length; ++i) {
                xdr.writeBoolean(true);
                xdr.writeLongAsHyper(f[i].getFileId());
                xdr.writeString(f[i].getName());
                xdr.writeLongAsHyper(f[i].getCookie());
            }
            xdr.writeBoolean(false);
            xdr.writeBoolean(this.dirList.getEof());
        }
        return xdr;
    }

    public static class DirList3 {
        private final Entry3[] entries;
        private final boolean eof;

        public DirList3(Entry3[] entries, boolean eof) {
            this.entries = entries;
            this.eof = eof;
        }

        public Entry3[] getEntries() {
            return this.entries;
        }

        public boolean getEof() {
            return this.eof;
        }
    }

    public static class Entry3 {
        private final long fileId;
        private final String name;
        private final long cookie;

        public Entry3(long fileId, String name, long cookie) {
            this.fileId = fileId;
            this.name = name;
            this.cookie = cookie;
        }

        long getFileId() {
            return this.fileId;
        }

        String getName() {
            return this.name;
        }

        long getCookie() {
            return this.cookie;
        }
    }
}

