/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.response;

import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.Nfs3Status;
import org.apache.hadoop.nfs.nfs3.response.NFS3Response;
import org.apache.hadoop.oncrpc.XDR;

public class READDIRPLUS3Response
extends NFS3Response {
    private Nfs3FileAttributes postOpDirAttr;
    private final long cookieVerf;
    private final DirListPlus3 dirListPlus;

    public READDIRPLUS3Response(int status) {
        this(status, null, 0L, null);
    }

    public READDIRPLUS3Response(int status, Nfs3FileAttributes postOpDirAttr, long cookieVerf, DirListPlus3 dirListPlus) {
        super(status);
        this.postOpDirAttr = postOpDirAttr;
        this.cookieVerf = cookieVerf;
        this.dirListPlus = dirListPlus;
    }

    @Override
    public XDR send(XDR out, int xid) {
        super.send(out, xid);
        out.writeBoolean(true);
        if (this.postOpDirAttr == null) {
            this.postOpDirAttr = new Nfs3FileAttributes();
        }
        this.postOpDirAttr.serialize(out);
        if (this.getStatus() == Nfs3Status.NFS3_OK) {
            out.writeLongAsHyper(this.cookieVerf);
            EntryPlus3[] f = this.dirListPlus.getEntries();
            for (int i = 0; i < f.length; ++i) {
                out.writeBoolean(true);
                f[i].seralize(out);
            }
            out.writeBoolean(false);
            out.writeBoolean(this.dirListPlus.getEof());
        }
        return out;
    }

    public static class DirListPlus3 {
        EntryPlus3[] entries;
        boolean eof;

        public DirListPlus3(EntryPlus3[] entries, boolean eof) {
            this.entries = entries;
            this.eof = eof;
        }

        EntryPlus3[] getEntries() {
            return this.entries;
        }

        boolean getEof() {
            return this.eof;
        }
    }

    public static class EntryPlus3 {
        private final long fileId;
        private final String name;
        private final long cookie;
        private final Nfs3FileAttributes nameAttr;
        private final FileHandle objFileHandle;

        public EntryPlus3(long fileId, String name, long cookie, Nfs3FileAttributes nameAttr, FileHandle objFileHandle) {
            this.fileId = fileId;
            this.name = name;
            this.cookie = cookie;
            this.nameAttr = nameAttr;
            this.objFileHandle = objFileHandle;
        }

        void seralize(XDR xdr) {
            xdr.writeLongAsHyper(this.fileId);
            xdr.writeString(this.name);
            xdr.writeLongAsHyper(this.cookie);
            xdr.writeBoolean(true);
            this.nameAttr.serialize(xdr);
            xdr.writeBoolean(true);
            this.objFileHandle.serialize(xdr);
        }
    }
}

