/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import org.apache.hadoop.oncrpc.RpcAuthInfo;
import org.apache.hadoop.oncrpc.RpcReply;
import org.apache.hadoop.oncrpc.XDR;

public class RpcAcceptedReply
extends RpcReply {
    private final RpcAuthInfo verifier;
    private final AcceptState acceptState;

    RpcAcceptedReply(int xid, int messageType, RpcReply.ReplyState state, RpcAuthInfo verifier, AcceptState acceptState) {
        super(xid, messageType, state);
        this.verifier = verifier;
        this.acceptState = acceptState;
    }

    public static RpcAcceptedReply read(int xid, int messageType, RpcReply.ReplyState replyState, XDR xdr) {
        RpcAuthInfo verifier = RpcAuthInfo.read(xdr);
        AcceptState acceptState = AcceptState.fromValue(xdr.readInt());
        return new RpcAcceptedReply(xid, messageType, replyState, verifier, acceptState);
    }

    public RpcAuthInfo getVerifier() {
        return this.verifier;
    }

    public AcceptState getAcceptState() {
        return this.acceptState;
    }

    public static XDR voidReply(XDR xdr, int xid) {
        return RpcAcceptedReply.voidReply(xdr, xid, AcceptState.SUCCESS);
    }

    public static XDR voidReply(XDR xdr, int xid, AcceptState acceptState) {
        xdr.writeInt(xid);
        xdr.writeInt(1);
        xdr.writeInt(RpcReply.ReplyState.MSG_ACCEPTED.getValue());
        xdr.writeInt(RpcAuthInfo.AuthFlavor.AUTH_NONE.getValue());
        xdr.writeVariableOpaque(new byte[0]);
        xdr.writeInt(acceptState.getValue());
        return xdr;
    }

    public static enum AcceptState {
        SUCCESS(0),
        PROG_UNAVAIL(1),
        PROG_MISMATCH(2),
        PROC_UNAVAIL(3),
        GARBAGE_ARGS(4),
        SYSTEM_ERR(5);

        private final int value;

        private AcceptState(int value) {
            this.value = value;
        }

        public static AcceptState fromValue(int value) {
            return AcceptState.values()[value];
        }

        public int getValue() {
            return this.value;
        }
    }
}

