/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import java.util.Arrays;
import org.apache.hadoop.oncrpc.XDR;

public class RpcAuthInfo {
    private final AuthFlavor flavor;
    private final byte[] body;

    protected RpcAuthInfo(AuthFlavor flavor, byte[] body) {
        this.flavor = flavor;
        this.body = body;
    }

    public static RpcAuthInfo read(XDR xdr) {
        int type = xdr.readInt();
        AuthFlavor flavor = AuthFlavor.fromValue(type);
        byte[] body = xdr.readVariableOpaque();
        return new RpcAuthInfo(flavor, body);
    }

    public AuthFlavor getFlavor() {
        return this.flavor;
    }

    public byte[] getBody() {
        return Arrays.copyOf(this.body, this.body.length);
    }

    public String toString() {
        return "(AuthFlavor:" + (Object)((Object)this.flavor) + ")";
    }

    public static enum AuthFlavor {
        AUTH_NONE(0),
        AUTH_SYS(1),
        AUTH_SHORT(2),
        AUTH_DH(3),
        RPCSEC_GSS(6);

        private int value;

        private AuthFlavor(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        static AuthFlavor fromValue(int value) {
            for (AuthFlavor v : AuthFlavor.values()) {
                if (v.value != value) continue;
                return v;
            }
            throw new IllegalArgumentException("Invalid AuthFlavor value " + value);
        }
    }
}

