/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.RpcAuthInfo;
import org.apache.hadoop.oncrpc.RpcMessage;
import org.apache.hadoop.oncrpc.XDR;

public class RpcCall
extends RpcMessage {
    public static final int RPC_VERSION = 2;
    private static final Log LOG = LogFactory.getLog(RpcCall.class);
    private final int rpcVersion;
    private final int program;
    private final int version;
    private final int procedure;
    private final RpcAuthInfo credential;
    private final RpcAuthInfo verifier;

    protected RpcCall(int xid, int messageType, int rpcVersion, int program, int version, int procedure, RpcAuthInfo credential, RpcAuthInfo verifier) {
        super(xid, messageType);
        this.rpcVersion = rpcVersion;
        this.program = program;
        this.version = version;
        this.procedure = procedure;
        this.credential = credential;
        this.verifier = verifier;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)this);
        }
        this.validate();
    }

    private void validateRpcVersion() {
        if (this.rpcVersion != 2) {
            throw new IllegalArgumentException("RPC version is expected to be 2 but got " + this.rpcVersion);
        }
    }

    public void validate() {
        this.validateMessageType(0);
        this.validateRpcVersion();
    }

    public int getRpcVersion() {
        return this.rpcVersion;
    }

    public int getProgram() {
        return this.program;
    }

    public int getVersion() {
        return this.version;
    }

    public int getProcedure() {
        return this.procedure;
    }

    public RpcAuthInfo getCredential() {
        return this.credential;
    }

    public RpcAuthInfo getVerifier() {
        return this.verifier;
    }

    public static RpcCall read(XDR xdr) {
        return new RpcCall(xdr.readInt(), xdr.readInt(), xdr.readInt(), xdr.readInt(), xdr.readInt(), xdr.readInt(), RpcAuthInfo.read(xdr), RpcAuthInfo.read(xdr));
    }

    public static void write(XDR out, int xid, int program, int progVersion, int procedure) {
        out.writeInt(xid);
        out.writeInt(0);
        out.writeInt(2);
        out.writeInt(program);
        out.writeInt(progVersion);
        out.writeInt(procedure);
    }

    public String toString() {
        return String.format("Xid:%d, messageType:%d, rpcVersion:%d, program:%d, version:%d, procedure:%d, credential:%s, verifier:%s", this.xid, this.messageType, this.rpcVersion, this.program, this.version, this.procedure, this.credential.toString(), this.verifier.toString());
    }
}

