/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import org.apache.hadoop.oncrpc.RpcAuthInfo;
import org.apache.hadoop.oncrpc.RpcReply;
import org.apache.hadoop.oncrpc.XDR;

public class RpcDeniedReply
extends RpcReply {
    private final RejectState rejectState;

    RpcDeniedReply(int xid, int messageType, RpcReply.ReplyState replyState, RejectState rejectState) {
        super(xid, messageType, replyState);
        this.rejectState = rejectState;
    }

    public static RpcDeniedReply read(int xid, int messageType, RpcReply.ReplyState replyState, XDR xdr) {
        RejectState rejectState = RejectState.fromValue(xdr.readInt());
        return new RpcDeniedReply(xid, messageType, replyState, rejectState);
    }

    public RejectState getRejectState() {
        return this.rejectState;
    }

    public String toString() {
        return new StringBuffer().append("xid:").append(this.xid).append(",messageType:").append(this.messageType).append("rejectState:").append((Object)this.rejectState).toString();
    }

    public static XDR voidReply(XDR xdr, int xid, RpcReply.ReplyState msgAccepted, RejectState rejectState) {
        xdr.writeInt(xid);
        xdr.writeInt(1);
        xdr.writeInt(msgAccepted.getValue());
        xdr.writeInt(RpcAuthInfo.AuthFlavor.AUTH_NONE.getValue());
        xdr.writeVariableOpaque(new byte[0]);
        xdr.writeInt(rejectState.getValue());
        return xdr;
    }

    public static enum RejectState {
        RPC_MISMATCH(0),
        AUTH_ERROR(1);

        private final int value;

        private RejectState(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }

        static RejectState fromValue(int value) {
            return RejectState.values()[value];
        }
    }
}

