/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

public abstract class RpcMessage {
    public static final int RPC_CALL = 0;
    public static final int RPC_REPLY = 1;
    protected final int xid;
    protected final int messageType;

    RpcMessage(int xid, int messageType) {
        if (messageType != 0 && messageType != 1) {
            throw new IllegalArgumentException("Invalid message type " + messageType);
        }
        this.xid = xid;
        this.messageType = messageType;
    }

    public int getXid() {
        return this.xid;
    }

    public int getMessageType() {
        return this.messageType;
    }

    protected void validateMessageType(int expected) {
        if (expected != this.messageType) {
            throw new IllegalArgumentException("Message type is expected to be " + expected + " but got " + this.messageType);
        }
    }
}

