/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import org.apache.hadoop.oncrpc.RpcAcceptedReply;
import org.apache.hadoop.oncrpc.RpcDeniedReply;
import org.apache.hadoop.oncrpc.RpcMessage;
import org.apache.hadoop.oncrpc.XDR;

public abstract class RpcReply
extends RpcMessage {
    private final ReplyState state;

    RpcReply(int xid, int messageType, ReplyState state) {
        super(xid, messageType);
        this.state = state;
        this.validateMessageType(1);
    }

    public static RpcReply read(XDR xdr) {
        int xid = xdr.readInt();
        int messageType = xdr.readInt();
        ReplyState stat = ReplyState.fromValue(xdr.readInt());
        switch (stat) {
            case MSG_ACCEPTED: {
                return RpcAcceptedReply.read(xid, messageType, stat, xdr);
            }
            case MSG_DENIED: {
                return RpcDeniedReply.read(xid, messageType, stat, xdr);
            }
        }
        return null;
    }

    public ReplyState getState() {
        return this.state;
    }

    public static enum ReplyState {
        MSG_ACCEPTED(0),
        MSG_DENIED(1);

        private final int value;

        private ReplyState(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }

        public static ReplyState fromValue(int value) {
            return ReplyState.values()[value];
        }
    }
}

