/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.SimpleTcpClient;
import org.apache.hadoop.oncrpc.XDR;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;

public class SimpleTcpClientHandler
extends SimpleChannelHandler {
    public static final Log LOG = LogFactory.getLog(SimpleTcpClient.class);
    protected final XDR request;

    public SimpleTcpClientHandler(XDR request) {
        this.request = request;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"sending PRC request");
        }
        ChannelBuffer outBuf = XDR.writeRequest(this.request, true);
        e.getChannel().write((Object)outBuf);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        e.getChannel().close();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        LOG.warn((Object)"Unexpected exception from downstream: ", e.getCause());
        e.getChannel().close();
    }
}

