/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.RpcFrameDecoder;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.oncrpc.SimpleTcpServerHandler;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

public class SimpleTcpServer {
    public static final Log LOG = LogFactory.getLog(SimpleTcpServer.class);
    protected final int port;
    protected final ChannelPipelineFactory pipelineFactory;
    protected final RpcProgram rpcProgram;
    protected final int workerCount;

    public SimpleTcpServer(int port, RpcProgram program, int workercount) {
        this.port = port;
        this.rpcProgram = program;
        this.workerCount = workercount;
        this.pipelineFactory = this.getPipelineFactory();
    }

    public ChannelPipelineFactory getPipelineFactory() {
        return new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() {
                return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new RpcFrameDecoder(), new SimpleTcpServerHandler(SimpleTcpServer.this.rpcProgram)});
            }
        };
    }

    public void run() {
        NioServerSocketChannelFactory factory = this.workerCount == 0 ? new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()) : new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool(), this.workerCount);
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)factory);
        bootstrap.setPipelineFactory(this.pipelineFactory);
        bootstrap.setOption("child.tcpNoDelay", (Object)true);
        bootstrap.setOption("child.keepAlive", (Object)true);
        try {
            bootstrap.bind((SocketAddress)new InetSocketAddress(this.port));
        }
        catch (ChannelException e) {
            LOG.error((Object)("Can't bind TCP port " + this.port + " for " + this.rpcProgram + ", error: " + (Object)((Object)e)));
            System.exit(-1);
        }
        LOG.info((Object)("Started listening to TCP requests at port " + this.port + " for " + this.rpcProgram + " with workerCount " + this.workerCount));
    }
}

