/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.oncrpc.XDR;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;

public class SimpleTcpServerHandler
extends SimpleChannelHandler {
    public static final Log LOG = LogFactory.getLog(SimpleTcpServerHandler.class);
    protected final RpcProgram rpcProgram;

    public SimpleTcpServerHandler(RpcProgram rpcProgram) {
        this.rpcProgram = rpcProgram;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        Channel outChannel;
        InetAddress remoteInetAddr;
        ChannelBuffer buf = (ChannelBuffer)e.getMessage();
        XDR request = new XDR(buf.array());
        XDR response = this.rpcProgram.handle(request, remoteInetAddr = ((InetSocketAddress)ctx.getChannel().getRemoteAddress()).getAddress(), outChannel = e.getChannel());
        if (response.size() > 0) {
            outChannel.write((Object)XDR.writeRequest(response, true));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        LOG.warn((Object)"Encountered ", e.getCause());
        e.getChannel().close();
    }
}

