/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.oncrpc.SimpleUdpServerHandler;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;

public class SimpleUdpServer {
    public static final Log LOG = LogFactory.getLog(SimpleUdpServer.class);
    private final int SEND_BUFFER_SIZE = 65536;
    private final int RECEIVE_BUFFER_SIZE = 65536;
    protected final int port;
    protected final ChannelPipelineFactory pipelineFactory;
    protected final RpcProgram rpcProgram;
    protected final int workerCount;

    public SimpleUdpServer(int port, RpcProgram program, int workerCount) {
        this.port = port;
        this.rpcProgram = program;
        this.workerCount = workerCount;
        this.pipelineFactory = new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() {
                return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new SimpleUdpServerHandler(SimpleUdpServer.this.rpcProgram)});
            }
        };
    }

    public void run() {
        NioDatagramChannelFactory f = new NioDatagramChannelFactory((Executor)Executors.newCachedThreadPool(), this.workerCount);
        ConnectionlessBootstrap b = new ConnectionlessBootstrap((ChannelFactory)f);
        ChannelPipeline p = b.getPipeline();
        p.addLast("handler", (ChannelHandler)new SimpleUdpServerHandler(this.rpcProgram));
        b.setOption("broadcast", (Object)"false");
        b.setOption("sendBufferSize", (Object)65536);
        b.setOption("receiveBufferSize", (Object)65536);
        try {
            b.bind((SocketAddress)new InetSocketAddress(this.port));
        }
        catch (ChannelException e) {
            LOG.error((Object)("Can't bind UDP port " + this.port + " for " + this.rpcProgram + ", error: " + (Object)((Object)e)));
            System.exit(-1);
        }
        LOG.info((Object)("Started listening to UDP requests at port " + this.port + " for " + this.rpcProgram + " with workerCount " + this.workerCount));
    }
}

