/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import com.google.common.annotations.VisibleForTesting;
import java.io.PrintStream;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class XDR {
    private static final String HEXES = "0123456789abcdef";
    private byte[] bytearr;
    private int cursor;

    public XDR() {
        this(new byte[0]);
    }

    public XDR(byte[] data) {
        this.bytearr = Arrays.copyOf(data, data.length);
        this.cursor = 0;
    }

    private void append(byte[] bytesToAdd) {
        this.bytearr = XDR.append(this.bytearr, bytesToAdd);
    }

    public int size() {
        return this.bytearr.length;
    }

    public void skip(int size) {
        this.cursor += size;
    }

    public void writeInt(int data) {
        this.append(XDR.toBytes(data));
    }

    public int readInt() {
        byte byte0 = this.bytearr[this.cursor++];
        byte byte1 = this.bytearr[this.cursor++];
        byte byte2 = this.bytearr[this.cursor++];
        byte byte3 = this.bytearr[this.cursor++];
        return (XDR.toShort(byte0) << 24) + (XDR.toShort(byte1) << 16) + (XDR.toShort(byte2) << 8) + XDR.toShort(byte3);
    }

    public void writeBoolean(boolean data) {
        this.writeInt(data ? 1 : 0);
    }

    public boolean readBoolean() {
        return this.readInt() != 0;
    }

    public void writeLongAsHyper(long data) {
        byte byte0 = (byte)((data & 0xFF00000000000000L) >> 56);
        byte byte1 = (byte)((data & 0xFF000000000000L) >> 48);
        byte byte2 = (byte)((data & 0xFF0000000000L) >> 40);
        byte byte3 = (byte)((data & 0xFF00000000L) >> 32);
        byte byte4 = (byte)((data & 0xFF000000L) >> 24);
        byte byte5 = (byte)((data & 0xFF0000L) >> 16);
        byte byte6 = (byte)((data & 0xFF00L) >> 8);
        byte byte7 = (byte)(data & 0xFFL);
        this.append(new byte[]{byte0, byte1, byte2, byte3, byte4, byte5, byte6, byte7});
    }

    public long readHyper() {
        byte byte0 = this.bytearr[this.cursor++];
        byte byte1 = this.bytearr[this.cursor++];
        byte byte2 = this.bytearr[this.cursor++];
        byte byte3 = this.bytearr[this.cursor++];
        byte byte4 = this.bytearr[this.cursor++];
        byte byte5 = this.bytearr[this.cursor++];
        byte byte6 = this.bytearr[this.cursor++];
        byte byte7 = this.bytearr[this.cursor++];
        return ((long)XDR.toShort(byte0) << 56) + ((long)XDR.toShort(byte1) << 48) + ((long)XDR.toShort(byte2) << 40) + ((long)XDR.toShort(byte3) << 32) + ((long)XDR.toShort(byte4) << 24) + ((long)XDR.toShort(byte5) << 16) + ((long)XDR.toShort(byte6) << 8) + (long)XDR.toShort(byte7);
    }

    public void writeFixedOpaque(byte[] data) {
        this.writeFixedOpaque(data, data.length);
    }

    public void writeFixedOpaque(byte[] data, int length) {
        this.append(Arrays.copyOf(data, length + XDR.pad(length, 4)));
    }

    public byte[] readFixedOpaque(int size) {
        int i;
        byte[] ret = new byte[size];
        for (i = 0; i < size; ++i) {
            ret[i] = this.bytearr[this.cursor];
            ++this.cursor;
        }
        for (i = 0; i < XDR.pad(size, 4); ++i) {
            ++this.cursor;
        }
        return ret;
    }

    public void writeVariableOpaque(byte[] data) {
        this.writeInt(data.length);
        this.writeFixedOpaque(data);
    }

    public byte[] readVariableOpaque() {
        int size = this.readInt();
        return size != 0 ? this.readFixedOpaque(size) : null;
    }

    public void skipVariableOpaque() {
        int length = this.readInt();
        this.skip(length + XDR.pad(length, 4));
    }

    public void writeString(String data) {
        this.writeVariableOpaque(data.getBytes());
    }

    public String readString() {
        return new String(this.readVariableOpaque());
    }

    public void dump(PrintStream out) {
        for (int i = 0; i < this.bytearr.length; i += 4) {
            out.println(XDR.hex(this.bytearr[i]) + " " + XDR.hex(this.bytearr[i + 1]) + " " + XDR.hex(this.bytearr[i + 2]) + " " + XDR.hex(this.bytearr[i + 3]));
        }
    }

    @VisibleForTesting
    public byte[] getBytes() {
        return Arrays.copyOf(this.bytearr, this.bytearr.length);
    }

    public static byte[] append(byte[] bytes, byte[] bytesToAdd) {
        byte[] newByteArray = new byte[bytes.length + bytesToAdd.length];
        System.arraycopy(bytes, 0, newByteArray, 0, bytes.length);
        System.arraycopy(bytesToAdd, 0, newByteArray, bytes.length, bytesToAdd.length);
        return newByteArray;
    }

    private static int pad(int x, int y) {
        return x % y == 0 ? 0 : y - x % y;
    }

    static byte[] toBytes(int n) {
        byte[] ret = new byte[]{(byte)((n & 0xFF000000) >> 24), (byte)((n & 0xFF0000) >> 16), (byte)((n & 0xFF00) >> 8), (byte)(n & 0xFF)};
        return ret;
    }

    private static short toShort(byte b) {
        return b < 0 ? (short)(b + 256) : (short)b;
    }

    private static String hex(byte b) {
        return "" + HEXES.charAt((b & 0xF0) >> 4) + HEXES.charAt(b & 0xF);
    }

    private static byte[] recordMark(int size, boolean last) {
        return XDR.toBytes(!last ? size : size | Integer.MIN_VALUE);
    }

    public static byte[] getVariableOpque(byte[] data) {
        byte[] bytes = XDR.toBytes(data.length);
        return XDR.append(bytes, Arrays.copyOf(data, data.length + XDR.pad(data.length, 4)));
    }

    public static int fragmentSize(byte[] mark) {
        int n = (XDR.toShort(mark[0]) << 24) + (XDR.toShort(mark[1]) << 16) + (XDR.toShort(mark[2]) << 8) + XDR.toShort(mark[3]);
        return n & Integer.MAX_VALUE;
    }

    public static boolean isLastFragment(byte[] mark) {
        int n = (XDR.toShort(mark[0]) << 24) + (XDR.toShort(mark[1]) << 16) + (XDR.toShort(mark[2]) << 8) + XDR.toShort(mark[3]);
        return (n & Integer.MIN_VALUE) != 0;
    }

    public static boolean verifyLength(XDR xdr, int len) {
        return xdr.bytearr.length - xdr.cursor >= len;
    }

    public static ChannelBuffer writeRequest(XDR request, boolean last) {
        byte[] fragmentHeader = XDR.recordMark(request.bytearr.length, last);
        ChannelBuffer outBuf = ChannelBuffers.buffer((int)(fragmentHeader.length + request.bytearr.length));
        outBuf.writeBytes(fragmentHeader);
        outBuf.writeBytes(request.bytearr);
        return outBuf;
    }

    public static ChannelBuffer writeResponse(XDR response) {
        ChannelBuffer outBuf = ChannelBuffers.buffer((int)response.bytearr.length);
        outBuf.writeBytes(response.bytearr);
        return outBuf;
    }
}

