/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.portmap;

import org.apache.hadoop.oncrpc.XDR;

public class PortmapMapping {
    public static int TRANSPORT_TCP = 6;
    public static int TRANSPORT_UDP = 17;
    private final int program;
    private final int version;
    private final int transport;
    private final int port;

    public PortmapMapping(int program, int version, int transport, int port) {
        this.program = program;
        this.version = version;
        this.transport = transport;
        this.port = port;
    }

    public XDR serialize(XDR xdr) {
        xdr.writeInt(this.program);
        xdr.writeInt(this.version);
        xdr.writeInt(this.transport);
        xdr.writeInt(this.port);
        return xdr;
    }

    public static PortmapMapping deserialize(XDR xdr) {
        return new PortmapMapping(xdr.readInt(), xdr.readInt(), xdr.readInt(), xdr.readInt());
    }

    public int getPort() {
        return this.port;
    }

    public static String key(PortmapMapping mapping) {
        return mapping.program + " " + mapping.version + " " + mapping.transport;
    }

    public String toString() {
        return String.format("(PortmapMapping-%d:%d:%d:%d)", this.program, this.version, this.transport, this.port);
    }
}

