/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;

public class MultiRealmUserAuthentication {
    private static final Log LOG = LogFactory.getLog(MultiRealmUserAuthentication.class);
    public static String KERBEROS_USER_REALM = "hadoop.security.authentication.user.realm";
    private static UserGroupInformation ugi;

    public static UserGroupInformation getServerUGIForUserRealm(Configuration conf) {
        if (ugi == null) {
            return MultiRealmUserAuthentication.getServerUGI(conf.get(KERBEROS_USER_REALM));
        }
        return ugi;
    }

    public static boolean isAUserInADifferentRealm(UserGroupInformation ticket, Configuration conf) {
        String fullName;
        String[] names;
        return MultiRealmUserAuthentication.isEnabled(conf) && (names = SaslRpcServer.splitKerberosName(fullName = ticket.getUserName())).length < 3 && fullName.toLowerCase().endsWith(conf.get(KERBEROS_USER_REALM).toLowerCase());
    }

    public static String replaceRealmWithUserRealm(String principalName, Configuration conf) {
        return MultiRealmUserAuthentication.replaceRealm(principalName, conf.get(KERBEROS_USER_REALM));
    }

    private static boolean isEnabled(Configuration conf) {
        return conf.get(KERBEROS_USER_REALM) != null;
    }

    private static synchronized UserGroupInformation getServerUGI(String userRealm) {
        try {
            UserGroupInformation current = UserGroupInformation.getCurrentUser();
            String principalName = current.getUserName();
            String principalInUserRealm = MultiRealmUserAuthentication.replaceRealm(principalName, userRealm);
            ugi = UserGroupInformation.loginServerFromCurrentKeytabAndReturnUGI(principalInUserRealm);
            return ugi;
        }
        catch (IOException e) {
            LOG.warn((Object)"Current user information cannot be obtained", (Throwable)e);
            return null;
        }
    }

    private static String replaceRealm(String principalName, String userRealm) {
        String[] parts = principalName.split("[/@]");
        if (parts.length > 2) {
            String[] serverParts = parts[1].split("[.]");
            String serverName = serverParts[0] + "." + userRealm.toLowerCase();
            return parts[0] + "/" + serverName + "@" + userRealm;
        }
        LOG.warn((Object)("The serverPrincipal = " + principalName + "doesn't confirm to the standards"));
        throw new IllegalArgumentException();
    }
}

