/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.compatibility;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.pentaho.di.compatibility.ValueBigNumber;
import org.pentaho.di.compatibility.ValueBinary;
import org.pentaho.di.compatibility.ValueBoolean;
import org.pentaho.di.compatibility.ValueDate;
import org.pentaho.di.compatibility.ValueInteger;
import org.pentaho.di.compatibility.ValueInterface;
import org.pentaho.di.compatibility.ValueNumber;
import org.pentaho.di.compatibility.ValueSerializable;
import org.pentaho.di.compatibility.ValueString;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleEOFException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueDataUtil;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.w3c.dom.Node;

public class Value
implements Cloneable,
XMLInterface,
Serializable {
    public static final String XML_TAG = "value";
    private static final long serialVersionUID = -6310073485210258622L;
    public static final int VALUE_TYPE_NONE = 0;
    public static final int VALUE_TYPE_NUMBER = 1;
    public static final int VALUE_TYPE_STRING = 2;
    public static final int VALUE_TYPE_DATE = 3;
    public static final int VALUE_TYPE_BOOLEAN = 4;
    public static final int VALUE_TYPE_INTEGER = 5;
    public static final int VALUE_TYPE_BIGNUMBER = 6;
    public static final int VALUE_TYPE_SERIALIZABLE = 7;
    public static final int VALUE_TYPE_BINARY = 8;
    private static final String[] valueTypeCode = new String[]{"-", "Number", "String", "Date", "Boolean", "Integer", "BigNumber", "Serializable", "Binary"};
    private ValueInterface value;
    private String name;
    private String origin;
    private boolean NULL;

    public Value() {
    }

    public Value(String name) {
        this.setName(name);
    }

    public Value(String name, int val_type) {
        this.newValue(val_type);
        this.setName(name);
    }

    private void newValue(int val_type) {
        switch (val_type) {
            case 5: {
                this.value = new ValueInteger();
                break;
            }
            case 2: {
                this.value = new ValueString();
                break;
            }
            case 3: {
                this.value = new ValueDate();
                break;
            }
            case 1: {
                this.value = new ValueNumber();
                break;
            }
            case 4: {
                this.value = new ValueBoolean();
                break;
            }
            case 6: {
                this.value = new ValueBigNumber();
                break;
            }
            case 8: {
                this.value = new ValueBinary();
                break;
            }
            default: {
                this.value = null;
            }
        }
    }

    private void convertTo(int valType) {
        if (this.value != null) {
            switch (valType) {
                case 1: {
                    this.value = new ValueNumber(this.value.getNumber());
                    break;
                }
                case 2: {
                    this.value = new ValueString(this.value.getString());
                    break;
                }
                case 3: {
                    this.value = new ValueDate(this.value.getDate());
                    break;
                }
                case 4: {
                    this.value = new ValueBoolean(this.value.getBoolean());
                    break;
                }
                case 5: {
                    this.value = new ValueInteger(this.value.getInteger());
                    break;
                }
                case 6: {
                    this.value = new ValueBigNumber(this.value.getBigNumber());
                    break;
                }
                case 8: {
                    this.value = new ValueBinary(this.value.getBytes());
                    break;
                }
                default: {
                    this.value = null;
                }
            }
        }
    }

    public Value(String name, int valType, int length, int precision) {
        this(name, valType);
        this.setLength(length, precision);
    }

    public Value(String name, BigDecimal bignum) {
        this.setValue(bignum);
        this.setName(name);
    }

    public Value(String name, double num) {
        this.setValue(num);
        this.setName(name);
    }

    public Value(String name, StringBuffer str) {
        this(name, str.toString());
    }

    public Value(String name, String str) {
        this.setValue(str);
        this.setName(name);
    }

    public Value(String name, Date dat) {
        this.setValue(dat);
        this.setName(name);
    }

    public Value(String name, boolean bool) {
        this.setValue(bool);
        this.setName(name);
    }

    public Value(String name, long l) {
        this.setValue(l);
        this.setName(name);
    }

    public Value(String name, Value v) {
        this(v);
        this.setName(name);
    }

    public Value(String name, byte[] b) {
        this.clearValue();
        this.setValue(b);
        this.setName(name);
    }

    public Value(Value v) {
        if (v != null) {
            this.value = v.getValueCopy();
            this.setName(v.getName());
            this.setLength(v.getLength(), v.getPrecision());
            this.setNull(v.isNull());
            this.setOrigin(v.origin);
        } else {
            this.clearValue();
            this.setNull(true);
        }
    }

    public Object clone() {
        Value retval = null;
        try {
            retval = (Value)super.clone();
            if (this.value != null) {
                retval.value = (ValueInterface)this.value.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            retval = null;
        }
        return retval;
    }

    public Value Clone() {
        Value v = new Value(this);
        return v;
    }

    public void clearValue() {
        this.value = null;
        this.name = null;
        this.NULL = false;
        this.origin = null;
    }

    private ValueInterface getValueCopy() {
        if (this.value == null) {
            return null;
        }
        return (ValueInterface)this.value.clone();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setOrigin(String step_of_origin) {
        this.origin = step_of_origin;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setValue(BigDecimal num) {
        if (this.value == null || this.value.getType() != 6) {
            this.value = new ValueBigNumber(num);
        } else {
            this.value.setBigNumber(num);
        }
        this.setNull(false);
    }

    public void setValue(double num) {
        if (this.value == null || this.value.getType() != 1) {
            this.value = new ValueNumber(num);
        } else {
            this.value.setNumber(num);
        }
        this.setNull(false);
    }

    public void setValue(StringBuffer str) {
        if (this.value == null || this.value.getType() != 2) {
            this.value = new ValueString(str.toString());
        } else {
            this.value.setString(str.toString());
        }
        this.setNull(str == null);
    }

    public void setValue(String str) {
        if (this.value == null || this.value.getType() != 2) {
            this.value = new ValueString(str);
        } else {
            this.value.setString(str);
        }
        this.setNull(str == null);
    }

    public void setSerializedValue(Serializable ser) {
        if (this.value == null || this.value.getType() != 7) {
            this.value = new ValueSerializable(ser);
        } else {
            this.value.setSerializable(ser);
        }
        this.setNull(ser == null);
    }

    public void setValue(Date dat) {
        if (this.value == null || this.value.getType() != 3) {
            this.value = new ValueDate(dat);
        } else {
            this.value.setDate(dat);
        }
        this.setNull(dat == null);
    }

    public void setValue(boolean bool) {
        if (this.value == null || this.value.getType() != 4) {
            this.value = new ValueBoolean(bool);
        } else {
            this.value.setBoolean(bool);
        }
        this.setNull(false);
    }

    public void setValue(Boolean b) {
        this.setValue((boolean)b);
    }

    public void setValue(byte b) {
        this.setValue((long)b);
    }

    public void setValue(int i) {
        this.setValue((long)i);
    }

    public void setValue(long l) {
        if (this.value == null || this.value.getType() != 5) {
            this.value = new ValueInteger(l);
        } else {
            this.value.setInteger(l);
        }
        this.setNull(false);
    }

    public void setValue(byte[] b) {
        if (this.value == null || this.value.getType() != 8) {
            this.value = new ValueBinary(b);
        } else {
            this.value.setBytes(b);
        }
        if (b == null) {
            this.setNull(true);
        } else {
            this.setNull(false);
        }
    }

    public void setValue(Value v) {
        if (v != null) {
            this.value = v.getValueCopy();
            this.setNull(v.isNull());
            this.setOrigin(v.origin);
        } else {
            this.clearValue();
        }
    }

    public BigDecimal getBigNumber() {
        if (this.value == null || this.isNull()) {
            return null;
        }
        return this.value.getBigNumber();
    }

    public double getNumber() {
        if (this.value == null || this.isNull()) {
            return 0.0;
        }
        return this.value.getNumber();
    }

    public String getString() {
        if (this.value == null || this.isNull()) {
            return null;
        }
        return this.value.getString();
    }

    public int getStringLength() {
        String s = this.getString();
        if (s == null) {
            return 0;
        }
        return s.length();
    }

    public Date getDate() {
        if (this.value == null || this.isNull()) {
            return null;
        }
        return this.value.getDate();
    }

    public Serializable getSerializable() {
        if (this.value == null || this.isNull() || this.value.getType() != 7) {
            return null;
        }
        return this.value.getSerializable();
    }

    public boolean getBoolean() {
        if (this.value == null || this.isNull()) {
            return false;
        }
        return this.value.getBoolean();
    }

    public long getInteger() {
        if (this.value == null || this.isNull()) {
            return 0L;
        }
        return this.value.getInteger();
    }

    public byte[] getBytes() {
        if (this.value == null || this.isNull()) {
            return null;
        }
        return this.value.getBytes();
    }

    public void setType(int val_type) {
        if (this.value == null) {
            this.newValue(val_type);
        } else {
            this.convertTo(val_type);
        }
    }

    public int getType() {
        if (this.value == null) {
            return 0;
        }
        return this.value.getType();
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public boolean isString() {
        if (this.value == null) {
            return false;
        }
        return this.value.getType() == 2;
    }

    public boolean isDate() {
        if (this.value == null) {
            return false;
        }
        return this.value.getType() == 3;
    }

    public boolean isBigNumber() {
        if (this.value == null) {
            return false;
        }
        return this.value.getType() == 6;
    }

    public boolean isNumber() {
        if (this.value == null) {
            return false;
        }
        return this.value.getType() == 1;
    }

    public boolean isBoolean() {
        if (this.value == null) {
            return false;
        }
        return this.value.getType() == 4;
    }

    public boolean isSerializableType() {
        if (this.value == null) {
            return false;
        }
        return this.value.getType() == 7;
    }

    public boolean isBinary() {
        if (this.value == null) {
            return false;
        }
        return this.value.getType() == 8;
    }

    public boolean isInteger() {
        if (this.value == null) {
            return false;
        }
        return this.value.getType() == 5;
    }

    public boolean isNumeric() {
        return this.isInteger() || this.isNumber() || this.isBigNumber();
    }

    public static final boolean isNumeric(int t) {
        return t == 5 || t == 1 || t == 6;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean pad) {
        String retval;
        switch (this.getType()) {
            case 2: {
                retval = this.toStringString(pad);
                break;
            }
            case 5: {
                retval = this.toStringInteger(pad);
                break;
            }
            case 1: {
                retval = this.toStringNumber(pad);
                break;
            }
            case 3: {
                retval = this.toStringDate();
                break;
            }
            case 4: {
                retval = this.toStringBoolean();
                break;
            }
            case 6: {
                retval = this.toStringBigNumber();
                break;
            }
            case 8: {
                retval = this.toStringBinary();
                break;
            }
            default: {
                retval = "";
            }
        }
        return retval;
    }

    public String toStringMeta() {
        StringBuffer retval = new StringBuffer(this.getTypeDesc());
        switch (this.getType()) {
            case 2: {
                if (this.getLength() <= 0) break;
                retval.append('(').append(this.getLength()).append(')');
                break;
            }
            case 1: 
            case 6: {
                if (this.getLength() <= 0) break;
                retval.append('(').append(this.getLength());
                if (this.getPrecision() > 0) {
                    retval.append(", ").append(this.getPrecision());
                }
                retval.append(')');
                break;
            }
            case 5: {
                if (this.getLength() <= 0) break;
                retval.append('(').append(this.getLength()).append(')');
                break;
            }
        }
        return retval.toString();
    }

    private String toStringString(boolean pad) {
        String retval = null;
        if (this.value == null) {
            return null;
        }
        if (this.value.getLength() <= 0) {
            retval = this.isNull() || this.value.getString() == null ? "" : this.value.getString();
        } else if (pad) {
            StringBuffer ret = this.isNull() || this.value.getString() == null ? new StringBuffer("") : new StringBuffer(this.value.getString());
            int length = this.value.getLength();
            if (length > 16384) {
                length = 16384;
            }
            Const.rightPad(ret, length);
            retval = ret.toString();
        } else {
            retval = this.isNull() || this.value.getString() == null ? "" : this.value.getString();
        }
        return retval;
    }

    private String toStringNumber(boolean pad) {
        String retval;
        if (this.value == null) {
            return null;
        }
        if (pad) {
            if (this.value.getLength() < 1) {
                if (this.isNull()) {
                    retval = "";
                } else {
                    DecimalFormat form = new DecimalFormat();
                    form.applyPattern(" ##########0.0########;-#########0.0########");
                    retval = form.format(this.value.getNumber());
                }
            } else if (this.isNull()) {
                StringBuffer ret = new StringBuffer("");
                Const.rightPad(ret, this.value.getLength());
                retval = ret.toString();
            } else {
                StringBuffer fmt = new StringBuffer();
                if (this.value.getNumber() >= 0.0) {
                    fmt.append(' ');
                }
                if (this.value.getPrecision() < 0) {
                    for (int i = 0; i < this.value.getLength(); ++i) {
                        fmt.append('0');
                    }
                    fmt.append(".00");
                } else {
                    for (int i = 0; i <= this.value.getLength(); ++i) {
                        fmt.append('0');
                    }
                    int pos = this.value.getLength() - this.value.getPrecision() + 1 - (this.value.getNumber() < 0.0 ? 1 : 0);
                    if (pos >= 0 && pos < fmt.length()) {
                        fmt.setCharAt(this.value.getLength() - this.value.getPrecision() + 1 - (this.value.getNumber() < 0.0 ? 1 : 0), '.');
                    }
                }
                DecimalFormat form = new DecimalFormat(fmt.toString());
                retval = form.format(this.value.getNumber());
            }
        } else {
            retval = this.isNull() ? "" : Double.toString(this.value.getNumber());
        }
        return retval;
    }

    private String toStringDate() {
        if (this.value == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS", Locale.US);
        String retval = this.isNull() || this.value.getDate() == null ? "" : df.format(this.value.getDate()).toString();
        return retval;
    }

    private String toStringBoolean() {
        if (this.value == null) {
            return null;
        }
        String retval = this.isNull() ? "" : (this.value.getBoolean() ? "true" : "false");
        return retval;
    }

    private String toStringInteger(boolean pad) {
        String retval;
        if (this.value == null) {
            return null;
        }
        if (this.getLength() < 1) {
            if (this.isNull()) {
                retval = "";
            } else {
                DecimalFormat form = new DecimalFormat(" ###############0;-###############0");
                retval = form.format(this.value.getInteger());
            }
        } else if (this.isNull()) {
            StringBuffer ret = new StringBuffer("");
            Const.rightPad(ret, this.getLength());
            retval = ret.toString();
        } else if (pad) {
            StringBuffer fmt = new StringBuffer();
            if (this.value.getInteger() >= 0L) {
                fmt.append(' ');
            }
            int len = this.getLength();
            for (int i = 0; i < len; ++i) {
                fmt.append('0');
            }
            DecimalFormat form = new DecimalFormat(fmt.toString());
            retval = form.format(this.value.getInteger());
        } else {
            retval = Long.toString(this.value.getInteger());
        }
        return retval;
    }

    private String toStringBigNumber() {
        String retval;
        if (this.value == null) {
            return null;
        }
        if (this.isNull()) {
            retval = "";
        } else if (this.value.getBigNumber() == null) {
            retval = null;
        } else {
            retval = this.value.getString();
            if (Const.DEFAULT_DECIMAL_SEPARATOR != '.') {
                retval = retval.replace('.', Const.DEFAULT_DECIMAL_SEPARATOR);
            }
        }
        return retval;
    }

    private String toStringBinary() {
        if (this.value == null) {
            return null;
        }
        String retval = this.isNull() || this.value.getBytes() == null ? "" : new String(this.value.getBytes());
        return retval;
    }

    public void setLength(int l) {
        if (this.value == null) {
            return;
        }
        this.value.setLength(l);
    }

    public void setLength(int l, int p) {
        if (this.value == null) {
            return;
        }
        this.value.setLength(l, p);
    }

    public int getLength() {
        if (this.value == null) {
            return -1;
        }
        return this.value.getLength();
    }

    public int getPrecision() {
        if (this.value == null) {
            return -1;
        }
        return this.value.getPrecision();
    }

    public void setPrecision(int p) {
        if (this.value == null) {
            return;
        }
        this.value.setPrecision(p);
    }

    public String getTypeDesc() {
        if (this.value == null) {
            return "Unknown";
        }
        return this.value.getTypeDesc();
    }

    public static final String getTypeDesc(int t) {
        return valueTypeCode[t];
    }

    public static final int getType(String desc) {
        for (int i = 1; i < valueTypeCode.length; ++i) {
            if (!valueTypeCode[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        return 0;
    }

    public static final String[] getTypes() {
        String[] retval = new String[valueTypeCode.length - 1];
        System.arraycopy(valueTypeCode, 1, retval, 0, valueTypeCode.length - 1);
        return retval;
    }

    public static final String[] getAllTypes() {
        String[] retval = new String[valueTypeCode.length];
        System.arraycopy(valueTypeCode, 0, retval, 0, valueTypeCode.length);
        return retval;
    }

    public void setNull() {
        this.setNull(true);
    }

    public void setNull(boolean n) {
        this.NULL = n;
    }

    public boolean isNull() {
        return this.NULL;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeObj(new DataOutputStream(out));
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.readObj(new DataInputStream(in));
    }

    public void writeObj(DataOutputStream dos) throws IOException {
        int type = this.getType();
        dos.writeInt(this.getType());
        dos.writeInt(this.name.length());
        dos.writeChars(this.name);
        dos.writeInt(this.getLength());
        dos.writeInt(this.getPrecision());
        dos.writeBoolean(this.isNull());
        if (!this.isNull()) {
            switch (type) {
                case 2: {
                    if (this.getString() == null) {
                        dos.writeInt(-1);
                        break;
                    }
                    String string = this.getString();
                    byte[] chars = string.getBytes("UTF-8");
                    dos.writeInt(chars.length);
                    dos.write(chars);
                    break;
                }
                case 6: {
                    if (this.getBigNumber() == null) {
                        dos.writeInt(-1);
                        break;
                    }
                    String string = this.getBigNumber().toString();
                    dos.writeInt(string.length());
                    dos.writeChars(string);
                    break;
                }
                case 3: {
                    dos.writeBoolean(this.getDate() != null);
                    if (this.getDate() == null) break;
                    dos.writeLong(this.getDate().getTime());
                    break;
                }
                case 1: {
                    dos.writeDouble(this.getNumber());
                    break;
                }
                case 4: {
                    dos.writeBoolean(this.getBoolean());
                    break;
                }
                case 5: {
                    dos.writeLong(this.getInteger());
                    break;
                }
            }
        }
    }

    public void write(OutputStream outputStream) throws KettleFileException {
        try {
            this.writeObj(new DataOutputStream(outputStream));
        }
        catch (Exception e) {
            throw new KettleFileException("Unable to write value to output stream", e);
        }
    }

    public void readObj(DataInputStream dis) throws IOException {
        int theType = dis.readInt();
        this.newValue(theType);
        int nameLength = dis.readInt();
        StringBuffer nameBuffer = new StringBuffer();
        for (int i = 0; i < nameLength; ++i) {
            nameBuffer.append(dis.readChar());
        }
        this.setName(new String(nameBuffer));
        this.setLength(dis.readInt(), dis.readInt());
        this.setNull(dis.readBoolean());
        if (!this.isNull()) {
            switch (this.getType()) {
                case 2: {
                    int stringLength = dis.readInt();
                    if (stringLength < 0) {
                        this.setValue((String)null);
                        break;
                    }
                    byte[] chars = new byte[stringLength];
                    dis.readFully(chars);
                    this.setValue(new String(chars, "UTF-8"));
                    break;
                }
                case 6: {
                    int bnLength = dis.readInt();
                    if (bnLength < 0) {
                        this.setValue((BigDecimal)null);
                        break;
                    }
                    StringBuffer buffer = new StringBuffer();
                    for (int i = 0; i < bnLength; ++i) {
                        buffer.append(dis.readChar());
                    }
                    this.setValue(buffer.toString());
                    try {
                        this.convertString(6);
                        break;
                    }
                    catch (KettleValueException e) {
                        throw new IOException("Unable to convert String to BigNumber while reading from data input stream [" + this.getString() + "]");
                    }
                }
                case 3: {
                    if (!dis.readBoolean()) break;
                    this.setValue(new Date(dis.readLong()));
                    break;
                }
                case 1: {
                    this.setValue(dis.readDouble());
                    break;
                }
                case 5: {
                    this.setValue(dis.readLong());
                    break;
                }
                case 4: {
                    this.setValue(dis.readBoolean());
                    break;
                }
            }
        }
    }

    public Value(InputStream is) throws KettleFileException {
        try {
            this.readObj(new DataInputStream(is));
        }
        catch (EOFException e) {
            throw new KettleEOFException("End of file reached", e);
        }
        catch (Exception e) {
            throw new KettleFileException("Error reading from data input stream", e);
        }
    }

    public boolean writeData(DataOutputStream dos) throws KettleFileException {
        try {
            dos.writeBoolean(this.isNull());
            if (!this.isNull()) {
                switch (this.getType()) {
                    case 2: {
                        if (this.getString() == null) {
                            dos.writeInt(-1);
                            break;
                        }
                        String string = this.getString();
                        byte[] chars = string.getBytes("UTF-8");
                        dos.writeInt(chars.length);
                        dos.write(chars);
                        break;
                    }
                    case 6: {
                        if (this.getBigNumber() == null) {
                            dos.writeInt(-1);
                            break;
                        }
                        String string = this.getBigNumber().toString();
                        dos.writeInt(string.length());
                        dos.writeChars(string);
                        break;
                    }
                    case 3: {
                        dos.writeBoolean(this.getDate() != null);
                        if (this.getDate() == null) break;
                        dos.writeLong(this.getDate().getTime());
                        break;
                    }
                    case 1: {
                        dos.writeDouble(this.getNumber());
                        break;
                    }
                    case 4: {
                        dos.writeBoolean(this.getBoolean());
                        break;
                    }
                    case 5: {
                        dos.writeLong(this.getInteger());
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new KettleFileException("Unable to write value data to output stream", e);
        }
        return true;
    }

    public Value(Value metaData, DataInputStream dis) throws KettleFileException {
        this.setValue(metaData);
        this.setName(metaData.getName());
        try {
            this.setNull(dis.readBoolean());
            if (!this.isNull()) {
                switch (this.getType()) {
                    case 2: {
                        int stringLength = dis.readInt();
                        if (stringLength < 0) {
                            this.setValue((String)null);
                            break;
                        }
                        byte[] chars = new byte[stringLength];
                        dis.readFully(chars);
                        this.setValue(new String(chars, "UTF-8"));
                        break;
                    }
                    case 6: {
                        int bnLength = dis.readInt();
                        if (bnLength < 0) {
                            this.setValue((BigDecimal)null);
                            break;
                        }
                        StringBuffer buffer = new StringBuffer();
                        for (int i = 0; i < bnLength; ++i) {
                            buffer.append(dis.readChar());
                        }
                        this.setValue(buffer.toString());
                        try {
                            this.convertString(6);
                            break;
                        }
                        catch (KettleValueException e) {
                            throw new IOException("Unable to convert String to BigNumber while reading from data input stream [" + this.getString() + "]");
                        }
                    }
                    case 3: {
                        if (!dis.readBoolean()) break;
                        this.setValue(new Date(dis.readLong()));
                        break;
                    }
                    case 1: {
                        this.setValue(dis.readDouble());
                        break;
                    }
                    case 5: {
                        this.setValue(dis.readLong());
                        break;
                    }
                    case 4: {
                        this.setValue(dis.readBoolean());
                        break;
                    }
                }
            }
        }
        catch (EOFException e) {
            throw new KettleEOFException("End of file reached while reading value", e);
        }
        catch (Exception e) {
            throw new KettleEOFException("Error reading value data from stream", e);
        }
    }

    public int compare(Value v) {
        return this.compare(v, true);
    }

    public int compare(Value v, boolean caseInsensitive) {
        boolean n2;
        boolean n1 = this.isNull() || this.isString() && (this.getString() == null || this.getString().length() == 0) || this.isDate() && this.getDate() == null || this.isBigNumber() && this.getBigNumber() == null;
        boolean bl = n2 = v.isNull() || v.isString() && (v.getString() == null || v.getString().length() == 0) || v.isDate() && v.getDate() == null || v.isBigNumber() && v.getBigNumber() == null;
        if (n1 && !n2) {
            return -1;
        }
        if (!n1 && n2) {
            return 1;
        }
        if (n1 && n2) {
            return 0;
        }
        switch (this.getType()) {
            case 2: {
                String one = Const.rtrim(this.getString());
                String two = Const.rtrim(v.getString());
                int cmp = 0;
                cmp = caseInsensitive ? one.compareToIgnoreCase(two) : one.compareTo(two);
                return cmp;
            }
            case 5: {
                return Double.compare(this.getNumber(), v.getNumber());
            }
            case 3: {
                return Double.compare(this.getNumber(), v.getNumber());
            }
            case 4: {
                if (this.getBoolean() && v.getBoolean() || !this.getBoolean() && !v.getBoolean()) {
                    return 0;
                }
                if (this.getBoolean() && !v.getBoolean()) {
                    return 1;
                }
                return -1;
            }
            case 1: {
                return Double.compare(this.getNumber(), v.getNumber());
            }
            case 6: {
                return this.getBigNumber().compareTo(v.getBigNumber());
            }
        }
        return 0;
    }

    public boolean equals(Object v) {
        return this.compare((Value)v) == 0;
    }

    public boolean isEqualTo(String string) {
        return this.getString().equalsIgnoreCase(string);
    }

    public boolean isEqualTo(BigDecimal number) {
        return this.getBigNumber().equals(number);
    }

    public boolean isEqualTo(double number) {
        return this.getNumber() == number;
    }

    public boolean isEqualTo(long number) {
        return this.getInteger() == number;
    }

    public boolean isEqualTo(int number) {
        return this.getInteger() == (long)number;
    }

    public boolean isEqualTo(byte number) {
        return this.getInteger() == (long)number;
    }

    public boolean isEqualTo(Date date) {
        return this.getDate() == date;
    }

    public int hashCode() {
        int hash = 0;
        if (this.isNull()) {
            switch (this.getType()) {
                case 4: {
                    hash ^= 1;
                    break;
                }
                case 3: {
                    hash ^= 2;
                    break;
                }
                case 1: {
                    hash ^= 4;
                    break;
                }
                case 2: {
                    hash ^= 8;
                    break;
                }
                case 5: {
                    hash ^= 0x10;
                    break;
                }
                case 6: {
                    hash ^= 0x20;
                    break;
                }
                case 0: {
                    break;
                }
            }
        } else {
            switch (this.getType()) {
                case 4: {
                    hash ^= Boolean.valueOf(this.getBoolean()).hashCode();
                    break;
                }
                case 3: {
                    if (this.getDate() == null) break;
                    hash ^= this.getDate().hashCode();
                    break;
                }
                case 5: {
                    hash ^= new Long(this.getInteger()).hashCode();
                    break;
                }
                case 1: {
                    hash ^= new Double(this.getNumber()).hashCode();
                    break;
                }
                case 2: {
                    if (this.getString() == null) break;
                    hash ^= this.getString().hashCode();
                    break;
                }
                case 6: {
                    if (this.getBigNumber() == null) break;
                    hash ^= this.getBigNumber().hashCode();
                    break;
                }
                case 0: {
                    break;
                }
            }
        }
        return hash;
    }

    public Value and(Value v) {
        long n1 = this.getInteger();
        long n2 = v.getInteger();
        long res = n1 & n2;
        this.setValue(res);
        return this;
    }

    public Value xor(Value v) {
        long n1 = this.getInteger();
        long n2 = v.getInteger();
        long res = n1 ^ n2;
        this.setValue(res);
        return this;
    }

    public Value or(Value v) {
        long n1 = this.getInteger();
        long n2 = v.getInteger();
        long res = n1 | n2;
        this.setValue(res);
        return this;
    }

    public Value bool_and(Value v) {
        boolean b1 = this.getBoolean();
        boolean b2 = v.getBoolean();
        boolean res = b1 && b2;
        this.setValue(res);
        return this;
    }

    public Value bool_or(Value v) {
        boolean b1 = this.getBoolean();
        boolean b2 = v.getBoolean();
        boolean res = b1 || b2;
        this.setValue(res);
        return this;
    }

    public Value bool_xor(Value v) {
        boolean b1 = this.getBoolean();
        boolean b2 = v.getBoolean();
        boolean res = b1 && b2 ? false : b1 || b2;
        this.setValue(res);
        return this;
    }

    public Value bool_not() {
        this.value.setBoolean(!this.getBoolean());
        return this;
    }

    public Value greater_equal(Value v) {
        if (this.compare(v) >= 0) {
            this.setValue(true);
        } else {
            this.setValue(false);
        }
        return this;
    }

    public Value smaller_equal(Value v) {
        if (this.compare(v) <= 0) {
            this.setValue(true);
        } else {
            this.setValue(false);
        }
        return this;
    }

    public Value different(Value v) {
        if (this.compare(v) != 0) {
            this.setValue(true);
        } else {
            this.setValue(false);
        }
        return this;
    }

    public Value equal(Value v) {
        if (this.compare(v) == 0) {
            this.setValue(true);
        } else {
            this.setValue(false);
        }
        return this;
    }

    public Value like(Value v) {
        String cmp = v.getString();
        int idx = this.getString().indexOf(cmp);
        if (idx < 0) {
            this.setValue(false);
        } else {
            this.setValue(true);
        }
        return this;
    }

    public Value greater(Value v) {
        if (this.compare(v) > 0) {
            this.setValue(true);
        } else {
            this.setValue(false);
        }
        return this;
    }

    public Value smaller(Value v) {
        if (this.compare(v) < 0) {
            this.setValue(true);
        } else {
            this.setValue(false);
        }
        return this;
    }

    public Value minus(BigDecimal v) throws KettleValueException {
        return this.minus(new Value("tmp", v));
    }

    public Value minus(double v) throws KettleValueException {
        return this.minus(new Value("tmp", v));
    }

    public Value minus(long v) throws KettleValueException {
        return this.minus(new Value("tmp", v));
    }

    public Value minus(int v) throws KettleValueException {
        return this.minus(new Value("tmp", (long)v));
    }

    public Value minus(byte v) throws KettleValueException {
        return this.minus(new Value("tmp", (long)v));
    }

    public Value minus(Value v) throws KettleValueException {
        switch (this.getType()) {
            case 6: {
                this.value.setBigNumber(this.getBigNumber().subtract(v.getBigNumber()));
                break;
            }
            case 1: {
                this.value.setNumber(this.getNumber() - v.getNumber());
                break;
            }
            case 5: {
                this.value.setInteger(this.getInteger() - v.getInteger());
                break;
            }
            default: {
                throw new KettleValueException("Subtraction can only be done with numbers!");
            }
        }
        return this;
    }

    public Value plus(BigDecimal v) {
        return this.plus(new Value("tmp", v));
    }

    public Value plus(double v) {
        return this.plus(new Value("tmp", v));
    }

    public Value plus(long v) {
        return this.plus(new Value("tmp", v));
    }

    public Value plus(int v) {
        return this.plus(new Value("tmp", (long)v));
    }

    public Value plus(byte v) {
        return this.plus(new Value("tmp", (long)v));
    }

    public Value plus(Value v) {
        switch (this.getType()) {
            case 6: {
                this.setValue(this.getBigNumber().add(v.getBigNumber()));
                break;
            }
            case 1: {
                this.setValue(this.getNumber() + v.getNumber());
                break;
            }
            case 5: {
                this.setValue(this.getInteger() + v.getInteger());
                break;
            }
            case 4: {
                this.setValue(this.getBoolean() | v.getBoolean());
                break;
            }
            case 2: {
                this.setValue(this.getString() + v.getString());
                break;
            }
        }
        return this;
    }

    public Value divide(BigDecimal v) throws KettleValueException {
        return this.divide(new Value("tmp", v));
    }

    public Value divide(double v) throws KettleValueException {
        return this.divide(new Value("tmp", v));
    }

    public Value divide(long v) throws KettleValueException {
        return this.divide(new Value("tmp", v));
    }

    public Value divide(int v) throws KettleValueException {
        return this.divide(new Value("tmp", (long)v));
    }

    public Value divide(byte v) throws KettleValueException {
        return this.divide(new Value("tmp", (long)v));
    }

    public Value divide(Value v) throws KettleValueException {
        if (this.isNull() || v.isNull()) {
            this.setNull();
        } else {
            switch (this.getType()) {
                case 6: {
                    this.setValue(this.getBigNumber().divide(v.getBigNumber(), 4));
                    break;
                }
                case 1: {
                    this.setValue(this.getNumber() / v.getNumber());
                    break;
                }
                case 5: {
                    this.setValue(this.getInteger() / v.getInteger());
                    break;
                }
                default: {
                    throw new KettleValueException("Division can only be done with numeric data!");
                }
            }
        }
        return this;
    }

    public Value multiply(BigDecimal v) throws KettleValueException {
        return this.multiply(new Value("tmp", v));
    }

    public Value multiply(double v) throws KettleValueException {
        return this.multiply(new Value("tmp", v));
    }

    public Value multiply(long v) throws KettleValueException {
        return this.multiply(new Value("tmp", v));
    }

    public Value multiply(int v) throws KettleValueException {
        return this.multiply(new Value("tmp", (long)v));
    }

    public Value multiply(byte v) throws KettleValueException {
        return this.multiply(new Value("tmp", (long)v));
    }

    public Value multiply(Value v) throws KettleValueException {
        if (this.isNull() || v.isNull()) {
            this.setNull();
            return this;
        }
        if (v.isString() && this.isNumeric() || v.isNumeric() && this.isString()) {
            int n;
            StringBuffer s;
            String append = "";
            if (v.isString()) {
                s = new StringBuffer(v.getString());
                append = v.getString();
                n = (int)this.getInteger();
            } else {
                s = new StringBuffer(this.getString());
                append = this.getString();
                n = (int)v.getInteger();
            }
            if (n == 0) {
                s.setLength(0);
            } else {
                for (int i = 1; i < n; ++i) {
                    s.append(append);
                }
            }
            this.setValue(s);
        } else if (this.isBigNumber() || v.isBigNumber()) {
            this.setValue(ValueDataUtil.multiplyBigDecimals(this.getBigNumber(), v.getBigNumber(), null));
        } else if (this.isNumber() || v.isNumber()) {
            this.setValue(this.getNumber() * v.getNumber());
        } else if (this.isInteger() || v.isInteger()) {
            this.setValue(this.getInteger() * v.getInteger());
        } else {
            throw new KettleValueException("Multiplication can only be done with numbers or a number and a string!");
        }
        return this;
    }

    public Value abs() throws KettleValueException {
        if (this.isNull()) {
            return this;
        }
        if (this.isBigNumber()) {
            this.setValue(this.getBigNumber().abs());
        } else if (this.isNumber()) {
            this.setValue(Math.abs(this.getNumber()));
        } else if (this.isInteger()) {
            this.setValue(Math.abs(this.getInteger()));
        } else {
            throw new KettleValueException("Function ABS only works with a number");
        }
        return this;
    }

    public Value acos() throws KettleValueException {
        if (this.isNull()) {
            return this;
        }
        if (!this.isNumeric()) {
            throw new KettleValueException("Function ACOS only works with numeric data");
        }
        this.setValue(Math.acos(this.getNumber()));
        return this;
    }

    public Value asin() throws KettleValueException {
        if (this.isNull()) {
            return this;
        }
        if (!this.isNumeric()) {
            throw new KettleValueException("Function ASIN only works with numeric data");
        }
        this.setValue(Math.asin(this.getNumber()));
        return this;
    }

    public Value atan() throws KettleValueException {
        if (this.isNull()) {
            return this;
        }
        if (!this.isNumeric()) {
            throw new KettleValueException("Function ATAN only works with numeric data");
        }
        this.setValue(Math.atan(this.getNumber()));
        return this;
    }

    public Value atan2(Value arg0) throws KettleValueException {
        return this.atan2(arg0.getNumber());
    }

    public Value atan2(double arg0) throws KettleValueException {
        if (this.isNull()) {
            return this;
        }
        if (!this.isNumeric()) {
            throw new KettleValueException("Function ATAN2 only works with numbers");
        }
        this.setValue(Math.atan2(this.getNumber(), arg0));
        return this;
    }

    public Value ceil() throws KettleValueException {
        if (this.isNull()) {
            return this;
        }
        if (!this.isNumeric()) {
            throw new KettleValueException("Function CEIL only works with a number");
        }
        this.setValue(Math.ceil(this.getNumber()));
        return this;
    }

    public Value cos() throws KettleValueException {
        if (this.isNull()) {
            return this;
        }
        if (!this.isNumeric()) {
            throw new KettleValueException("Function COS only works with a number");
        }
        this.setValue(Math.cos(this.getNumber()));
        return this;
    }

    public Value exp() throws KettleValueException {
        if (this.isNull()) {
            return this;
        }
        if (!this.isNumeric()) {
            throw new KettleValueException("Function EXP only works with a number");
        }
        this.setValue(Math.exp(this.getNumber()));
        return this;
    }

    public Value floor() throws KettleValueException {
        if (this.isNull()) {
            return this;
        }
        if (!this.isNumeric()) {
            throw new KettleValueException("Function FLOOR only works with a number");
        }
        this.setValue(Math.floor(this.getNumber()));
        return this;
    }

    public Value initcap() {
        if (this.isNull()) {
            return this;
        }
        if (this.getString() == null) {
            this.setNull();
        } else {
            this.setValue(Const.initCap(this.getString()));
        }
        return this;
    }

    public Value length() throws KettleValueException {
        if (this.isNull()) {
            this.setType(5);
            this.setValue(0L);
            return this;
        }
        if (this.getType() != 2) {
            throw new KettleValueException("Function LENGTH only works with a string");
        }
        this.setValue((double)this.getString().length());
        return this;
    }

    public Value log() throws KettleValueException {
        if (this.isNull()) {
            return this;
        }
        if (!this.isNumeric()) {
            throw new KettleValueException("Function LOG only works with a number");
        }
        this.setValue(Math.log(this.getNumber()));
        return this;
    }

    public Value lower() {
        if (this.isNull()) {
            this.setType(2);
        } else {
            this.setValue(this.getString().toLowerCase());
        }
        return this;
    }

    public Value lpad(Value len) {
        return this.lpad((int)len.getNumber(), " ");
    }

    public Value lpad(Value len, Value padstr) {
        return this.lpad((int)len.getNumber(), padstr.getString());
    }

    public Value lpad(int len) {
        return this.lpad(len, " ");
    }

    public Value lpad(int len, String padstr) {
        if (this.isNull()) {
            this.setType(2);
        } else {
            if (this.getType() != 2) {
                this.setValue(this.getString());
            }
            if (this.getString() != null) {
                int i;
                StringBuffer result = new StringBuffer(this.getString());
                int pad = len;
                int l = (pad - result.length()) / padstr.length() + 1;
                for (i = 0; i < l; ++i) {
                    result.insert(0, padstr);
                }
                for (i = result.length(); i > pad && pad > 0; --i) {
                    result.deleteCharAt(0);
                }
                this.setValue(result.toString());
            } else {
                this.setNull();
            }
        }
        this.setLength(len);
        return this;
    }

    public Value ltrim() {
        if (this.isNull()) {
            this.setType(2);
        } else if (this.getString() != null) {
            String s = this.getType() == 2 ? Const.ltrim(this.getString()) : Const.ltrim(this.toString());
            this.setValue(s);
        } else {
            this.setNull();
        }
        return this;
    }

    public Value mod(Value arg) throws KettleValueException {
        return this.mod(arg.getNumber());
    }

    public Value mod(BigDecimal arg) throws KettleValueException {
        return this.mod(arg.doubleValue());
    }

    public Value mod(long arg) throws KettleValueException {
        return this.mod((double)arg);
    }

    public Value mod(int arg) throws KettleValueException {
        return this.mod((double)arg);
    }

    public Value mod(byte arg) throws KettleValueException {
        return this.mod((double)arg);
    }

    public Value mod(double arg0) throws KettleValueException {
        if (this.isNull()) {
            return this;
        }
        if (!this.isNumeric()) {
            throw new KettleValueException("Function MOD only works with numeric data");
        }
        double n1 = this.getNumber();
        double n2 = arg0;
        this.setValue(n1 - n2 * Math.floor(n1 / n2));
        return this;
    }

    public Value nvl(Value alt) {
        if (this.isNull()) {
            this.setValue(alt);
        }
        return this;
    }

    public Value power(BigDecimal arg) throws KettleValueException {
        return this.power(new Value("tmp", arg));
    }

    public Value power(double arg) throws KettleValueException {
        return this.power(new Value("tmp", arg));
    }

    public Value power(Value v) throws KettleValueException {
        if (this.isNull()) {
            return this;
        }
        if (!this.isNumeric()) {
            throw new KettleValueException("Function POWER only works with numeric data");
        }
        this.setValue(Math.pow(this.getNumber(), v.getNumber()));
        return this;
    }

    public Value replace(Value repl, Value with) {
        return this.replace(repl.getString(), with.getString());
    }

    public Value replace(String repl, String with) {
        if (this.isNull()) {
            return this;
        }
        if (this.getString() == null) {
            this.setNull();
        } else {
            this.setValue(Const.replace(this.getString(), repl, with));
        }
        return this;
    }

    public Value round() throws KettleValueException {
        if (this.isNull()) {
            return this;
        }
        if (!this.isNumeric()) {
            throw new KettleValueException("Function ROUND only works with a number");
        }
        this.setValue((double)Math.round(this.getNumber()));
        return this;
    }

    public Value round(int decimalPlaces) throws KettleValueException {
        if (this.isNull()) {
            return this;
        }
        if (this.isNumeric()) {
            if (this.isBigNumber()) {
                BigDecimal bigDec = this.getBigNumber();
                bigDec = bigDec.setScale(decimalPlaces, 6);
                this.setValue(bigDec);
            } else {
                this.setValue(Const.round(this.getNumber(), decimalPlaces));
            }
        } else {
            throw new KettleValueException("Function ROUND only works with a number");
        }
        return this;
    }

    public Value rpad(Value len) {
        return this.rpad((int)len.getNumber(), " ");
    }

    public Value rpad(Value len, Value padstr) {
        return this.rpad((int)len.getNumber(), padstr.getString());
    }

    public Value rpad(int len) {
        return this.rpad(len, " ");
    }

    public Value rpad(int len, String padstr) {
        if (this.isNull()) {
            this.setType(2);
        } else {
            if (this.getType() != 2) {
                this.setValue(this.getString());
            }
            if (this.getString() != null) {
                int i;
                StringBuffer result = new StringBuffer(this.getString());
                int pad = len;
                int l = (pad - result.length()) / padstr.length() + 1;
                for (i = 0; i < l; ++i) {
                    result.append(padstr);
                }
                for (i = result.length(); i > pad && pad > 0; --i) {
                    result.deleteCharAt(i - 1);
                }
                this.setValue(result.toString());
            } else {
                this.setNull();
            }
        }
        this.setLength(len);
        return this;
    }

    public Value rtrim() {
        if (this.isNull()) {
            this.setType(2);
        } else {
            String s = this.getType() == 2 ? Const.rtrim(this.getString()) : Const.rtrim(this.toString());
            this.setValue(s);
        }
        return this;
    }

    public Value sign() throws KettleValueException {
        if (this.isNull()) {
            return this;
        }
        if (this.isNumber()) {
            int cmp = this.getBigNumber().compareTo(new BigDecimal(0L));
            if (cmp > 0) {
                this.value.setBigNumber(new BigDecimal(1L));
            } else if (cmp < 0) {
                this.value.setBigNumber(new BigDecimal(-1L));
            } else {
                this.value.setBigNumber(new BigDecimal(0L));
            }
        } else if (this.isNumber()) {
            if (this.getNumber() > 0.0) {
                this.value.setNumber(1.0);
            } else if (this.getNumber() < 0.0) {
                this.value.setNumber(-1.0);
            } else {
                this.value.setNumber(0.0);
            }
        } else if (this.isInteger()) {
            if (this.getInteger() > 0L) {
                this.value.setInteger(1L);
            } else if (this.getInteger() < 0L) {
                this.value.setInteger(-1L);
            } else {
                this.value.setInteger(0L);
            }
        } else {
            throw new KettleValueException("Function SIGN only works with a number");
        }
        return this;
    }

    public Value sin() throws KettleValueException {
        if (this.isNull()) {
            return this;
        }
        if (!this.isNumeric()) {
            throw new KettleValueException("Function SIN only works with a number");
        }
        this.setValue(Math.sin(this.getNumber()));
        return this;
    }

    public Value sqrt() throws KettleValueException {
        if (this.isNull()) {
            return this;
        }
        if (!this.isNumeric()) {
            throw new KettleValueException("Function SQRT only works with a number");
        }
        this.setValue(Math.sqrt(this.getNumber()));
        return this;
    }

    public Value substr(Value from, Value to) {
        return this.substr((int)from.getNumber(), (int)to.getNumber());
    }

    public Value substr(Value from) {
        return this.substr((int)from.getNumber(), -1);
    }

    public Value substr(int from) {
        return this.substr(from, -1);
    }

    public Value substr(int from, int to) {
        if (this.isNull()) {
            this.setType(2);
            return this;
        }
        this.setValue(this.getString());
        if (this.getString() != null) {
            if (to < 0 && from >= 0) {
                this.setValue(this.getString().substring(from));
            } else if (to >= 0 && from >= 0) {
                this.setValue(this.getString().substring(from, to));
            }
        } else {
            this.setNull();
        }
        if (!this.isString()) {
            this.setType(2);
        }
        return this;
    }

    public Value rightstr(Value len) {
        return this.rightstr((int)len.getNumber());
    }

    public Value rightstr(int len) {
        int tot_len;
        if (this.isNull()) {
            this.setType(2);
            return this;
        }
        this.setValue(this.getString());
        int n = tot_len = this.getString() != null ? this.getString().length() : 0;
        if (tot_len > 0) {
            int totlen = this.getString().length();
            int f = totlen - len;
            if (f < 0) {
                f = 0;
            }
            this.setValue(this.getString().substring(f));
        } else {
            this.setNull();
        }
        if (!this.isString()) {
            this.setType(2);
        }
        return this;
    }

    public Value leftstr(Value len) {
        return this.leftstr((int)len.getNumber());
    }

    public Value leftstr(int len) {
        int tot_len;
        if (this.isNull()) {
            this.setType(2);
            return this;
        }
        this.setValue(this.getString());
        int n = tot_len = this.getString() != null ? this.getString().length() : 0;
        if (tot_len > 0) {
            int totlen = this.getString().length();
            int f = totlen - len;
            if (f > 0) {
                this.setValue(this.getString().substring(0, len));
            }
        } else {
            this.setNull();
        }
        if (!this.isString()) {
            this.setType(2);
        }
        return this;
    }

    public Value startsWith(Value string) {
        return this.startsWith(string.getString());
    }

    public Value startsWith(String string) {
        if (this.isNull()) {
            this.setType(4);
            return this;
        }
        if (string == null) {
            this.setValue(false);
            this.setNull();
            return this;
        }
        this.setValue(this.getString().startsWith(string));
        return this;
    }

    public Value sysdate() {
        this.setValue(Calendar.getInstance().getTime());
        return this;
    }

    public Value tan() throws KettleValueException {
        if (this.isNull()) {
            return this;
        }
        if (!this.isNumeric()) {
            throw new KettleValueException("Function TAN only works on a number");
        }
        this.setValue(Math.tan(this.getNumber()));
        return this;
    }

    public Value num2str() throws KettleValueException {
        return this.num2str(null, null, null, null);
    }

    public Value num2str(String format) throws KettleValueException {
        return this.num2str(format, null, null, null);
    }

    public Value num2str(String format, String decimalSymbol) throws KettleValueException {
        return this.num2str(format, decimalSymbol, null, null);
    }

    public Value num2str(String format, String decimalSymbol, String groupingSymbol) throws KettleValueException {
        return this.num2str(format, decimalSymbol, groupingSymbol, null);
    }

    public Value num2str(String format, String decimalSymbol, String groupingSymbol, String currencySymbol) throws KettleValueException {
        if (this.isNull()) {
            this.setType(2);
        } else if (this.getType() == 1 || this.getType() == 5) {
            NumberFormat nf = NumberFormat.getInstance();
            DecimalFormat df = (DecimalFormat)nf;
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            if (currencySymbol != null && currencySymbol.length() > 0) {
                dfs.setCurrencySymbol(currencySymbol);
            }
            if (groupingSymbol != null && groupingSymbol.length() > 0) {
                dfs.setGroupingSeparator(groupingSymbol.charAt(0));
            }
            if (decimalSymbol != null && decimalSymbol.length() > 0) {
                dfs.setDecimalSeparator(decimalSymbol.charAt(0));
            }
            df.setDecimalFormatSymbols(dfs);
            if (format != null && format.length() > 0) {
                df.applyPattern(format);
            }
            try {
                this.setValue(nf.format(this.getNumber()));
            }
            catch (Exception e) {
                this.setType(2);
                this.setNull();
                throw new KettleValueException("Couldn't convert Number to String " + e.toString());
            }
        } else {
            throw new KettleValueException("Function NUM2STR only works on Numbers and Integers");
        }
        return this;
    }

    public Value dat2str() throws KettleValueException {
        return this.dat2str(null, null);
    }

    public Value dat2str(String arg0) throws KettleValueException {
        return this.dat2str(arg0, null);
    }

    public Value dat2str(String arg0, String arg1) throws KettleValueException {
        if (this.isNull()) {
            this.setType(2);
        } else if (this.getType() == 3) {
            SimpleDateFormat df = new SimpleDateFormat();
            DateFormatSymbols dfs = new DateFormatSymbols();
            if (arg1 != null) {
                dfs.setLocalPatternChars(arg1);
            }
            if (arg0 != null) {
                df.applyPattern(arg0);
            }
            try {
                this.setValue(df.format(this.getDate()));
            }
            catch (Exception e) {
                this.setType(2);
                this.setNull();
                throw new KettleValueException("TO_CHAR Couldn't convert Date to String " + e.toString());
            }
        } else {
            throw new KettleValueException("Function DAT2STR only works on a date");
        }
        return this;
    }

    public Value num2dat() throws KettleValueException {
        if (this.isNull()) {
            this.setType(3);
        } else if (this.isNumeric()) {
            this.setValue(new Date(this.getInteger()));
            this.setLength(-1, -1);
        } else {
            throw new KettleValueException("Function NUM2DAT only works on a number");
        }
        return this;
    }

    public Value str2dat(String arg0) throws KettleValueException {
        return this.str2dat(arg0, null);
    }

    public Value str2dat(String arg0, String arg1) throws KettleValueException {
        if (this.isNull()) {
            this.setType(3);
        } else {
            SimpleDateFormat df = new SimpleDateFormat();
            DateFormatSymbols dfs = new DateFormatSymbols();
            if (arg1 != null) {
                dfs.setLocalPatternChars(arg1);
            }
            if (arg0 != null) {
                df.applyPattern(arg0);
            }
            try {
                this.value.setDate(df.parse(this.getString()));
                this.setType(3);
                this.setLength(-1, -1);
            }
            catch (Exception e) {
                this.setType(3);
                this.setNull();
                throw new KettleValueException("TO_DATE Couldn't convert String to Date" + e.toString());
            }
        }
        return this;
    }

    public Value str2num() throws KettleValueException {
        return this.str2num(null, null, null, null);
    }

    public Value str2num(String pattern) throws KettleValueException {
        return this.str2num(pattern, null, null, null);
    }

    public Value str2num(String pattern, String decimal) throws KettleValueException {
        return this.str2num(pattern, decimal, null, null);
    }

    public Value str2num(String pattern, String decimal, String grouping) throws KettleValueException {
        return this.str2num(pattern, decimal, grouping, null);
    }

    public Value str2num(String pattern, String decimal, String grouping, String currency) throws KettleValueException {
        if (this.isNull()) {
            this.setType(2);
        } else if (this.getType() == 2) {
            if (this.getString() == null) {
                this.setNull();
                this.setValue(0.0);
            } else {
                NumberFormat nf = NumberFormat.getInstance();
                DecimalFormat df = (DecimalFormat)nf;
                DecimalFormatSymbols dfs = new DecimalFormatSymbols();
                if (!Const.isEmpty(pattern)) {
                    df.applyPattern(pattern);
                }
                if (!Const.isEmpty(decimal)) {
                    dfs.setDecimalSeparator(decimal.charAt(0));
                }
                if (!Const.isEmpty(grouping)) {
                    dfs.setGroupingSeparator(grouping.charAt(0));
                }
                if (!Const.isEmpty(currency)) {
                    dfs.setCurrencySymbol(currency);
                }
                try {
                    df.setDecimalFormatSymbols(dfs);
                    this.setValue(df.parse(this.getString()).doubleValue());
                }
                catch (Exception e) {
                    String message = "Couldn't convert string to number " + e.toString();
                    if (!Const.isEmpty(pattern)) {
                        message = message + " pattern=" + pattern;
                    }
                    if (!Const.isEmpty(decimal)) {
                        message = message + " decimal=" + decimal;
                    }
                    if (!Const.isEmpty(grouping)) {
                        message = message + " grouping=" + grouping.charAt(0);
                    }
                    if (!Const.isEmpty(currency)) {
                        message = message + " currency=" + currency;
                    }
                    throw new KettleValueException(message);
                }
            }
        } else {
            throw new KettleValueException("Function STR2NUM works only on strings");
        }
        return this;
    }

    public Value dat2num() throws KettleValueException {
        if (this.isNull()) {
            this.setType(5);
            return this;
        }
        if (this.getType() == 3) {
            if (this.getString() == null) {
                this.setNull();
                this.setValue(0L);
            } else {
                this.setValue(this.getInteger());
            }
        } else {
            throw new KettleValueException("Function DAT2NUM works only on dates");
        }
        return this;
    }

    public Value trim() {
        if (this.isNull()) {
            this.setType(2);
            return this;
        }
        String str = Const.trim(this.getString());
        this.setValue(str);
        return this;
    }

    public Value upper() {
        if (this.isNull()) {
            this.setType(2);
            return this;
        }
        this.setValue(this.getString().toUpperCase());
        return this;
    }

    public Value e() {
        this.setValue(Math.E);
        return this;
    }

    public Value pi() {
        this.setValue(Math.PI);
        return this;
    }

    public Value v_decode(Value[] args) throws KettleValueException {
        if (args.length >= 3 && args.length % 2 == 1) {
            boolean found = false;
            for (int i = 0; i < args.length - 1 && !found; i += 2) {
                if (!this.equals(args[i])) continue;
                this.setValue(args[i + 1]);
                found = true;
            }
            if (!found) {
                this.setValue(args[args.length - 1]);
            }
        } else {
            throw new KettleValueException("Function DECODE can't have " + args.length + " arguments!");
        }
        return this;
    }

    public Value v_if(Value[] args) throws KettleValueException {
        if (this.getType() == 4) {
            if (args.length == 1) {
                if (this.getBoolean()) {
                    this.setValue(args[0]);
                } else {
                    this.setNull();
                }
            } else if (args.length == 2) {
                if (this.getBoolean()) {
                    this.setValue(args[0]);
                } else {
                    this.setValue(args[1]);
                }
            }
        } else {
            throw new KettleValueException("Function DECODE can't have " + args.length + " arguments!");
        }
        return this;
    }

    public Value add_months(int months) throws KettleValueException {
        if (this.getType() == 3) {
            if (!this.isNull() && this.getDate() != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.getDate());
                int year = cal.get(1);
                int month = cal.get(2);
                int day = cal.get(5);
                int newyear = year + (int)Math.floor((month += months) / 12);
                int newmonth = month % 12;
                cal.set(newyear, newmonth, 1);
                int newday = cal.getActualMaximum(5);
                if (newday < day) {
                    cal.set(5, newday);
                } else {
                    cal.set(5, day);
                }
                this.setValue(cal.getTime());
            }
        } else {
            throw new KettleValueException("Function add_months only works on a date!");
        }
        return this;
    }

    public Value add_days(long days) throws KettleValueException {
        if (this.getType() == 3) {
            if (!this.isNull() && this.getDate() != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.getDate());
                cal.add(6, (int)days);
                this.setValue(cal.getTime());
            }
        } else {
            throw new KettleValueException("Function add_days only works on a date!");
        }
        return this;
    }

    public Value last_day() throws KettleValueException {
        if (this.getType() != 3) {
            throw new KettleValueException("Function last_day only works on a date");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getDate());
        int last_day = cal.getActualMaximum(5);
        cal.set(5, last_day);
        this.setValue(cal.getTime());
        return this;
    }

    public Value first_day() throws KettleValueException {
        if (this.getType() != 3) {
            throw new KettleValueException("Function first_day only works on a date");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getDate());
        cal.set(5, 1);
        this.setValue(cal.getTime());
        return this;
    }

    public Value trunc() throws KettleValueException {
        if (this.isNull()) {
            return this;
        }
        if (this.isBigNumber()) {
            this.getBigNumber().setScale(0, 3);
        } else if (this.isNumber()) {
            this.setValue(Math.floor(this.getNumber()));
        } else if (!this.isInteger()) {
            if (this.isDate()) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.getDate());
                cal.set(14, 0);
                cal.set(13, 0);
                cal.set(12, 0);
                cal.set(11, 0);
                this.setValue(cal.getTime());
            } else {
                throw new KettleValueException("Function TRUNC only works on numbers and dates");
            }
        }
        return this;
    }

    public Value trunc(double level) throws KettleValueException {
        return this.trunc((int)level);
    }

    public Value trunc(int level) throws KettleValueException {
        if (this.isNull()) {
            return this;
        }
        if (this.isBigNumber()) {
            this.getBigNumber().setScale(level, 3);
        } else if (this.isNumber()) {
            double pow = Math.pow(10.0, level);
            this.setValue(Math.floor(this.getNumber() * pow) / pow);
        } else if (!this.isInteger()) {
            if (this.isDate()) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.getDate());
                switch (level) {
                    case 5: {
                        cal.set(2, 1);
                    }
                    case 4: {
                        cal.set(5, 1);
                    }
                    case 3: {
                        cal.set(11, 0);
                    }
                    case 2: {
                        cal.set(12, 0);
                    }
                    case 1: {
                        cal.set(13, 0);
                    }
                    case 0: {
                        cal.set(14, 0);
                        break;
                    }
                    default: {
                        throw new KettleValueException("Argument of TRUNC of date has to be between 0 and 5");
                    }
                }
            } else {
                throw new KettleValueException("Function TRUNC only works with numbers and dates");
            }
        }
        return this;
    }

    public Value byteToHexEncode() {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        this.setType(2);
        if (this.isNull()) {
            return this;
        }
        String hex = this.getString();
        char[] s = hex.toCharArray();
        StringBuffer hexString = new StringBuffer(2 * s.length);
        for (int i = 0; i < s.length; ++i) {
            hexString.append(hexDigits[(s[i] & 0xF0) >> 4]);
            hexString.append(hexDigits[s[i] & 0xF]);
        }
        this.setValue(hexString);
        return this;
    }

    public Value hexToByteDecode() throws KettleValueException {
        this.setType(2);
        if (this.isNull()) {
            return this;
        }
        this.setValue(this.getString());
        String hexString = this.getString();
        int len = hexString.length();
        char[] chArray = new char[(len + 1) / 2];
        boolean evenByte = true;
        int nextByte = 0;
        if (len % 2 == 1) {
            evenByte = false;
        }
        int j = 0;
        for (int i = 0; i < len; ++i) {
            int nibble;
            char c = hexString.charAt(i);
            if (c >= '0' && c <= '9') {
                nibble = c - 48;
            } else if (c >= 'A' && c <= 'F') {
                nibble = c - 65 + 10;
            } else if (c >= 'a' && c <= 'f') {
                nibble = c - 97 + 10;
            } else {
                throw new KettleValueException("invalid hex digit '" + c + "'.");
            }
            if (evenByte) {
                nextByte = nibble << 4;
            } else {
                chArray[j] = (char)(nextByte += nibble);
                ++j;
            }
            evenByte = !evenByte;
        }
        this.setValue(new String(chArray));
        return this;
    }

    public Value charToHexEncode() {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        this.setType(2);
        if (this.isNull()) {
            return this;
        }
        String hex = this.getString();
        char[] s = hex.toCharArray();
        StringBuffer hexString = new StringBuffer(2 * s.length);
        for (int i = 0; i < s.length; ++i) {
            hexString.append(hexDigits[(s[i] & 0xF000) >> 12]);
            hexString.append(hexDigits[(s[i] & 0xF00) >> 8]);
            hexString.append(hexDigits[(s[i] & 0xF0) >> 4]);
            hexString.append(hexDigits[s[i] & 0xF]);
        }
        this.setValue(hexString);
        return this;
    }

    public Value hexToCharDecode() throws KettleValueException {
        this.setType(2);
        if (this.isNull()) {
            return this;
        }
        this.setValue(this.getString());
        String hexString = this.getString();
        int len = hexString.length();
        char[] chArray = new char[(len + 3) / 4];
        int nextChar = 0;
        int charNr = len % 4;
        if (charNr == 0) {
            charNr = 4;
        }
        int j = 0;
        for (int i = 0; i < len; ++i) {
            int nibble;
            char c = hexString.charAt(i);
            if (c >= '0' && c <= '9') {
                nibble = c - 48;
            } else if (c >= 'A' && c <= 'F') {
                nibble = c - 65 + 10;
            } else if (c >= 'a' && c <= 'f') {
                nibble = c - 97 + 10;
            } else {
                throw new KettleValueException("invalid hex digit '" + c + "'.");
            }
            if (charNr == 4) {
                nextChar = nibble << 12;
                --charNr;
                continue;
            }
            if (charNr == 3) {
                nextChar += nibble << 8;
                --charNr;
                continue;
            }
            if (charNr == 2) {
                nextChar += nibble << 4;
                --charNr;
                continue;
            }
            chArray[j] = (char)(nextChar += nibble);
            charNr = 4;
            ++j;
        }
        this.setValue(new String(chArray));
        return this;
    }

    public static final Value getInstance() {
        return new Value();
    }

    public String getClassName() {
        return "Value";
    }

    public void jsConstructor() {
    }

    public void jsConstructor(String name) {
        this.setName(name);
    }

    public void jsConstructor(String name, String value) {
        this.setName(name);
        this.setValue(value);
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(128);
        retval.append("<value>");
        retval.append(XMLHandler.addTagValue("name", this.getName(), false, new String[0]));
        retval.append(XMLHandler.addTagValue("type", this.getTypeDesc(), false, new String[0]));
        retval.append(XMLHandler.addTagValue("text", this.toString(false), false, new String[0]));
        retval.append(XMLHandler.addTagValue("length", this.getLength(), false));
        retval.append(XMLHandler.addTagValue("precision", this.getPrecision(), false));
        retval.append(XMLHandler.addTagValue("isnull", this.isNull(), false));
        retval.append("</value>");
        return retval.toString();
    }

    public Value(Node valnode) {
        this();
        this.loadXML(valnode);
    }

    public boolean loadXML(Node valnode) {
        try {
            String valname = XMLHandler.getTagValue(valnode, "name");
            int valtype = Value.getType(XMLHandler.getTagValue(valnode, "type"));
            String text = XMLHandler.getTagValue(valnode, "text");
            boolean isnull = "Y".equalsIgnoreCase(XMLHandler.getTagValue(valnode, "isnull"));
            int len = Const.toInt(XMLHandler.getTagValue(valnode, "length"), -1);
            int prec = Const.toInt(XMLHandler.getTagValue(valnode, "precision"), -1);
            this.setName(valname);
            this.setValue(text);
            this.setLength(len, prec);
            if (valtype != 2) {
                this.trim();
                this.convertString(valtype);
            }
            if (isnull) {
                this.setNull();
            }
        }
        catch (Exception e) {
            this.setNull();
            return false;
        }
        return true;
    }

    public void convertString(int newtype) throws KettleValueException {
        switch (newtype) {
            case 2: {
                break;
            }
            case 1: {
                this.setValue(this.getNumber());
                break;
            }
            case 3: {
                this.setValue(this.getDate());
                break;
            }
            case 4: {
                this.setValue(this.getBoolean());
                break;
            }
            case 5: {
                this.setValue(this.getInteger());
                break;
            }
            case 6: {
                this.setValue(this.getBigNumber());
                break;
            }
            default: {
                throw new KettleValueException("Please specify the type to convert to from String type.");
            }
        }
    }

    public boolean equalValueType(Value v) {
        return this.equalValueType(v, false);
    }

    public boolean equalValueType(Value v, boolean checkTypeOnly) {
        if (v == null) {
            return false;
        }
        if (this.getType() != v.getType()) {
            return false;
        }
        if (!checkTypeOnly) {
            if (this.getName() == null && v.getName() != null || this.getName() != null && v.getName() == null || !this.getName().equals(v.getName())) {
                return false;
            }
            if (this.getLength() != v.getLength()) {
                return false;
            }
            if (this.getPrecision() != v.getPrecision()) {
                return false;
            }
        }
        return true;
    }

    public ValueInterface getValueInterface() {
        return this.value;
    }

    public void setValueInterface(ValueInterface valueInterface) {
        this.value = valueInterface;
    }

    public void merge(Value other) {
        if (other == null || !this.getName().equals(other.getName()) || this.getType() != other.getType()) {
            return;
        }
        switch (this.getType()) {
            case 6: {
                if (this.getBigNumber() != null) break;
                this.setValue(other.getBigNumber());
                break;
            }
            case 8: {
                if (this.getBytes() != null && this.getBytes().length != 0 || other.getBytes() == null || other.getBytes().length <= 0) break;
                this.setValue(other.getBytes());
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                if (this.getDate() != null) break;
                this.setValue(other.getDate());
                break;
            }
            case 5: {
                if (this.getInteger() != 0L) break;
                this.setValue(other.getInteger());
                break;
            }
            case 1: {
                if (this.getNumber() != 0.0) break;
                this.setValue(other.getNumber());
                break;
            }
            case 7: {
                break;
            }
            case 2: {
                if (!Const.isEmpty(this.getString()) || Const.isEmpty(other.getString())) break;
                this.setValue(other.getString());
                break;
            }
        }
    }
}

