/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.compatibility;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.pentaho.di.compatibility.ValueInterface;
import org.pentaho.di.core.Const;

public class ValueString
implements ValueInterface,
Cloneable {
    private String string;
    private int length;
    private static final ThreadLocal<SimpleDateFormat> LOCAL_SIMPLE_DATE_PARSER = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        }
    };

    public ValueString() {
        this.string = null;
        this.length = -1;
    }

    public ValueString(String string) {
        this.string = string;
        this.length = -1;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public String getTypeDesc() {
        return "String";
    }

    @Override
    public String getString() {
        return this.string;
    }

    @Override
    public double getNumber() {
        return Const.toDouble(this.string, 0.0);
    }

    @Override
    public Date getDate() {
        if (this.string != null) {
            try {
                return LOCAL_SIMPLE_DATE_PARSER.get().parse(this.string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean getBoolean() {
        return "Y".equalsIgnoreCase(this.string) || "TRUE".equalsIgnoreCase(this.string) || "YES".equalsIgnoreCase(this.string) || "1".equalsIgnoreCase(this.string);
    }

    @Override
    public long getInteger() {
        return Const.toLong(Const.ltrim(this.string), 0L);
    }

    @Override
    public void setString(String string) {
        this.string = string;
    }

    @Override
    public void setNumber(double number) {
        this.string = "" + number;
    }

    @Override
    public void setDate(Date date) {
        this.string = LOCAL_SIMPLE_DATE_PARSER.get().format(date);
    }

    @Override
    public void setBoolean(boolean bool) {
        this.string = bool ? "Y" : "N";
    }

    @Override
    public void setInteger(long number) {
        this.string = "" + number;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getPrecision() {
        return -1;
    }

    @Override
    public void setLength(int length, int precision) {
        this.length = length;
    }

    @Override
    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public void setPrecision(int precision) {
    }

    @Override
    public Object clone() {
        try {
            ValueString retval = (ValueString)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public BigDecimal getBigNumber() {
        if (Const.isEmpty(this.string)) {
            return null;
        }
        if (Const.DEFAULT_DECIMAL_SEPARATOR != '.') {
            this.string = this.string.replace(Const.DEFAULT_DECIMAL_SEPARATOR, '.');
        }
        return new BigDecimal(this.string);
    }

    @Override
    public void setBigNumber(BigDecimal number) {
        this.string = number.toString();
    }

    @Override
    public Serializable getSerializable() {
        return this.string;
    }

    @Override
    public void setSerializable(Serializable ser) {
        ser.toString();
    }

    @Override
    public byte[] getBytes() {
        if (this.string == null) {
            return null;
        }
        char[] arr = this.string.toCharArray();
        byte[] retByte = new byte[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            retByte[i] = (byte)(arr[i] & 0xFF);
        }
        return retByte;
    }

    @Override
    public void setBytes(byte[] b) {
        try {
            this.string = new String(b, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            this.string = null;
        }
    }
}

