/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseFactoryInterface;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.GenericDatabaseMeta;
import org.pentaho.di.core.database.InfobrightDatabaseMeta;
import org.pentaho.di.core.database.PartitionDatabaseMeta;
import org.pentaho.di.core.database.SAPR3DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.DatabasePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.shared.SharedObjectBase;
import org.pentaho.di.shared.SharedObjectInterface;
import org.w3c.dom.Node;

public class DatabaseMeta
extends SharedObjectBase
implements Cloneable,
XMLInterface,
SharedObjectInterface,
VariableSpace,
RepositoryElementInterface {
    private static Class<?> PKG = Database.class;
    public static final String XML_TAG = "connection";
    public static final RepositoryObjectType REPOSITORY_ELEMENT_TYPE = RepositoryObjectType.DATABASE;
    public static final Comparator<DatabaseMeta> comparator = new Comparator<DatabaseMeta>(){

        @Override
        public int compare(DatabaseMeta dbm1, DatabaseMeta dbm2) {
            return dbm1.getName().compareToIgnoreCase(dbm2.getName());
        }
    };
    private DatabaseInterface databaseInterface;
    private static Map<String, DatabaseInterface> allDatabaseInterfaces;
    private VariableSpace variables = new Variables();
    private ObjectRevision objectRevision;
    private boolean readOnly = false;
    @Deprecated
    public static final int TYPE_DATABASE_NONE = 0;
    @Deprecated
    public static final int TYPE_DATABASE_MYSQL = 1;
    @Deprecated
    public static final int TYPE_DATABASE_ORACLE = 2;
    @Deprecated
    public static final int TYPE_DATABASE_AS400 = 3;
    @Deprecated
    public static final int TYPE_DATABASE_ACCESS = 4;
    @Deprecated
    public static final int TYPE_DATABASE_MSSQL = 5;
    @Deprecated
    public static final int TYPE_DATABASE_DB2 = 6;
    @Deprecated
    public static final int TYPE_DATABASE_POSTGRES = 7;
    @Deprecated
    public static final int TYPE_DATABASE_CACHE = 8;
    @Deprecated
    public static final int TYPE_DATABASE_INFORMIX = 9;
    @Deprecated
    public static final int TYPE_DATABASE_SYBASE = 10;
    @Deprecated
    public static final int TYPE_DATABASE_GUPTA = 11;
    @Deprecated
    public static final int TYPE_DATABASE_DBASE = 12;
    @Deprecated
    public static final int TYPE_DATABASE_FIREBIRD = 13;
    @Deprecated
    public static final int TYPE_DATABASE_SAPDB = 14;
    @Deprecated
    public static final int TYPE_DATABASE_HYPERSONIC = 15;
    @Deprecated
    public static final int TYPE_DATABASE_GENERIC = 16;
    @Deprecated
    public static final int TYPE_DATABASE_SAPR3 = 17;
    @Deprecated
    public static final int TYPE_DATABASE_INGRES = 18;
    @Deprecated
    public static final int TYPE_DATABASE_INTERBASE = 19;
    @Deprecated
    public static final int TYPE_DATABASE_EXTENDB = 20;
    @Deprecated
    public static final int TYPE_DATABASE_TERADATA = 21;
    @Deprecated
    public static final int TYPE_DATABASE_ORACLE_RDB = 22;
    @Deprecated
    public static final int TYPE_DATABASE_H2 = 23;
    @Deprecated
    public static final int TYPE_DATABASE_NETEZZA = 24;
    @Deprecated
    public static final int TYPE_DATABASE_UNIVERSE = 25;
    @Deprecated
    public static final int TYPE_DATABASE_SQLITE = 26;
    @Deprecated
    public static final int TYPE_DATABASE_DERBY = 27;
    @Deprecated
    public static final int TYPE_DATABASE_REMEDY_AR_SYSTEM = 28;
    @Deprecated
    public static final int TYPE_DATABASE_PALO = 29;
    @Deprecated
    public static final int TYPE_DATABASE_SYBASEIQ = 30;
    @Deprecated
    public static final int TYPE_DATABASE_GREENPLUM = 31;
    @Deprecated
    public static final int TYPE_DATABASE_MONETDB = 32;
    @Deprecated
    public static final int TYPE_DATABASE_KINGBASEES = 33;
    @Deprecated
    public static final int TYPE_DATABASE_VERTICA = 34;
    @Deprecated
    public static final int TYPE_DATABASE_NEOVIEW = 35;
    @Deprecated
    public static final int TYPE_DATABASE_LUCIDDB = 36;
    @Deprecated
    public static final int TYPE_DATABASE_INFOBRIGHT = 37;
    public static final int TYPE_ACCESS_NATIVE = 0;
    public static final int TYPE_ACCESS_ODBC = 1;
    public static final int TYPE_ACCESS_OCI = 2;
    public static final int TYPE_ACCESS_PLUGIN = 3;
    public static final int TYPE_ACCESS_JNDI = 4;
    public static final String[] dbAccessTypeCode;
    public static final String[] dbAccessTypeDesc;
    public static final int CLOB_LENGTH = 9999999;
    public static final String EMPTY_OPTIONS_STRING = "><EMPTY><";

    public DatabaseMeta(String name, String type, String access, String host, String db, String port, String user, String pass) {
        this.setValues(name, type, access, host, db, port, user, pass);
        this.addOptions();
    }

    public DatabaseMeta() {
        this.setDefault();
        this.addOptions();
    }

    public void setDefault() {
        this.setValues("", "Oracle", "Native", "", "", "1521", "", "");
    }

    public void addOptions() {
        PluginInterface mySqlPlugin = PluginRegistry.getInstance().getPlugin(DatabasePluginType.class, "MYSQL");
        PluginInterface infoBrightPlugin = PluginRegistry.getInstance().getPlugin(DatabasePluginType.class, new InfobrightDatabaseMeta());
        String mySQL = mySqlPlugin.getIds()[0];
        this.addExtraOption(mySQL, "defaultFetchSize", "500");
        this.addExtraOption(mySQL, "useCursorFetch", "true");
        String infoBright = infoBrightPlugin.getIds()[0];
        this.addExtraOption(infoBright, "characterEncoding", "UTF-8");
        this.setSupportsBooleanDataType(true);
        this.setSupportsTimestampDataType(true);
    }

    public DatabaseInterface getDatabaseInterface() {
        return this.databaseInterface;
    }

    public void setDatabaseInterface(DatabaseInterface databaseInterface) {
        this.databaseInterface = databaseInterface;
    }

    public static final DatabaseInterface getDatabaseInterface(String databaseType) throws KettleDatabaseException {
        DatabaseInterface di = DatabaseMeta.findDatabaseInterface(databaseType);
        if (di == null) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, "DatabaseMeta.Error.DatabaseInterfaceNotFound", databaseType));
        }
        return (DatabaseInterface)di.clone();
    }

    private static final DatabaseInterface findDatabaseInterface(String databaseTypeDesc) throws KettleDatabaseException {
        PluginRegistry registry = PluginRegistry.getInstance();
        PluginInterface plugin = registry.getPlugin(DatabasePluginType.class, databaseTypeDesc);
        if (plugin == null) {
            plugin = registry.findPluginWithName(DatabasePluginType.class, databaseTypeDesc);
        }
        if (plugin == null) {
            throw new KettleDatabaseException("database type with plugin id [" + databaseTypeDesc + "] couldn't be found!");
        }
        return DatabaseMeta.getDatabaseInterfacesMap().get(plugin.getIds()[0]);
    }

    @Override
    public ObjectId getObjectId() {
        return this.databaseInterface.getObjectId();
    }

    @Override
    public void setObjectId(ObjectId id) {
        this.databaseInterface.setObjectId(id);
    }

    public Object clone() {
        DatabaseMeta databaseMeta = new DatabaseMeta();
        databaseMeta.replaceMeta(this);
        databaseMeta.setObjectId(null);
        return databaseMeta;
    }

    public void replaceMeta(DatabaseMeta databaseMeta) {
        this.setValues(databaseMeta.getName(), databaseMeta.getPluginId(), databaseMeta.getAccessTypeDesc(), databaseMeta.getHostname(), databaseMeta.getDatabaseName(), databaseMeta.getDatabasePortNumberString(), databaseMeta.getUsername(), databaseMeta.getPassword());
        this.setServername(databaseMeta.getServername());
        this.setDataTablespace(databaseMeta.getDataTablespace());
        this.setIndexTablespace(databaseMeta.getIndexTablespace());
        this.databaseInterface = (DatabaseInterface)databaseMeta.databaseInterface.clone();
        this.setObjectId(databaseMeta.getObjectId());
        this.setChanged();
    }

    public void setValues(String name, String type, String access, String host, String db, String port, String user, String pass) {
        try {
            this.databaseInterface = DatabaseMeta.getDatabaseInterface(type);
        }
        catch (KettleDatabaseException kde) {
            throw new RuntimeException("Database type not found!", kde);
        }
        this.setName(name);
        this.setAccessType(DatabaseMeta.getAccessType(access));
        this.setHostname(host);
        this.setDBName(db);
        this.setDBPort(port);
        this.setUsername(user);
        this.setPassword(pass);
        this.setServername(null);
        this.setChanged(false);
    }

    public void setDatabaseType(String type) {
        DatabaseInterface oldInterface = this.databaseInterface;
        try {
            this.databaseInterface = DatabaseMeta.getDatabaseInterface(type);
        }
        catch (KettleDatabaseException kde) {
            throw new RuntimeException("Database type [" + type + "] not found!", kde);
        }
        this.setName(oldInterface.getName());
        this.setAccessType(oldInterface.getAccessType());
        this.setHostname(oldInterface.getHostname());
        this.setDBName(oldInterface.getDatabaseName());
        this.setDBPort(oldInterface.getDatabasePortNumberString());
        this.setUsername(oldInterface.getUsername());
        this.setPassword(oldInterface.getPassword());
        this.setServername(oldInterface.getServername());
        this.setDataTablespace(oldInterface.getDataTablespace());
        this.setIndexTablespace(oldInterface.getIndexTablespace());
        this.setChanged(oldInterface.isChanged());
    }

    public void setValues(DatabaseMeta info) {
        this.databaseInterface = (DatabaseInterface)info.databaseInterface.clone();
    }

    @Override
    public void setName(String name) {
        this.databaseInterface.setName(name);
    }

    @Override
    public String getName() {
        return this.databaseInterface.getName();
    }

    public String getPluginId() {
        return this.databaseInterface.getPluginId();
    }

    public int getAccessType() {
        return this.databaseInterface.getAccessType();
    }

    public void setAccessType(int access_type) {
        this.databaseInterface.setAccessType(access_type);
    }

    @Deprecated
    public String getDatabaseTypeDesc() {
        return this.getPluginId();
    }

    public String getAccessTypeDesc() {
        return dbAccessTypeCode[this.getAccessType()];
    }

    public String getHostname() {
        return this.databaseInterface.getHostname();
    }

    public void setHostname(String hostname) {
        this.databaseInterface.setHostname(hostname);
    }

    public String getDatabasePortNumberString() {
        return this.databaseInterface.getDatabasePortNumberString();
    }

    public void setDBPort(String db_port) {
        this.databaseInterface.setDatabasePortNumberString(db_port);
    }

    public String getDatabaseName() {
        return this.databaseInterface.getDatabaseName();
    }

    public void setDBName(String databaseName) {
        this.databaseInterface.setDatabaseName(databaseName);
    }

    public String getUsername() {
        return this.databaseInterface.getUsername();
    }

    public void setUsername(String username) {
        this.databaseInterface.setUsername(username);
    }

    public String getPassword() {
        return this.databaseInterface.getPassword();
    }

    public void setPassword(String password) {
        this.databaseInterface.setPassword(password);
    }

    public void setServername(String servername) {
        this.databaseInterface.setServername(servername);
    }

    public String getServername() {
        return this.databaseInterface.getServername();
    }

    public String getDataTablespace() {
        return this.databaseInterface.getDataTablespace();
    }

    public void setDataTablespace(String data_tablespace) {
        this.databaseInterface.setDataTablespace(data_tablespace);
    }

    public String getIndexTablespace() {
        return this.databaseInterface.getIndexTablespace();
    }

    public void setIndexTablespace(String index_tablespace) {
        this.databaseInterface.setIndexTablespace(index_tablespace);
    }

    public void setChanged() {
        this.setChanged(true);
    }

    public void setChanged(boolean ch) {
        this.databaseInterface.setChanged(ch);
    }

    public boolean hasChanged() {
        return this.databaseInterface.isChanged();
    }

    public void clearChanged() {
        this.databaseInterface.setChanged(false);
    }

    public String toString() {
        return this.getName();
    }

    public Properties getAttributes() {
        return this.databaseInterface.getAttributes();
    }

    public void setAttributes(Properties attributes) {
        this.databaseInterface.setAttributes(attributes);
    }

    public DatabaseMeta(String xml) throws KettleXMLException {
        this(XMLHandler.getSubNode(XMLHandler.loadXMLString(xml), XML_TAG));
    }

    public DatabaseMeta(Node con) throws KettleXMLException {
        this();
        try {
            String type = XMLHandler.getTagValue(con, "type");
            try {
                this.databaseInterface = DatabaseMeta.getDatabaseInterface(type);
            }
            catch (KettleDatabaseException kde) {
                throw new KettleXMLException("Unable to create new database interface", kde);
            }
            this.setName(XMLHandler.getTagValue(con, "name"));
            this.setHostname(XMLHandler.getTagValue(con, "server"));
            String acc = XMLHandler.getTagValue(con, "access");
            this.setAccessType(DatabaseMeta.getAccessType(acc));
            this.setDBName(XMLHandler.getTagValue(con, "database"));
            this.setDBPort(XMLHandler.getTagValue(con, "port"));
            this.setUsername(XMLHandler.getTagValue(con, "username"));
            this.setPassword(Encr.decryptPasswordOptionallyEncrypted(XMLHandler.getTagValue(con, "password")));
            this.setServername(XMLHandler.getTagValue(con, "servername"));
            this.setDataTablespace(XMLHandler.getTagValue(con, "data_tablespace"));
            this.setIndexTablespace(XMLHandler.getTagValue(con, "index_tablespace"));
            this.setReadOnly(Boolean.valueOf(XMLHandler.getTagValue(con, "read_only")));
            Node attrsnode = XMLHandler.getSubNode(con, "attributes");
            if (attrsnode != null) {
                List<Node> attrnodes = XMLHandler.getNodes(attrsnode, "attribute");
                for (Node attrnode : attrnodes) {
                    String code = XMLHandler.getTagValue(attrnode, "code");
                    String attribute = XMLHandler.getTagValue(attrnode, "attribute");
                    if (code != null && attribute != null) {
                        this.getAttributes().put(code, attribute);
                    }
                    this.getDatabasePortNumberString();
                }
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load database connection info from XML node", e);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(250);
        retval.append("  <").append(XML_TAG).append('>').append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue("name", this.getName()));
        retval.append("    ").append(XMLHandler.addTagValue("server", this.getHostname()));
        retval.append("    ").append(XMLHandler.addTagValue("type", this.getPluginId()));
        retval.append("    ").append(XMLHandler.addTagValue("access", this.getAccessTypeDesc()));
        retval.append("    ").append(XMLHandler.addTagValue("database", this.getDatabaseName()));
        retval.append("    ").append(XMLHandler.addTagValue("port", this.getDatabasePortNumberString()));
        retval.append("    ").append(XMLHandler.addTagValue("username", this.getUsername()));
        retval.append("    ").append(XMLHandler.addTagValue("password", Encr.encryptPasswordIfNotUsingVariables(this.getPassword())));
        retval.append("    ").append(XMLHandler.addTagValue("servername", this.getServername()));
        retval.append("    ").append(XMLHandler.addTagValue("data_tablespace", this.getDataTablespace()));
        retval.append("    ").append(XMLHandler.addTagValue("index_tablespace", this.getIndexTablespace()));
        if (this.isReadOnly()) {
            retval.append("    ").append(XMLHandler.addTagValue("read_only", Boolean.toString(this.isReadOnly())));
        }
        retval.append("    <attributes>").append(Const.CR);
        ArrayList<String> list = new ArrayList<String>();
        Set<Object> keySet = this.getAttributes().keySet();
        for (Object object : keySet) {
            list.add((String)object);
        }
        Collections.sort(list);
        for (String code : list) {
            String attribute = this.getAttributes().getProperty(code);
            if (Const.isEmpty(attribute)) continue;
            retval.append("      <attribute>" + XMLHandler.addTagValue("code", code, false, new String[0]) + XMLHandler.addTagValue("attribute", attribute, false, new String[0]) + "</attribute>" + Const.CR);
        }
        retval.append("    </attributes>").append(Const.CR);
        retval.append("  </connection>").append(Const.CR);
        return retval.toString();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        return this.getName().equals(((DatabaseMeta)obj).getName());
    }

    public String getURL() throws KettleDatabaseException {
        return this.getURL(null);
    }

    public String getURL(String partitionId) throws KettleDatabaseException {
        String databaseName;
        String port;
        String hostname;
        if (this.getAccessType() == 4) {
            // empty if block
        }
        if (this.isPartitioned() && !Const.isEmpty(partitionId)) {
            PartitionDatabaseMeta partition = this.getPartitionMeta(partitionId);
            hostname = this.environmentSubstitute(partition.getHostname());
            port = this.environmentSubstitute(partition.getPort());
            databaseName = this.environmentSubstitute(partition.getDatabaseName());
        } else {
            hostname = this.environmentSubstitute(this.getHostname());
            port = this.environmentSubstitute(this.getDatabasePortNumberString());
            databaseName = this.environmentSubstitute(this.getDatabaseName());
        }
        String baseUrl = this.databaseInterface.getURL(hostname, port, databaseName);
        StringBuffer url = new StringBuffer(this.environmentSubstitute(baseUrl));
        if (this.databaseInterface.supportsOptionsInURL()) {
            String optionIndicator = this.getExtraOptionIndicator();
            String optionSeparator = this.getExtraOptionSeparator();
            String valueSeparator = this.getExtraOptionValueSeparator();
            Map<String, String> map = this.getExtraOptions();
            if (map.size() > 0) {
                Iterator<String> iterator = map.keySet().iterator();
                boolean first = true;
                while (iterator.hasNext()) {
                    String typedParameter = iterator.next();
                    int dotIndex = typedParameter.indexOf(46);
                    if (dotIndex < 0) continue;
                    String typeCode = typedParameter.substring(0, dotIndex);
                    String parameter = typedParameter.substring(dotIndex + 1);
                    String value = map.get(typedParameter);
                    if (!this.databaseInterface.getPluginId().equals(typeCode)) continue;
                    if (first && url.indexOf(valueSeparator) == -1) {
                        url.append(optionIndicator);
                    } else {
                        url.append(optionSeparator);
                    }
                    url.append(parameter);
                    if (!Const.isEmpty(value) && !value.equals(EMPTY_OPTIONS_STRING)) {
                        url.append(valueSeparator).append(value);
                    }
                    first = false;
                }
            }
        }
        return url.toString();
    }

    public Properties getConnectionProperties() {
        Properties properties = new Properties();
        Map<String, String> map = this.getExtraOptions();
        if (map.size() > 0) {
            for (String typedParameter : map.keySet()) {
                int dotIndex = typedParameter.indexOf(46);
                if (dotIndex < 0) continue;
                String typeCode = typedParameter.substring(0, dotIndex);
                String parameter = typedParameter.substring(dotIndex + 1);
                String value = map.get(typedParameter);
                if (!this.databaseInterface.getPluginId().equals(typeCode)) continue;
                if (value != null && value.equals(EMPTY_OPTIONS_STRING)) {
                    value = "";
                }
                properties.put(parameter, this.environmentSubstitute(Const.NVL(value, "")));
            }
        }
        return properties;
    }

    public String getExtraOptionIndicator() {
        return this.databaseInterface.getExtraOptionIndicator();
    }

    public String getExtraOptionSeparator() {
        return this.databaseInterface.getExtraOptionSeparator();
    }

    public String getExtraOptionValueSeparator() {
        return this.databaseInterface.getExtraOptionValueSeparator();
    }

    public void addExtraOption(String databaseTypeCode, String option, String value) {
        this.databaseInterface.addExtraOption(databaseTypeCode, option, value);
    }

    @Deprecated
    public boolean supportsTransactions() {
        return this.databaseInterface.supportsTransactions();
    }

    public boolean supportsAutoinc() {
        return this.databaseInterface.supportsAutoInc();
    }

    public boolean supportsSequences() {
        return this.databaseInterface.supportsSequences();
    }

    public String getSQLSequenceExists(String sequenceName) {
        return this.databaseInterface.getSQLSequenceExists(sequenceName);
    }

    public boolean supportsBitmapIndex() {
        return this.databaseInterface.supportsBitmapIndex();
    }

    public boolean supportsSetLong() {
        return this.databaseInterface.supportsSetLong();
    }

    public boolean supportsSchemas() {
        return this.databaseInterface.supportsSchemas();
    }

    public boolean supportsCatalogs() {
        return this.databaseInterface.supportsCatalogs();
    }

    public boolean supportsEmptyTransactions() {
        return this.databaseInterface.supportsEmptyTransactions();
    }

    public boolean supportsSetCharacterStream() {
        return this.databaseInterface.supportsSetCharacterStream();
    }

    public int getMaxTextFieldLength() {
        return this.databaseInterface.getMaxTextFieldLength();
    }

    public static final int getAccessType(String dbaccess) {
        int i;
        if (dbaccess == null) {
            return 0;
        }
        for (i = 0; i < dbAccessTypeCode.length; ++i) {
            if (!dbAccessTypeCode[i].equalsIgnoreCase(dbaccess)) continue;
            return i;
        }
        for (i = 0; i < dbAccessTypeDesc.length; ++i) {
            if (!dbAccessTypeDesc[i].equalsIgnoreCase(dbaccess)) continue;
            return i;
        }
        return 0;
    }

    public static final String getAccessTypeDesc(int dbaccess) {
        if (dbaccess < 0) {
            return null;
        }
        if (dbaccess > dbAccessTypeCode.length) {
            return null;
        }
        return dbAccessTypeCode[dbaccess];
    }

    public static final String getAccessTypeDescLong(int dbaccess) {
        if (dbaccess < 0) {
            return null;
        }
        if (dbaccess > dbAccessTypeDesc.length) {
            return null;
        }
        return dbAccessTypeDesc[dbaccess];
    }

    public static final DatabaseInterface[] getDatabaseInterfaces() {
        ArrayList<DatabaseInterface> list = new ArrayList<DatabaseInterface>(DatabaseMeta.getDatabaseInterfacesMap().values());
        return list.toArray(new DatabaseInterface[list.size()]);
    }

    public static final void clearDatabaseInterfacesMap() {
        allDatabaseInterfaces = null;
    }

    public static final Map<String, DatabaseInterface> getDatabaseInterfacesMap() {
        if (allDatabaseInterfaces != null) {
            return allDatabaseInterfaces;
        }
        LogChannelInterface log = LogChannel.GENERAL;
        PluginRegistry registry = PluginRegistry.getInstance();
        List plugins = registry.getPlugins(DatabasePluginType.class);
        HashMap<String, DatabaseInterface> tmpAllDatabaseInterfaces = new HashMap<String, DatabaseInterface>();
        for (PluginInterface plugin : plugins) {
            try {
                DatabaseInterface databaseInterface = (DatabaseInterface)registry.loadClass(plugin);
                databaseInterface.setPluginId(plugin.getIds()[0]);
                databaseInterface.setPluginName(plugin.getName());
                tmpAllDatabaseInterfaces.put(plugin.getIds()[0], databaseInterface);
            }
            catch (KettlePluginException cnfe) {
                System.out.println("Could not create connection entry for " + plugin.getName() + ".  " + cnfe.getCause().getClass().getName());
                log.logError("Could not create connection entry for " + plugin.getName() + ".  " + cnfe.getCause().getClass().getName());
                if (!log.isDebug()) continue;
                log.logDebug("Debug-Error loading plugin: " + plugin, cnfe);
            }
            catch (Exception e) {
                log.logError("Error loading plugin: " + plugin, e);
            }
        }
        allDatabaseInterfaces = tmpAllDatabaseInterfaces;
        return allDatabaseInterfaces;
    }

    public static final int[] getAccessTypeList(String dbTypeDesc) {
        try {
            DatabaseInterface di = DatabaseMeta.findDatabaseInterface(dbTypeDesc);
            return di.getAccessTypeList();
        }
        catch (KettleDatabaseException kde) {
            return null;
        }
    }

    public static final int getPortForDBType(String strtype, String straccess) {
        try {
            DatabaseInterface di = DatabaseMeta.getDatabaseInterface(strtype);
            di.setAccessType(DatabaseMeta.getAccessType(straccess));
            return di.getDefaultDatabasePort();
        }
        catch (KettleDatabaseException kde) {
            return -1;
        }
    }

    public int getDefaultDatabasePort() {
        return this.databaseInterface.getDefaultDatabasePort();
    }

    public int getNotFoundTK(boolean use_autoinc) {
        return this.databaseInterface.getNotFoundTK(use_autoinc);
    }

    public String getDriverClass() {
        return this.environmentSubstitute(this.databaseInterface.getDriverClass());
    }

    public String stripCR(String sbsql) {
        if (sbsql == null) {
            return null;
        }
        return this.stripCR(new StringBuffer(sbsql));
    }

    public String stripCR(StringBuffer sbsql) {
        if (!this.supportsNewLinesInSQL()) {
            for (int i = sbsql.length() - 1; i >= 0; --i) {
                if (sbsql.charAt(i) != '\n' && sbsql.charAt(i) != '\r') continue;
                sbsql.setCharAt(i, ' ');
            }
        }
        return sbsql.toString();
    }

    public String getSeqNextvalSQL(String sequenceName) {
        return this.databaseInterface.getSQLNextSequenceValue(sequenceName);
    }

    public String getSQLCurrentSequenceValue(String sequenceName) {
        return this.databaseInterface.getSQLCurrentSequenceValue(sequenceName);
    }

    public boolean isFetchSizeSupported() {
        return this.databaseInterface.isFetchSizeSupported();
    }

    public boolean needsPlaceHolder() {
        return this.databaseInterface.needsPlaceHolder();
    }

    public String getFunctionSum() {
        return this.databaseInterface.getFunctionSum();
    }

    public String getFunctionAverage() {
        return this.databaseInterface.getFunctionAverage();
    }

    public String getFunctionMaximum() {
        return this.databaseInterface.getFunctionMaximum();
    }

    public String getFunctionMinimum() {
        return this.databaseInterface.getFunctionMinimum();
    }

    public String getFunctionCount() {
        return this.databaseInterface.getFunctionCount();
    }

    public String[] checkParameters() {
        ArrayList<String> remarks = new ArrayList<String>();
        if (this.getDatabaseInterface() == null) {
            remarks.add("No database type was choosen");
        }
        if (this.getName() == null || this.getName().length() == 0) {
            remarks.add("Please give this database connection a name");
        }
        if (!(this.isPartitioned() || this.getDatabaseInterface() instanceof SAPR3DatabaseMeta || this.getDatabaseInterface() instanceof GenericDatabaseMeta || this.getDatabaseName() != null && this.getDatabaseName().length() != 0)) {
            remarks.add("Please specify the name of the database");
        }
        return remarks.toArray(new String[remarks.size()]);
    }

    @Deprecated
    public String getSchemaTableCombination(String schemaName, String tableName) {
        return this.getQuotedSchemaTableCombination(schemaName, tableName);
    }

    public String getQuotedSchemaTableCombination(String schemaName, String tableName) {
        if (Const.isEmpty(schemaName)) {
            if (Const.isEmpty(this.getPreferredSchemaName())) {
                return this.quoteField(this.environmentSubstitute(tableName));
            }
            return this.databaseInterface.getSchemaTableCombination(this.quoteField(this.environmentSubstitute(this.getPreferredSchemaName())), this.quoteField(this.environmentSubstitute(tableName)));
        }
        return this.databaseInterface.getSchemaTableCombination(this.quoteField(this.environmentSubstitute(schemaName)), this.quoteField(this.environmentSubstitute(tableName)));
    }

    public boolean isClob(ValueMetaInterface v) {
        boolean retval = true;
        if (v != null && v.getLength() >= 9999999) {
            return true;
        }
        retval = false;
        return retval;
    }

    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc) {
        return this.getFieldDefinition(v, tk, pk, use_autoinc, true, true);
    }

    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String definition = v.getDatabaseColumnTypeDefinition(this.databaseInterface, tk, pk, use_autoinc, add_fieldname, add_cr);
        if (!Const.isEmpty(definition)) {
            return definition;
        }
        return this.databaseInterface.getFieldDefinition(v, tk, pk, use_autoinc, add_fieldname, add_cr);
    }

    public String getLimitClause(int nrRows) {
        return this.databaseInterface.getLimitClause(nrRows);
    }

    public String getSQLQueryFields(String tableName) {
        return this.databaseInterface.getSQLQueryFields(tableName);
    }

    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        String retval = this.databaseInterface.getAddColumnStatement(tablename, v, tk, use_autoinc, pk, semicolon);
        retval = retval + Const.CR;
        if (semicolon) {
            retval = retval + ";" + Const.CR;
        }
        return retval;
    }

    public String getDropColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        String retval = this.databaseInterface.getDropColumnStatement(tablename, v, tk, use_autoinc, pk, semicolon);
        retval = retval + Const.CR;
        if (semicolon) {
            retval = retval + ";" + Const.CR;
        }
        return retval;
    }

    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        String retval = this.databaseInterface.getModifyColumnStatement(tablename, v, tk, use_autoinc, pk, semicolon);
        retval = retval + Const.CR;
        if (semicolon) {
            retval = retval + ";" + Const.CR;
        }
        return retval;
    }

    public String[] getReservedWords() {
        return this.databaseInterface.getReservedWords();
    }

    public boolean quoteReservedWords() {
        return this.databaseInterface.quoteReservedWords();
    }

    public String getStartQuote() {
        return this.databaseInterface.getStartQuote();
    }

    public String getEndQuote() {
        return this.databaseInterface.getEndQuote();
    }

    public String quoteField(String field) {
        if (Const.isEmpty(field)) {
            return null;
        }
        if (this.isForcingIdentifiersToLowerCase()) {
            field = field.toLowerCase();
        } else if (this.isForcingIdentifiersToUpperCase()) {
            field = field.toUpperCase();
        }
        if (field.indexOf(this.getStartQuote()) >= 0 || field.indexOf(this.getEndQuote()) >= 0) {
            return field;
        }
        if (this.isReservedWord(field) && this.quoteReservedWords()) {
            return this.handleCase(this.getStartQuote() + field + this.getEndQuote());
        }
        if (this.databaseInterface.isQuoteAllFields() || this.hasSpacesInField(field) || this.hasSpecialCharInField(field) || this.hasDotInField(field)) {
            return this.getStartQuote() + field + this.getEndQuote();
        }
        return field;
    }

    private String handleCase(String field) {
        if (this.preserveReservedCase()) {
            return field;
        }
        if (this.databaseInterface.isDefaultingToUppercase()) {
            return field.toUpperCase();
        }
        return field.toLowerCase();
    }

    public boolean isInNeedOfQuoting(String fieldname) {
        return this.isReservedWord(fieldname) || this.hasSpacesInField(fieldname);
    }

    public boolean isReservedWord(String word) {
        String[] reserved = this.getReservedWords();
        return Const.indexOfString(word, reserved) >= 0;
    }

    public boolean hasSpacesInField(String fieldname) {
        if (fieldname == null) {
            return false;
        }
        return fieldname.indexOf(32) >= 0;
    }

    public boolean hasSpecialCharInField(String fieldname) {
        if (fieldname == null) {
            return false;
        }
        if (fieldname.indexOf(47) >= 0) {
            return true;
        }
        if (fieldname.indexOf(45) >= 0) {
            return true;
        }
        if (fieldname.indexOf(43) >= 0) {
            return true;
        }
        if (fieldname.indexOf(44) >= 0) {
            return true;
        }
        if (fieldname.indexOf(42) >= 0) {
            return true;
        }
        if (fieldname.indexOf(40) >= 0) {
            return true;
        }
        if (fieldname.indexOf(41) >= 0) {
            return true;
        }
        if (fieldname.indexOf(123) >= 0) {
            return true;
        }
        if (fieldname.indexOf(125) >= 0) {
            return true;
        }
        if (fieldname.indexOf(91) >= 0) {
            return true;
        }
        if (fieldname.indexOf(93) >= 0) {
            return true;
        }
        if (fieldname.indexOf(37) >= 0) {
            return true;
        }
        if (fieldname.indexOf(64) >= 0) {
            return true;
        }
        return fieldname.indexOf(63) >= 0;
    }

    public boolean hasDotInField(String fieldname) {
        if (fieldname == null) {
            return false;
        }
        return fieldname.indexOf(46) >= 0;
    }

    public boolean replaceReservedWords(RowMetaInterface fields) {
        boolean hasReservedWords = false;
        for (int i = 0; i < fields.size(); ++i) {
            ValueMetaInterface v = fields.getValueMeta(i);
            if (!this.isReservedWord(v.getName())) continue;
            hasReservedWords = true;
            v.setName(this.quoteField(v.getName()));
        }
        return hasReservedWords;
    }

    public int getNrReservedWords(RowMetaInterface fields) {
        int nrReservedWords = 0;
        for (int i = 0; i < fields.size(); ++i) {
            ValueMetaInterface v = fields.getValueMeta(i);
            if (!this.isReservedWord(v.getName())) continue;
            ++nrReservedWords;
        }
        return nrReservedWords;
    }

    public String[] getTableTypes() {
        return this.databaseInterface.getTableTypes();
    }

    public String[] getViewTypes() {
        return this.databaseInterface.getViewTypes();
    }

    public String[] getSynonymTypes() {
        return this.databaseInterface.getSynonymTypes();
    }

    public boolean useSchemaNameForTableList() {
        return this.databaseInterface.useSchemaNameForTableList();
    }

    public boolean supportsViews() {
        return this.databaseInterface.supportsViews();
    }

    public boolean supportsSynonyms() {
        return this.databaseInterface.supportsSynonyms();
    }

    public String getSQLListOfProcedures() {
        return this.databaseInterface.getSQLListOfProcedures();
    }

    public String getTruncateTableStatement(String schema, String tableName) {
        return this.databaseInterface.getTruncateTableStatement(this.getQuotedSchemaTableCombination(schema, tableName));
    }

    public boolean supportsFloatRoundingOnUpdate() {
        return this.databaseInterface.supportsFloatRoundingOnUpdate();
    }

    public String getSQLLockTables(String[] tableNames) {
        return this.databaseInterface.getSQLLockTables(tableNames);
    }

    public String getSQLUnlockTables(String[] tableNames) {
        return this.databaseInterface.getSQLUnlockTables(tableNames);
    }

    public List<RowMetaAndData> getFeatureSummary() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaAndData r = null;
        String par = "Parameter";
        String val = "Value";
        ValueMeta testValue = new ValueMeta("FIELD", 2);
        testValue.setLength(30);
        if (this.databaseInterface != null) {
            int i;
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Database type");
            r.addValue("Value", 2, this.getPluginId());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Access type");
            r.addValue("Value", 2, this.getAccessTypeDesc());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Database name");
            r.addValue("Value", 2, this.getDatabaseName());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Server hostname");
            r.addValue("Value", 2, this.getHostname());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Service port");
            r.addValue("Value", 2, this.getDatabasePortNumberString());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Username");
            r.addValue("Value", 2, this.getUsername());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Informix server name");
            r.addValue("Value", 2, this.getServername());
            list.add(r);
            Enumeration<Object> keys = this.getAttributes().keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = this.getAttributes().getProperty(key);
                r = new RowMetaAndData();
                r.addValue("Parameter", 2, "Extra attribute [" + key + "]");
                r.addValue("Value", 2, value);
                list.add(r);
            }
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Driver class");
            r.addValue("Value", 2, this.getDriverClass());
            list.add(r);
            String pwd = this.getPassword();
            this.setPassword("password");
            String url = "";
            try {
                url = this.getURL();
            }
            catch (Exception e) {
                url = "";
            }
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "URL");
            r.addValue("Value", 2, url);
            list.add(r);
            this.setPassword(pwd);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "SQL: next sequence value");
            r.addValue("Value", 2, this.getSeqNextvalSQL("SEQUENCE"));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "supported: set fetch size");
            r.addValue("Value", 2, this.isFetchSizeSupported() ? "Y" : "N");
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "auto increment field needs placeholder");
            r.addValue("Value", 2, this.needsPlaceHolder() ? "Y" : "N");
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "SUM aggregate function");
            r.addValue("Value", 2, this.getFunctionSum());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "AVG aggregate function");
            r.addValue("Value", 2, this.getFunctionAverage());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "MIN aggregate function");
            r.addValue("Value", 2, this.getFunctionMinimum());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "MAX aggregate function");
            r.addValue("Value", 2, this.getFunctionMaximum());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "COUNT aggregate function");
            r.addValue("Value", 2, this.getFunctionCount());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Schema / Table combination");
            r.addValue("Value", 2, this.getQuotedSchemaTableCombination("SCHEMA", "TABLE"));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "LIMIT clause for 100 rows");
            r.addValue("Value", 2, this.getLimitClause(100));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Add column statement");
            r.addValue("Value", 2, this.getAddColumnStatement("TABLE", testValue, null, false, null, false));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Drop column statement");
            r.addValue("Value", 2, this.getDropColumnStatement("TABLE", testValue, null, false, null, false));
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Modify column statement");
            r.addValue("Value", 2, this.getModifyColumnStatement("TABLE", testValue, null, false, null, false));
            list.add(r);
            String reserved = "";
            if (this.getReservedWords() != null) {
                for (int i2 = 0; i2 < this.getReservedWords().length; ++i2) {
                    reserved = reserved + (i2 > 0 ? ", " : "") + this.getReservedWords()[i2];
                }
            }
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "List of reserved words");
            r.addValue("Value", 2, reserved);
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Quote reserved words?");
            r.addValue("Value", 2, this.quoteReservedWords() ? "Y" : "N");
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "Start quote for reserved words");
            r.addValue("Value", 2, this.getStartQuote());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "End quote for reserved words");
            r.addValue("Value", 2, this.getEndQuote());
            list.add(r);
            String types = "";
            String[] slist = this.getTableTypes();
            if (slist != null) {
                for (i = 0; i < slist.length; ++i) {
                    types = types + (i > 0 ? ", " : "") + slist[i];
                }
            }
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "List of JDBC table types");
            r.addValue("Value", 2, types);
            list.add(r);
            types = "";
            slist = this.getViewTypes();
            if (slist != null) {
                for (i = 0; i < slist.length; ++i) {
                    types = types + (i > 0 ? ", " : "") + slist[i];
                }
            }
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "List of JDBC view types");
            r.addValue("Value", 2, types);
            list.add(r);
            types = "";
            slist = this.getSynonymTypes();
            if (slist != null) {
                for (i = 0; i < slist.length; ++i) {
                    types = types + (i > 0 ? ", " : "") + slist[i];
                }
            }
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "List of JDBC synonym types");
            r.addValue("Value", 2, types);
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "use schema name to get table list?");
            r.addValue("Value", 2, this.useSchemaNameForTableList() ? "Y" : "N");
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "supports views?");
            r.addValue("Value", 2, this.supportsViews() ? "Y" : "N");
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "supports synonyms?");
            r.addValue("Value", 2, this.supportsSynonyms() ? "Y" : "N");
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "SQL: list of procedures");
            r.addValue("Value", 2, this.getSQLListOfProcedures());
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "SQL: truncate table");
            String truncateStatement = this.getTruncateTableStatement(null, "TABLE");
            r.addValue("Value", 2, truncateStatement != null ? truncateStatement : "Not supported by this database type");
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "supports floating point rounding on update/insert");
            r.addValue("Value", 2, this.supportsFloatRoundingOnUpdate() ? "Y" : "N");
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "supports timestamp-date conversion");
            r.addValue("Value", 2, this.supportsTimeStampToDateConversion() ? "Y" : "N");
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "supports batch updates");
            r.addValue("Value", 2, this.supportsBatchUpdates() ? "Y" : "N");
            list.add(r);
            r = new RowMetaAndData();
            r.addValue("Parameter", 2, "supports boolean data type");
            r.addValue("Value", 2, this.supportsBooleanDataType() ? "Y" : "N");
            list.add(r);
        }
        return list;
    }

    public boolean supportsTimeStampToDateConversion() {
        return this.databaseInterface.supportsTimeStampToDateConversion();
    }

    public boolean supportsBatchUpdates() {
        return this.databaseInterface.supportsBatchUpdates();
    }

    public boolean supportsBooleanDataType() {
        return this.databaseInterface.supportsBooleanDataType();
    }

    public void setSupportsBooleanDataType(boolean b) {
        this.databaseInterface.setSupportsBooleanDataType(b);
    }

    public boolean supportsTimestampDataType() {
        return this.databaseInterface.supportsTimestampDataType();
    }

    public void setSupportsTimestampDataType(boolean b) {
        this.databaseInterface.setSupportsTimestampDataType(b);
    }

    public boolean preserveReservedCase() {
        return this.databaseInterface.preserveReservedCase();
    }

    public void setPreserveReservedCase(boolean b) {
        this.databaseInterface.setPreserveReservedCase(b);
    }

    public void quoteReservedWords(RowMetaInterface fields) {
        for (int i = 0; i < fields.size(); ++i) {
            ValueMetaInterface v = fields.getValueMeta(i);
            v.setName(this.quoteField(v.getName()));
        }
    }

    public Map<String, String> getExtraOptions() {
        return this.databaseInterface.getExtraOptions();
    }

    public boolean supportsOptionsInURL() {
        return this.databaseInterface.supportsOptionsInURL();
    }

    public String getExtraOptionsHelpText() {
        return this.databaseInterface.getExtraOptionsHelpText();
    }

    public boolean supportsGetBlob() {
        return this.databaseInterface.supportsGetBlob();
    }

    public String getConnectSQL() {
        return this.databaseInterface.getConnectSQL();
    }

    public void setConnectSQL(String sql) {
        this.databaseInterface.setConnectSQL(sql);
    }

    public boolean supportsSetMaxRows() {
        return this.databaseInterface.supportsSetMaxRows();
    }

    public String verifyAndModifyDatabaseName(List<DatabaseMeta> databases, String oldname) {
        String name = this.getName();
        if (name.equalsIgnoreCase(oldname)) {
            return name;
        }
        int nr = 2;
        while (DatabaseMeta.findDatabase(databases, this.getName()) != null) {
            this.setName(name + " " + nr);
            ++nr;
        }
        return this.getName();
    }

    public boolean isUsingConnectionPool() {
        return this.databaseInterface.isUsingConnectionPool();
    }

    public void setUsingConnectionPool(boolean usePool) {
        this.databaseInterface.setUsingConnectionPool(usePool);
    }

    public int getMaximumPoolSize() {
        return this.databaseInterface.getMaximumPoolSize();
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.databaseInterface.setMaximumPoolSize(maximumPoolSize);
    }

    public int getInitialPoolSize() {
        return this.databaseInterface.getInitialPoolSize();
    }

    public void setInitialPoolSize(int initalPoolSize) {
        this.databaseInterface.setInitialPoolSize(initalPoolSize);
    }

    public boolean isPartitioned() {
        return this.databaseInterface.isPartitioned();
    }

    public void setPartitioned(boolean partitioned) {
        this.databaseInterface.setPartitioned(partitioned);
    }

    public PartitionDatabaseMeta[] getPartitioningInformation() {
        if (!this.isPartitioned()) {
            return new PartitionDatabaseMeta[0];
        }
        return this.databaseInterface.getPartitioningInformation();
    }

    public void setPartitioningInformation(PartitionDatabaseMeta[] partitionInfo) {
        this.databaseInterface.setPartitioningInformation(partitionInfo);
    }

    public PartitionDatabaseMeta getPartitionMeta(String partitionId) {
        PartitionDatabaseMeta[] partitionInfo = this.getPartitioningInformation();
        for (int i = 0; i < partitionInfo.length; ++i) {
            if (!partitionInfo[i].getPartitionId().equals(partitionId)) continue;
            return partitionInfo[i];
        }
        return null;
    }

    public Properties getConnectionPoolingProperties() {
        return this.databaseInterface.getConnectionPoolingProperties();
    }

    public void setConnectionPoolingProperties(Properties properties) {
        this.databaseInterface.setConnectionPoolingProperties(properties);
    }

    public String getSQLTableExists(String tablename) {
        return this.databaseInterface.getSQLTableExists(tablename);
    }

    public String getSQLColumnExists(String columnname, String tablename) {
        return this.databaseInterface.getSQLColumnExists(columnname, tablename);
    }

    public boolean needsToLockAllTables() {
        return this.databaseInterface.needsToLockAllTables();
    }

    public boolean isStreamingResults() {
        return this.databaseInterface.isStreamingResults();
    }

    public void setStreamingResults(boolean useStreaming) {
        this.databaseInterface.setStreamingResults(useStreaming);
    }

    public boolean isQuoteAllFields() {
        return this.databaseInterface.isQuoteAllFields();
    }

    public void setQuoteAllFields(boolean quoteAllFields) {
        this.databaseInterface.setQuoteAllFields(quoteAllFields);
    }

    public boolean isForcingIdentifiersToLowerCase() {
        return this.databaseInterface.isForcingIdentifiersToLowerCase();
    }

    public void setForcingIdentifiersToLowerCase(boolean forceLowerCase) {
        this.databaseInterface.setForcingIdentifiersToLowerCase(forceLowerCase);
    }

    public boolean isForcingIdentifiersToUpperCase() {
        return this.databaseInterface.isForcingIdentifiersToUpperCase();
    }

    public void setForcingIdentifiersToUpperCase(boolean forceUpperCase) {
        this.databaseInterface.setForcingIdentifiersToUpperCase(forceUpperCase);
    }

    public static final DatabaseMeta findDatabase(List<? extends SharedObjectInterface> databases, String dbname) {
        if (databases == null) {
            return null;
        }
        for (int i = 0; i < databases.size(); ++i) {
            DatabaseMeta ci = (DatabaseMeta)databases.get(i);
            if (!ci.getName().equalsIgnoreCase(dbname)) continue;
            return ci;
        }
        return null;
    }

    public static final DatabaseMeta findDatabase(List<DatabaseMeta> databases, ObjectId id) {
        if (databases == null) {
            return null;
        }
        for (DatabaseMeta ci : databases) {
            if (ci.getObjectId() == null || !ci.getObjectId().equals(id)) continue;
            return ci;
        }
        return null;
    }

    @Override
    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    @Override
    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    @Override
    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    @Override
    public String fieldSubstitute(String aString, RowMetaInterface rowMeta, Object[] rowData) throws KettleValueException {
        return this.variables.fieldSubstitute(aString, rowMeta, rowData);
    }

    @Override
    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    @Override
    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    @Override
    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    @Override
    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    @Override
    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Const.isEmpty(variableName) && !Const.isEmpty(value = this.environmentSubstitute(variableName))) {
            return ValueMetaBase.convertStringToBoolean(value);
        }
        return defaultValue;
    }

    @Override
    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    @Override
    public String[] listVariables() {
        return this.variables.listVariables();
    }

    @Override
    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    @Override
    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
    }

    @Override
    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }

    public String getSQLServerInstance() {
        return this.getExtraOptions().get("MSSQL.instance");
    }

    public void setSQLServerInstance(String instanceName) {
        this.addExtraOption("MSSQL", "instance", instanceName);
    }

    public boolean isUsingDoubleDecimalAsSchemaTableSeparator() {
        return this.databaseInterface.isUsingDoubleDecimalAsSchemaTableSeparator();
    }

    public void setUsingDoubleDecimalAsSchemaTableSeparator(boolean useDoubleDecimalSeparator) {
        this.databaseInterface.setUsingDoubleDecimalAsSchemaTableSeparator(useDoubleDecimalSeparator);
    }

    public boolean isRequiringTransactionsOnQueries() {
        return this.databaseInterface.isRequiringTransactionsOnQueries();
    }

    public String testConnection() {
        StringBuffer report = new StringBuffer();
        try {
            DatabaseFactoryInterface factory = this.getDatabaseFactory();
            return factory.getConnectionTestReport(this);
        }
        catch (ClassNotFoundException e) {
            report.append(BaseMessages.getString(PKG, "BaseDatabaseMeta.TestConnectionReportNotImplemented.Message", new String[0])).append(Const.CR);
            report.append(BaseMessages.getString(PKG, "DatabaseMeta.report.ConnectionError", this.getName()) + e.toString() + Const.CR);
            report.append(Const.getStackTracker(e) + Const.CR);
        }
        catch (Exception e) {
            report.append(BaseMessages.getString(PKG, "DatabaseMeta.report.ConnectionError", this.getName()) + e.toString() + Const.CR);
            report.append(Const.getStackTracker(e) + Const.CR);
        }
        return report.toString();
    }

    public DatabaseFactoryInterface getDatabaseFactory() throws Exception {
        PluginRegistry registry = PluginRegistry.getInstance();
        PluginInterface plugin = registry.getPlugin(DatabasePluginType.class, this.databaseInterface.getPluginId());
        if (plugin == null) {
            throw new KettleDatabaseException("database type with plugin id [" + this.databaseInterface.getPluginId() + "] couldn't be found!");
        }
        ClassLoader loader = registry.getClassLoader(plugin);
        Class<?> clazz = Class.forName(this.databaseInterface.getDatabaseFactoryName(), true, loader);
        return (DatabaseFactoryInterface)clazz.newInstance();
    }

    public String getPreferredSchemaName() {
        return this.databaseInterface.getPreferredSchemaName();
    }

    public void setPreferredSchemaName(String preferredSchemaName) {
        this.databaseInterface.setPreferredSchemaName(preferredSchemaName);
    }

    @Override
    public RepositoryDirectoryInterface getRepositoryDirectory() {
        return new RepositoryDirectory();
    }

    @Override
    public void setRepositoryDirectory(RepositoryDirectoryInterface repositoryDirectory) {
        throw new RuntimeException("Setting a directory on a database connection is not supported");
    }

    @Override
    public RepositoryObjectType getRepositoryElementType() {
        return REPOSITORY_ELEMENT_TYPE;
    }

    @Override
    public ObjectRevision getObjectRevision() {
        return this.objectRevision;
    }

    @Override
    public void setObjectRevision(ObjectRevision objectRevision) {
        this.objectRevision = objectRevision;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public void setDescription(String description) {
    }

    public boolean supportsSequenceNoMaxValueOption() {
        return this.databaseInterface.supportsSequenceNoMaxValueOption();
    }

    public boolean requiresCreateTablePrimaryKeyAppend() {
        return this.databaseInterface.requiresCreateTablePrimaryKeyAppend();
    }

    public boolean requiresCastToVariousForIsNull() {
        return this.databaseInterface.requiresCastToVariousForIsNull();
    }

    public boolean isDisplaySizeTwiceThePrecision() {
        return this.databaseInterface.isDisplaySizeTwiceThePrecision();
    }

    public boolean supportsPreparedStatementMetadataRetrieval() {
        return this.databaseInterface.supportsPreparedStatementMetadataRetrieval();
    }

    public boolean isSystemTable(String tableName) {
        return this.databaseInterface.isSystemTable(tableName);
    }

    private boolean supportsNewLinesInSQL() {
        return this.databaseInterface.supportsNewLinesInSQL();
    }

    public String getSQLListOfSchemas() {
        return this.databaseInterface.getSQLListOfSchemas();
    }

    public int getMaxColumnsInIndex() {
        return this.databaseInterface.getMaxColumnsInIndex();
    }

    public boolean supportsErrorHandlingOnBatchUpdates() {
        return this.databaseInterface.supportsErrorHandlingOnBatchUpdates();
    }

    public String getSQLInsertAutoIncUnknownDimensionRow(String schemaTable, String keyField, String versionField) {
        return this.databaseInterface.getSQLInsertAutoIncUnknownDimensionRow(schemaTable, keyField, versionField);
    }

    public boolean isExplorable() {
        return this.databaseInterface.isExplorable();
    }

    public String getSQLListOfSequences() {
        return this.databaseInterface.getSQLListOfSequences();
    }

    public String quoteSQLString(String string) {
        return this.databaseInterface.quoteSQLString(string);
    }

    public String generateColumnAlias(int columnIndex, String suggestedName) {
        return this.databaseInterface.generateColumnAlias(columnIndex, suggestedName);
    }

    public boolean isMySQLVariant() {
        return this.databaseInterface.isMySQLVariant();
    }

    public Long getNextBatchId(Database ldb, String schemaName, String tableName, String fieldName) throws KettleDatabaseException {
        return this.databaseInterface.getNextBatchId(this, ldb, schemaName, tableName, fieldName);
    }

    public Object getValueFromResultSet(ResultSet rs, ValueMetaInterface val, int i) throws KettleDatabaseException {
        return this.databaseInterface.getValueFromResultSet(rs, val, i);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    static {
        dbAccessTypeCode = new String[]{"Native", "ODBC", "OCI", "Plugin", ", "};
        dbAccessTypeDesc = new String[]{"Native (JDBC)", "ODBC", "OCI", "Plugin specific access method", "JNDI", "Custom"};
    }
}

