/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.row.ValueMetaInterface;

public class DbaseDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    @Override
    public int[] getAccessTypeList() {
        return new int[]{1};
    }

    @Override
    public int getNotFoundTK(boolean use_autoinc) {
        if (this.supportsAutoInc() && use_autoinc) {
            return 1;
        }
        return super.getNotFoundTK(use_autoinc);
    }

    @Override
    public String getDriverClass() {
        return "sun.jdbc.odbc.JdbcOdbcDriver";
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) {
        return "jdbc:odbc:" + databaseName;
    }

    @Override
    public boolean isFetchSizeSupported() {
        return false;
    }

    @Override
    public String getSchemaTableCombination(String schema_name, String table_part) {
        return this.getBackwardsCompatibleTable(table_part);
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public boolean supportsBitmapIndex() {
        return false;
    }

    @Override
    public boolean supportsRepository() {
        return false;
    }

    @Override
    public boolean supportsViews() {
        return false;
    }

    @Override
    public boolean supportsSynonyms() {
        return false;
    }

    @Override
    public boolean supportsSetMaxRows() {
        return false;
    }

    @Override
    public String getTruncateTableStatement(String tableName) {
        return "DELETE FROM " + tableName;
    }

    @Override
    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " MODIFY " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval = retval + "DATETIME";
                break;
            }
            case 4: {
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                retval = retval + "DECIMAL";
                if (length <= 0) break;
                retval = retval + "(" + length;
                if (precision > 0) {
                    retval = retval + ", " + precision;
                }
                retval = retval + ")";
                break;
            }
            case 2: {
                if (length >= 9999999) {
                    retval = retval + "CLOB";
                    break;
                }
                retval = retval + "VARCHAR";
                retval = length > 0 ? retval + "(" + length : retval + "(";
                retval = retval + ")";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[0];
    }

    @Override
    public String getSQLInsertAutoIncUnknownDimensionRow(String schemaTable, String keyField, String versionField) {
        return "insert into " + schemaTable + "(" + versionField + ") values (1)";
    }
}

