/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.util.Collection;
import java.util.HashSet;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.row.ValueMetaInterface;

public class MonetDBDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    public static ThreadLocal<Boolean> safeModeLocal = new ThreadLocal();
    public static final int DEFAULT_VARCHAR_LENGTH = 100;
    protected static final String FIELDNAME_PROTECTOR = "_";
    private static final int MAX_VARCHAR_LENGTH = Integer.MAX_VALUE;
    private static Collection<String> reservedWordAlt = new HashSet<String>();

    @Override
    public int[] getAccessTypeList() {
        return new int[]{0, 1, 4};
    }

    @Override
    public int getNotFoundTK(boolean use_autoinc) {
        if (this.supportsAutoInc() && use_autoinc) {
            return 1;
        }
        return super.getNotFoundTK(use_autoinc);
    }

    @Override
    public String getDriverClass() {
        if (this.getAccessType() == 0) {
            return "nl.cwi.monetdb.jdbc.MonetDriver";
        }
        return "sun.jdbc.odbc.JdbcOdbcDriver";
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) {
        if (this.getAccessType() == 0) {
            if (Const.isEmpty(port)) {
                return "jdbc:monetdb://" + hostname + "/" + databaseName;
            }
            return "jdbc:monetdb://" + hostname + ":" + port + "/" + databaseName;
        }
        return "jdbc:odbc:" + databaseName;
    }

    @Override
    public boolean isFetchSizeSupported() {
        return false;
    }

    @Override
    public boolean supportsBitmapIndex() {
        return true;
    }

    @Override
    public boolean supportsAutoInc() {
        return true;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public boolean supportsSetMaxRows() {
        return true;
    }

    @Override
    public boolean supportsRepository() {
        return false;
    }

    @Override
    public String getTruncateTableStatement(String tableName) {
        return "DELETE FROM " + tableName;
    }

    @Override
    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " MODIFY " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String[] getReservedWords() {
        return reservedWordAlt.toArray(new String[0]);
    }

    @Override
    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        boolean safeMode;
        StringBuffer retval = new StringBuffer();
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        Boolean mode = safeModeLocal.get();
        boolean bl = safeMode = mode != null && mode != false;
        if (add_fieldname) {
            if (safeMode) {
                fieldname = this.getSafeFieldname(fieldname);
            }
            retval.append(fieldname + " ");
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval.append("TIMESTAMP");
                break;
            }
            case 4: {
                if (this.supportsBooleanDataType()) {
                    retval.append("BOOLEAN");
                    break;
                }
                retval.append("CHAR(1)");
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (use_autoinc) {
                        retval.append("SERIAL");
                        break;
                    }
                    retval.append("BIGINT");
                    break;
                }
                if (precision == 0) {
                    if (length > 9) {
                        if (length < 19) {
                            retval.append("BIGINT");
                            break;
                        }
                        retval.append("DECIMAL(").append(length).append(")");
                        break;
                    }
                    if (type == 1) {
                        retval.append("DOUBLE");
                        break;
                    }
                    retval.append("BIGINT");
                    break;
                }
                if (length > 15) {
                    retval.append("DECIMAL(").append(length);
                    if (precision > 0) {
                        retval.append(", ").append(precision);
                    }
                    retval.append(")");
                    break;
                }
                retval.append("DOUBLE");
                break;
            }
            case 2: {
                if (length > this.getMaxVARCHARLength()) {
                    retval.append("CLOB");
                    break;
                }
                retval.append("VARCHAR(");
                if (length > 0) {
                    retval.append(length);
                } else if (safeMode) {
                    retval.append(100);
                }
                retval.append(")");
                break;
            }
            default: {
                retval.append(" UNKNOWN");
            }
        }
        if (add_cr) {
            retval.append(Const.CR);
        }
        return retval.toString();
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"monetdb-jdbc-2.8.jar"};
    }

    @Override
    public String getSQLQueryFields(String tableName) {
        return "SELECT * FROM " + tableName + ";";
    }

    @Override
    public boolean supportsResultSetMetadataRetrievalOnly() {
        return true;
    }

    @Override
    public int getMaxVARCHARLength() {
        return Integer.MAX_VALUE;
    }

    static {
        reservedWordAlt.add("IS");
        reservedWordAlt.add("ISNULL");
        reservedWordAlt.add("NOTNULL");
        reservedWordAlt.add("IN");
        reservedWordAlt.add("BETWEEN");
        reservedWordAlt.add("OVERLAPS");
        reservedWordAlt.add("LIKE");
        reservedWordAlt.add("ILIKE");
        reservedWordAlt.add("NOT");
        reservedWordAlt.add("AND");
        reservedWordAlt.add("OR");
        reservedWordAlt.add("CHAR");
        reservedWordAlt.add("VARCHAR");
        reservedWordAlt.add("CLOB");
        reservedWordAlt.add("BLOB");
        reservedWordAlt.add("DECIMAL");
        reservedWordAlt.add("DEC");
        reservedWordAlt.add("NUMERIC");
        reservedWordAlt.add("TINYINT");
        reservedWordAlt.add("SMALLINT");
        reservedWordAlt.add("INT");
        reservedWordAlt.add("BIGINT");
        reservedWordAlt.add("REAL");
        reservedWordAlt.add("DOUBLE");
        reservedWordAlt.add("BOOLEAN");
        reservedWordAlt.add("DATE");
        reservedWordAlt.add("TIME");
        reservedWordAlt.add("TIMESTAMP");
        reservedWordAlt.add("INTERVAL");
        reservedWordAlt.add("YEAR");
        reservedWordAlt.add("MONTH");
        reservedWordAlt.add("DAY");
        reservedWordAlt.add("HOUR");
        reservedWordAlt.add("MINUTE");
        reservedWordAlt.add("SECOND");
        reservedWordAlt.add("TIMEZONE");
        reservedWordAlt.add("EXTRACT");
        reservedWordAlt.add("CURRENT_DATE");
        reservedWordAlt.add("CURRENT_TIME");
        reservedWordAlt.add("CURRENT_TIMESTAMP");
        reservedWordAlt.add("LOCALTIME");
        reservedWordAlt.add("LOCALTIMESTAMP");
        reservedWordAlt.add("CURRENT_TIME");
        reservedWordAlt.add("SERIAL");
        reservedWordAlt.add("START");
        reservedWordAlt.add("WITH");
        reservedWordAlt.add("INCREMENT");
        reservedWordAlt.add("CACHE");
        reservedWordAlt.add("CYCLE");
        reservedWordAlt.add("SEQUENCE");
        reservedWordAlt.add("GETANCHOR");
        reservedWordAlt.add("GETBASENAME");
        reservedWordAlt.add("GETCONTENT");
        reservedWordAlt.add("GETCONTEXT");
        reservedWordAlt.add("GETDOMAIN");
        reservedWordAlt.add("GETEXTENSION");
        reservedWordAlt.add("GETFILE");
        reservedWordAlt.add("GETHOST");
        reservedWordAlt.add("GETPORT");
        reservedWordAlt.add("GETPROTOCOL");
        reservedWordAlt.add("GETQUERY");
        reservedWordAlt.add("GETUSER");
        reservedWordAlt.add("GETROBOTURL");
        reservedWordAlt.add("ISURL");
        reservedWordAlt.add("NEWURL");
        reservedWordAlt.add("BROADCAST");
        reservedWordAlt.add("MASKLEN");
        reservedWordAlt.add("SETMASKLEN");
        reservedWordAlt.add("NETMASK");
        reservedWordAlt.add("HOSTMASK");
        reservedWordAlt.add("NETWORK");
        reservedWordAlt.add("TEXT");
        reservedWordAlt.add("ABBREV");
        reservedWordAlt.add("CREATE");
        reservedWordAlt.add("TYPE");
        reservedWordAlt.add("NAME");
        reservedWordAlt.add("DROP");
        reservedWordAlt.add("USER");
    }
}

