/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.jdbc;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleSQLException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;

public class ThinUtil {
    public static String stripNewlines(String sql) {
        if (sql == null) {
            return null;
        }
        StringBuffer sbsql = new StringBuffer(sql);
        for (int i = sbsql.length() - 1; i >= 0; --i) {
            if (sbsql.charAt(i) != '\n' && sbsql.charAt(i) != '\r') continue;
            sbsql.setCharAt(i, ' ');
        }
        return sbsql.toString();
    }

    public static int getSqlType(ValueMetaInterface valueMeta) {
        switch (valueMeta.getType()) {
            case 2: {
                return 12;
            }
            case 3: {
                return 93;
            }
            case 5: {
                return -5;
            }
            case 6: {
                return 3;
            }
            case 1: {
                return 8;
            }
            case 4: {
                return 16;
            }
            case 8: {
                return 2004;
            }
        }
        return 12;
    }

    public static String getSqlTypeDesc(ValueMetaInterface valueMeta) {
        switch (valueMeta.getType()) {
            case 2: {
                return "VARCHAR";
            }
            case 3: {
                return "TIMESTAMP";
            }
            case 5: {
                return "BIGINT";
            }
            case 1: {
                return "DOUBLE";
            }
            case 6: {
                return "DECIMAL";
            }
            case 4: {
                return "BOOLEAN";
            }
            case 8: {
                return "BLOB";
            }
        }
        return null;
    }

    public static ValueMetaInterface getValueMeta(String valueName, int sqlType) throws SQLException {
        switch (sqlType) {
            case -5: {
                return new ValueMeta(valueName, 5);
            }
            case 4: {
                return new ValueMeta(valueName, 5);
            }
            case 5: {
                return new ValueMeta(valueName, 5);
            }
            case 1: {
                return new ValueMeta(valueName, 2);
            }
            case 12: {
                return new ValueMeta(valueName, 2);
            }
            case 2005: {
                return new ValueMeta(valueName, 2);
            }
            case 91: {
                return new ValueMeta(valueName, 3);
            }
            case 93: {
                return new ValueMeta(valueName, 3);
            }
            case 92: {
                return new ValueMeta(valueName, 3);
            }
            case 3: {
                return new ValueMeta(valueName, 6);
            }
            case 8: {
                return new ValueMeta(valueName, 1);
            }
            case 6: {
                return new ValueMeta(valueName, 1);
            }
            case 16: {
                return new ValueMeta(valueName, 4);
            }
            case -7: {
                return new ValueMeta(valueName, 4);
            }
            case -2: {
                return new ValueMeta(valueName, 8);
            }
            case 2004: {
                return new ValueMeta(valueName, 8);
            }
        }
        throw new SQLException("Don't know how to handle SQL Type: " + sqlType + ", with name: " + valueName);
    }

    public static ValueMetaAndData attemptDateValueExtraction(String string) {
        String unquoted;
        if (string.length() > 2 && string.startsWith("[") && string.endsWith("]") && (unquoted = string.substring(1, string.length() - 1)).length() >= 9 && unquoted.charAt(4) == '/' && unquoted.charAt(7) == '/') {
            Date date = XMLHandler.stringToDate(unquoted);
            String format = "yyyy/MM/dd HH:mm:ss.SSS";
            if (date == null) {
                try {
                    date = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse(unquoted);
                    format = "yyyy/MM/dd HH:mm:ss";
                }
                catch (ParseException e1) {
                    try {
                        date = new SimpleDateFormat("yyyy/MM/dd").parse(unquoted);
                        format = "yyyy/MM/dd";
                    }
                    catch (ParseException e2) {
                        date = null;
                    }
                }
            }
            if (date != null) {
                ValueMeta valueMeta = new ValueMeta("iif-date", 3);
                valueMeta.setConversionMask(format);
                return new ValueMetaAndData(valueMeta, (Object)date);
            }
        }
        return null;
    }

    public static ValueMetaAndData attemptIntegerValueExtraction(String string) {
        if (!string.contains(".")) {
            try {
                long l = Long.parseLong(string);
                if (Long.toString(l).equals(string)) {
                    ValueMetaAndData value = new ValueMetaAndData();
                    ValueMeta valueMeta = new ValueMeta("Constant", 5);
                    valueMeta.setConversionMask("0");
                    valueMeta.setGroupingSymbol(null);
                    value.setValueMeta(valueMeta);
                    value.setValueData(l);
                    return value;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static ValueMetaAndData attemptNumberValueExtraction(String string) {
        try {
            double d = Double.parseDouble(string);
            if (Double.toString(d).equals(string)) {
                ValueMetaAndData value = new ValueMetaAndData();
                ValueMeta valueMeta = new ValueMeta("Constant", 1);
                valueMeta.setConversionMask("0.#");
                valueMeta.setGroupingSymbol(null);
                valueMeta.setDecimalSymbol(".");
                value.setValueMeta(valueMeta);
                value.setValueData(d);
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static ValueMetaAndData attemptBigNumberValueExtraction(String string) {
        try {
            BigDecimal d = new BigDecimal(string);
            if (d.toString().equals(string)) {
                ValueMetaAndData value = new ValueMetaAndData();
                value.setValueMeta(new ValueMeta("Constant", 6));
                value.setValueData(d);
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static ValueMetaAndData attemptStringValueExtraction(String string) {
        if (string.startsWith("'") && string.endsWith("'")) {
            String s = string.substring(1, string.length() - 1);
            s = s.replace("''", "'");
            ValueMetaAndData value = new ValueMetaAndData();
            value.setValueMeta(new ValueMeta("Constant", 2));
            value.setValueData(s);
            return value;
        }
        return null;
    }

    public static ValueMetaAndData attemptBooleanValueExtraction(String string) {
        if ("TRUE".equalsIgnoreCase(string) || "FALSE".equalsIgnoreCase(string)) {
            ValueMetaAndData value = new ValueMetaAndData();
            value.setValueMeta(new ValueMeta("Constant", 4));
            value.setValueData("TRUE".equalsIgnoreCase(string));
            return value;
        }
        return null;
    }

    public static ValueMetaAndData extractConstant(String string) {
        ValueMetaAndData value = ThinUtil.attemptDateValueExtraction(string);
        if (value != null) {
            return value;
        }
        value = ThinUtil.attemptStringValueExtraction(string);
        if (value != null) {
            return value;
        }
        value = ThinUtil.attemptBooleanValueExtraction(string);
        if (value != null) {
            return value;
        }
        value = ThinUtil.attemptIntegerValueExtraction(string);
        if (value != null) {
            return value;
        }
        value = ThinUtil.attemptNumberValueExtraction(string);
        if (value != null) {
            return value;
        }
        value = ThinUtil.attemptBigNumberValueExtraction(string);
        if (value != null) {
            return value;
        }
        return null;
    }

    public static String stripQuoteTableAlias(String field, String tableAliasPrefix) {
        String result = ThinUtil.stripTableAlias(field, tableAliasPrefix);
        if (result.equals(field)) {
            result = ThinUtil.stripQuotes(Const.trim(field), '\"');
        }
        return result;
    }

    public static String stripTableAlias(String field, String tableAliasPrefix) {
        if (field.toUpperCase().startsWith((tableAliasPrefix + ".").toUpperCase())) {
            return ThinUtil.stripQuotes(field.substring(tableAliasPrefix.length() + 1), '\"');
        }
        if (field.toUpperCase().startsWith(("\"" + tableAliasPrefix + "\".").toUpperCase())) {
            return ThinUtil.stripQuotes(field.substring(tableAliasPrefix.length() + 3), '\"');
        }
        return field;
    }

    public static int skipChars(String sql, int index, char ... skipChars) throws KettleSQLException {
        if (index >= sql.length()) {
            return index;
        }
        char c = sql.charAt(index);
        boolean count = false;
        for (char skipChar : skipChars) {
            if (c != skipChar) continue;
            char nextChar = skipChar;
            if (skipChar == '(') {
                nextChar = ')';
                count = true;
            }
            if (skipChar == '{') {
                nextChar = '}';
                count = true;
            }
            if (skipChar == '[') {
                nextChar = ']';
                count = true;
            }
            if ((index = count ? ThinUtil.findNextBracket(sql, skipChar, nextChar, index) : ThinUtil.findNext(sql, nextChar, index, skipChar == '\'')) >= sql.length()) break;
            c = sql.charAt(index);
        }
        return index;
    }

    public static int findNext(String sql, char nextChar, int index) throws KettleSQLException {
        return ThinUtil.findNext(sql, nextChar, index, false);
    }

    public static int findNext(String sql, char nextChar, int index, boolean escape) throws KettleSQLException {
        int quoteIndex = index;
        while (++index < sql.length()) {
            boolean escaped;
            boolean quoteMatch = sql.charAt(index) == nextChar;
            if (!quoteMatch) continue;
            boolean bl = escaped = escape && index + 1 < sql.length() && sql.charAt(index + 1) == nextChar;
            if (quoteMatch && !escaped) break;
            if (!escaped) continue;
            ++index;
        }
        if (index + 1 > sql.length()) {
            throw new KettleSQLException("No closing " + nextChar + " found, starting at location " + quoteIndex + " in : [" + sql + "]");
        }
        return ++index;
    }

    public static int findNextBracket(String sql, char skipChar, char nextChar, int index) throws KettleSQLException {
        return ThinUtil.findNextBracket(sql, skipChar, nextChar, index, false);
    }

    public static int findNextBracket(String sql, char skipChar, char nextChar, int index, boolean escape) throws KettleSQLException {
        int counter = 0;
        for (int i = index; i < sql.length() && (i = ThinUtil.skipChars(sql, i, '\'')) < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (c == skipChar) {
                ++counter;
            }
            if (c == nextChar) {
                --counter;
            }
            if (counter != 0) continue;
            return i;
        }
        throw new KettleSQLException("No closing " + nextChar + " bracket found for " + skipChar + " at location " + index + " in : [" + sql + "]");
    }

    public static String stripQuotes(String string, char ... quoteChars) {
        StringBuilder builder = new StringBuilder(string);
        for (char quoteChar : quoteChars) {
            if (ThinUtil.countQuotes(builder.toString(), quoteChar) != 2 || builder.length() <= 0 || builder.charAt(0) != quoteChar || builder.charAt(builder.length() - 1) != quoteChar) continue;
            builder.deleteCharAt(builder.length() - 1);
            builder.deleteCharAt(0);
        }
        return builder.toString();
    }

    private static int countQuotes(String string, char quoteChar) {
        int count = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != quoteChar) continue;
            ++count;
        }
        return count;
    }

    public static List<String> splitClause(String fieldClause, char splitChar, char ... skipChars) throws KettleSQLException {
        ArrayList<String> strings = new ArrayList<String>();
        int startIndex = 0;
        for (int index = 0; index < fieldClause.length(); ++index) {
            if ((index = ThinUtil.skipChars(fieldClause, index, skipChars)) >= fieldClause.length()) {
                strings.add(fieldClause.substring(startIndex));
                startIndex = -1;
                break;
            }
            if (fieldClause.substring(index).toUpperCase().startsWith("CASE WHEN ")) {
                index = ThinUtil.skipOverClause(fieldClause, index, " END");
            }
            if (index >= fieldClause.length() || fieldClause.charAt(index) != splitChar) continue;
            strings.add(fieldClause.substring(startIndex, index));
            while (index < fieldClause.length() && fieldClause.charAt(index) == splitChar) {
                ++index;
            }
            startIndex = index--;
        }
        if (startIndex >= 0) {
            strings.add(fieldClause.substring(startIndex));
        }
        return strings;
    }

    private static int skipOverClause(String fieldClause, int index, String clause) throws KettleSQLException {
        while (index < fieldClause.length()) {
            if (fieldClause.substring(index = ThinUtil.skipChars(fieldClause, index, '\'', '\"')).toUpperCase().startsWith(clause.toUpperCase())) {
                return index + clause.length();
            }
            ++index;
        }
        return fieldClause.length();
    }

    public static String findClause(String sqlString, String startClause, String ... endClauses) throws KettleSQLException {
        int startIndex;
        if (Const.isEmpty(sqlString)) {
            return null;
        }
        String sql = sqlString.toUpperCase();
        for (startIndex = 0; startIndex < sql.length() && !sql.substring(startIndex = ThinUtil.skipChars(sql, startIndex, '\"', '\'')).startsWith(startClause.toUpperCase()); ++startIndex) {
        }
        if (startIndex < 0 || startIndex >= sql.length()) {
            return null;
        }
        startIndex += startClause.length() + 1;
        if (endClauses.length == 0) {
            return sql.substring(startIndex);
        }
        int endIndex = sql.length();
        for (String endClause : endClauses) {
            for (int index = startIndex; index < sql.length(); ++index) {
                if (!sql.substring(index = ThinUtil.skipChars(sql, index, '\"', '\'')).startsWith(endClause.toUpperCase()) || index >= endIndex) continue;
                endIndex = index;
            }
        }
        return Const.trim(sqlString.substring(startIndex, endIndex));
    }
}

