/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.sql;

import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleSQLException;
import org.pentaho.di.core.jdbc.ThinUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.sql.SQLCondition;
import org.pentaho.di.core.sql.SQLFields;

public class SQL {
    private String sqlString;
    private RowMetaInterface rowMeta;
    private String serviceClause;
    private String namespace;
    private String serviceName;
    private String serviceAlias;
    private String selectClause;
    private SQLFields selectFields;
    private String whereClause;
    private SQLCondition whereCondition;
    private String groupClause;
    private SQLFields groupFields;
    private String havingClause;
    private SQLCondition havingCondition;
    private String orderClause;
    private SQLFields orderFields;

    public SQL(String sqlString) throws KettleSQLException {
        this.sqlString = sqlString;
        this.splitSql(sqlString);
    }

    private void splitSql(String sql) throws KettleSQLException {
        this.selectClause = ThinUtil.findClause(sql, "SELECT", "FROM");
        this.serviceClause = ThinUtil.findClause(sql, "FROM", "WHERE", "GROUP BY", "ORDER BY");
        this.parseServiceClause();
        this.whereClause = ThinUtil.findClause(sql, "WHERE", "GROUP BY", "ORDER BY");
        this.groupClause = ThinUtil.findClause(sql, "GROUP BY", "HAVING", "ORDER BY");
        this.havingClause = ThinUtil.findClause(sql, "HAVING", "ORDER BY");
        this.orderClause = ThinUtil.findClause(sql, "ORDER BY", new String[0]);
    }

    private void parseServiceClause() throws KettleSQLException {
        if (Const.isEmpty(this.serviceClause)) {
            this.serviceName = "dual";
            return;
        }
        List<String> parts = ThinUtil.splitClause(this.serviceClause, ' ', '\"');
        if (parts.size() >= 1) {
            List<String> list = ThinUtil.splitClause(parts.get(0), '.', '\"');
            if (list.size() == 1) {
                this.namespace = null;
                this.serviceName = ThinUtil.stripQuotes(list.get(0), '\"');
            }
            if (list.size() == 2) {
                this.namespace = ThinUtil.stripQuotes(list.get(0), '\"');
                this.serviceName = ThinUtil.stripQuotes(list.get(1), '\"');
            }
            if (list.size() > 2) {
                throw new KettleSQLException("Too many parts detected in table name specification [" + this.serviceClause + "]");
            }
        }
        if (parts.size() == 2) {
            this.serviceAlias = ThinUtil.stripQuotes(parts.get(1), '\"');
        }
        if (parts.size() == 3) {
            if (parts.get(1).equalsIgnoreCase("AS")) {
                this.serviceAlias = ThinUtil.stripQuotes(parts.get(2), '\"');
            } else {
                throw new KettleSQLException("AS expected in from clause: " + this.serviceClause);
            }
        }
        if (parts.size() > 3) {
            throw new KettleSQLException("Found " + parts.size() + " parts for the FROM clause when only a table name and optionally an alias is supported: " + this.serviceClause);
        }
        this.serviceAlias = Const.NVL(this.serviceAlias, this.serviceName);
    }

    public void parse(RowMetaInterface rowMeta) throws KettleSQLException {
        this.rowMeta = rowMeta;
        this.selectFields = new SQLFields(this.serviceAlias, rowMeta, this.selectClause);
        if (!Const.isEmpty(this.whereClause)) {
            this.whereCondition = new SQLCondition(this.serviceAlias, this.whereClause, rowMeta);
        }
        this.groupFields = !Const.isEmpty(this.groupClause) ? new SQLFields(this.serviceAlias, rowMeta, this.groupClause) : new SQLFields(this.serviceAlias, new RowMeta(), null);
        if (!Const.isEmpty(this.havingClause)) {
            this.havingCondition = new SQLCondition(this.serviceAlias, this.havingClause, rowMeta, this.selectFields);
        }
        if (!Const.isEmpty(this.orderClause)) {
            this.orderFields = new SQLFields(this.serviceAlias, rowMeta, this.orderClause, true, this.selectFields);
        }
    }

    public String getSqlString() {
        return this.sqlString;
    }

    public RowMetaInterface getRowMeta() {
        return this.rowMeta;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getSelectClause() {
        return this.selectClause;
    }

    public void setSelectClause(String selectClause) {
        this.selectClause = selectClause;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }

    public String getGroupClause() {
        return this.groupClause;
    }

    public void setGroupClause(String groupClause) {
        this.groupClause = groupClause;
    }

    public String getHavingClause() {
        return this.havingClause;
    }

    public void setHavingClause(String havingClause) {
        this.havingClause = havingClause;
    }

    public String getOrderClause() {
        return this.orderClause;
    }

    public void setOrderClause(String orderClause) {
        this.orderClause = orderClause;
    }

    public void setSqlString(String sqlString) {
        this.sqlString = sqlString;
    }

    public SQLFields getSelectFields() {
        return this.selectFields;
    }

    public void setSelectFields(SQLFields selectFields) {
        this.selectFields = selectFields;
    }

    public SQLFields getGroupFields() {
        return this.groupFields;
    }

    public void setGroupFields(SQLFields groupFields) {
        this.groupFields = groupFields;
    }

    public SQLFields getOrderFields() {
        return this.orderFields;
    }

    public void setOrderFields(SQLFields orderFields) {
        this.orderFields = orderFields;
    }

    public SQLCondition getWhereCondition() {
        return this.whereCondition;
    }

    public void setWhereCondition(SQLCondition whereCondition) {
        this.whereCondition = whereCondition;
    }

    public void setRowMeta(RowMetaInterface rowMeta) {
        this.rowMeta = rowMeta;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public SQLCondition getHavingCondition() {
        return this.havingCondition;
    }

    public void setHavingCondition(SQLCondition havingCondition) {
        this.havingCondition = havingCondition;
    }

    public String getNamespace() {
        return this.namespace;
    }
}

