/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.StringEvaluationResult;

public class StringEvaluator {
    private Set<String> values;
    private List<StringEvaluationResult> evaluationResults;
    private int maxLength;
    private int maxPrecision;
    private int count;
    private boolean tryTrimming;
    private ValueMetaInterface stringMeta;
    private String[] dateFormats;
    private String[] numberFormats;
    private static final String[] DEFAULT_NUMBER_FORMATS = new String[]{"#,###,###.#", "#.#", " #.#", "#", "#.0", "#.00", "#.000", "#.0000", "#.00000", "#.000000", " #.0#"};

    public StringEvaluator() {
        this(true);
    }

    public StringEvaluator(boolean tryTrimming) {
        this(tryTrimming, DEFAULT_NUMBER_FORMATS, Const.getDateFormats());
    }

    public StringEvaluator(boolean tryTrimming, List<String> numberFormats, List<String> dateFormats) {
        this(tryTrimming, numberFormats.toArray(new String[numberFormats.size()]), dateFormats.toArray(new String[dateFormats.size()]));
    }

    public StringEvaluator(boolean tryTrimming, String[] numberFormats, String[] dateFormats) {
        this.tryTrimming = tryTrimming;
        this.values = new HashSet<String>();
        this.evaluationResults = new ArrayList<StringEvaluationResult>();
        this.count = 0;
        this.stringMeta = new ValueMeta("string", 2);
        this.numberFormats = numberFormats;
        this.dateFormats = dateFormats;
        this.populateConversionMetaList();
    }

    public void evaluateString(String value) {
        ++this.count;
        if (!this.values.contains(value)) {
            this.values.add(value);
            if (value != null) {
                this.evaluateLength(value);
                this.evaluatePrecision(value);
                this.challengeConversions(value);
            }
        }
    }

    private void challengeConversions(String value) {
        ArrayList<StringEvaluationResult> all = new ArrayList<StringEvaluationResult>(this.evaluationResults);
        for (StringEvaluationResult cmm : all) {
            if (cmm.getConversionMeta().isBoolean()) {
                String string = this.tryTrimming ? Const.trim(value) : value;
                if ("Y".equalsIgnoreCase(string) || "N".equalsIgnoreCase(string) || "TRUE".equalsIgnoreCase(string) || "FALSE".equalsIgnoreCase(string)) continue;
                this.evaluationResults.remove(cmm);
                continue;
            }
            try {
                if (cmm.getConversionMeta().isNumeric()) {
                    boolean stop = false;
                    int nrDots = 0;
                    int nrCommas = 0;
                    int pos = 0;
                    for (char c : value.toCharArray()) {
                        if (!(Character.isDigit(c) || c == '.' || c == ',' || Character.isSpaceChar(c) || String.valueOf(c).equals(cmm.getConversionMeta().getCurrencySymbol()) || c == '(' || c == ')' || pos <= 0 || c != '+' && c != '-')) {
                            this.evaluationResults.remove(cmm);
                            stop = true;
                            break;
                        }
                        if (c == '.' && cmm.getConversionMeta().isInteger() || c == ',' && cmm.getConversionMeta().isInteger()) {
                            this.evaluationResults.remove(cmm);
                            stop = true;
                            break;
                        }
                        if (c == '.') {
                            ++nrDots;
                        }
                        if (c == ',') {
                            ++nrCommas;
                        }
                        ++pos;
                    }
                    if (nrDots > 1 && nrCommas > 1) {
                        this.evaluationResults.remove(cmm);
                        stop = true;
                    }
                    if (stop) continue;
                }
                ValueMetaInterface meta = this.stringMeta.clone();
                meta.setConversionMetadata(cmm.getConversionMeta());
                meta.setTrimType(cmm.getConversionMeta().getTrimType());
                Object object = meta.convertDataUsingConversionMetaData(value);
                if (cmm.getConversionMeta().isNull(object)) {
                    cmm.incrementNrNull();
                }
                if (cmm.getMin() == null || cmm.getConversionMeta().compare(cmm.getMin(), object) > 0) {
                    cmm.setMin(object);
                }
                if (cmm.getMax() != null && cmm.getConversionMeta().compare(cmm.getMax(), object) >= 0) continue;
                cmm.setMax(object);
            }
            catch (KettleValueException e) {
                this.evaluationResults.remove(cmm);
            }
        }
    }

    private void evaluateLength(String value) {
        if (value.length() > this.maxLength) {
            this.maxLength = value.length();
        }
    }

    private void evaluatePrecision(String value) {
        int p = StringEvaluator.determinePrecision(value);
        if (p > this.maxPrecision) {
            this.maxPrecision = p;
        }
    }

    private boolean containsInteger() {
        for (StringEvaluationResult result : this.evaluationResults) {
            if (!result.getConversionMeta().isInteger()) continue;
            return true;
        }
        return false;
    }

    private boolean containsNumber() {
        for (StringEvaluationResult result : this.evaluationResults) {
            if (!result.getConversionMeta().isNumber()) continue;
            return true;
        }
        return false;
    }

    private boolean containsDate() {
        for (StringEvaluationResult result : this.evaluationResults) {
            if (!result.getConversionMeta().isDate()) continue;
            return true;
        }
        return false;
    }

    public StringEvaluationResult getAdvicedResult() {
        StringEvaluationResult result;
        Iterator<StringEvaluationResult> iterator;
        if (this.evaluationResults.isEmpty()) {
            ValueMeta adviced = new ValueMeta("adviced", 2);
            adviced.setLength(this.maxLength);
            int nrNulls = 0;
            String min = null;
            String max = null;
            for (String string : this.values) {
                if (string != null) {
                    if (min == null || min.compareTo(string) > 0) {
                        min = string;
                    }
                    if (max != null && max.compareTo(string) >= 0) continue;
                    max = string;
                    continue;
                }
                ++nrNulls;
            }
            StringEvaluationResult result2 = new StringEvaluationResult(adviced);
            result2.setNrNull(nrNulls);
            result2.setMin(min);
            result2.setMax(max);
            return result2;
        }
        if (this.containsInteger() && this.containsNumber()) {
            iterator = this.evaluationResults.iterator();
            while (iterator.hasNext()) {
                result = iterator.next();
                if (this.maxPrecision == 0 && result.getConversionMeta().isNumber()) {
                    iterator.remove();
                    continue;
                }
                if (this.maxPrecision <= 0 || !result.getConversionMeta().isInteger()) continue;
                iterator.remove();
            }
        }
        if (this.containsInteger() && this.containsDate()) {
            iterator = this.evaluationResults.iterator();
            while (iterator.hasNext()) {
                result = iterator.next();
                if (!result.getConversionMeta().isInteger()) continue;
                iterator.remove();
            }
        }
        Comparator<StringEvaluationResult> compare = null;
        compare = this.containsDate() ? new Comparator<StringEvaluationResult>(){

            @Override
            public int compare(StringEvaluationResult r1, StringEvaluationResult r2) {
                Integer length1 = r1.getConversionMeta().getConversionMask() == null ? 0 : r1.getConversionMeta().getConversionMask().length();
                Integer length2 = r2.getConversionMeta().getConversionMask() == null ? 0 : r2.getConversionMeta().getConversionMask().length();
                return length2.compareTo(length1);
            }
        } : new Comparator<StringEvaluationResult>(){

            @Override
            public int compare(StringEvaluationResult r1, StringEvaluationResult r2) {
                Integer length1 = r1.getConversionMeta().getConversionMask() == null ? 0 : r1.getConversionMeta().getConversionMask().length();
                Integer length2 = r2.getConversionMeta().getConversionMask() == null ? 0 : r2.getConversionMeta().getConversionMask().length();
                return length1.compareTo(length2);
            }
        };
        Collections.sort(this.evaluationResults, compare);
        result = this.evaluationResults.get(0);
        ValueMetaInterface conversionMeta = result.getConversionMeta();
        if (conversionMeta.isNumber() && conversionMeta.getCurrencySymbol() == null) {
            conversionMeta.setPrecision(this.maxPrecision);
        }
        return result;
    }

    public String[] getDateFormats() {
        return this.dateFormats;
    }

    public String[] getNumberFormats() {
        return this.numberFormats;
    }

    private void populateConversionMetaList() {
        int[] trimTypes = this.tryTrimming ? new int[]{0, 3} : new int[]{0};
        for (int trimType : trimTypes) {
            ValueMeta conversionMeta;
            for (String format : this.getDateFormats()) {
                conversionMeta = new ValueMeta("date", 3);
                conversionMeta.setConversionMask(format);
                conversionMeta.setTrimType(trimType);
                conversionMeta.setDateFormatLenient(false);
                this.evaluationResults.add(new StringEvaluationResult(conversionMeta));
            }
            for (String format : this.getNumberFormats()) {
                if (format.equals("#") || format.equals("0")) continue;
                conversionMeta = new ValueMeta("number-us", 1);
                int precision = StringEvaluator.determinePrecision(format);
                conversionMeta.setConversionMask(format);
                conversionMeta.setTrimType(trimType);
                conversionMeta.setDecimalSymbol(".");
                conversionMeta.setGroupingSymbol(",");
                conversionMeta.setLength(15);
                conversionMeta.setPrecision(precision);
                this.evaluationResults.add(new StringEvaluationResult(conversionMeta));
                conversionMeta = new ValueMeta("number-eu", 1);
                conversionMeta.setConversionMask(format);
                conversionMeta.setTrimType(trimType);
                conversionMeta.setDecimalSymbol(",");
                conversionMeta.setGroupingSymbol(".");
                conversionMeta.setLength(15);
                conversionMeta.setPrecision(precision);
                this.evaluationResults.add(new StringEvaluationResult(conversionMeta));
            }
            DecimalFormat currencyFormat = (DecimalFormat)NumberFormat.getCurrencyInstance();
            ValueMeta conversionMeta2 = new ValueMeta("number-currency", 1);
            String currencyMask = currencyFormat.toLocalizedPattern().replace("\u00a4", currencyFormat.getCurrency().getSymbol());
            conversionMeta2.setConversionMask(currencyMask);
            conversionMeta2.setTrimType(trimType);
            conversionMeta2.setDecimalSymbol(String.valueOf(currencyFormat.getDecimalFormatSymbols().getDecimalSeparator()));
            conversionMeta2.setGroupingSymbol(String.valueOf(currencyFormat.getDecimalFormatSymbols().getGroupingSeparator()));
            conversionMeta2.setCurrencySymbol(currencyFormat.getCurrency().getSymbol());
            conversionMeta2.setLength(15);
            conversionMeta2.setPrecision(currencyFormat.getCurrency().getDefaultFractionDigits());
            this.evaluationResults.add(new StringEvaluationResult(conversionMeta2));
            conversionMeta2 = new ValueMeta("integer", 5);
            conversionMeta2.setConversionMask("#");
            conversionMeta2.setLength(15);
            this.evaluationResults.add(new StringEvaluationResult(conversionMeta2));
            conversionMeta2 = new ValueMeta("integer", 5);
            conversionMeta2.setConversionMask(" #");
            conversionMeta2.setLength(15);
            this.evaluationResults.add(new StringEvaluationResult(conversionMeta2));
            for (int i = 1; i <= 15; ++i) {
                int x;
                String mask = " ";
                for (x = 0; x < i; ++x) {
                    mask = mask + "0";
                }
                mask = mask + ";-";
                for (x = 0; x < i; ++x) {
                    mask = mask + "0";
                }
                conversionMeta2 = new ValueMeta("integer-zero-padded-" + i, 5);
                conversionMeta2.setConversionMask(mask);
                conversionMeta2.setLength(i);
                this.evaluationResults.add(new StringEvaluationResult(conversionMeta2));
            }
            conversionMeta2 = new ValueMeta("boolean", 4);
            this.evaluationResults.add(new StringEvaluationResult(conversionMeta2));
        }
    }

    protected static int determinePrecision(String numericFormat) {
        char decimalSymbol = ((DecimalFormat)NumberFormat.getInstance()).getDecimalFormatSymbols().getDecimalSeparator();
        Pattern p = Pattern.compile("[^0-9#]");
        Matcher m = null;
        if (numericFormat != null) {
            int loc = numericFormat.lastIndexOf(decimalSymbol);
            if (loc >= 0 && loc < numericFormat.length()) {
                m = p.matcher(numericFormat.substring(loc + 1));
                int nonDigitLoc = numericFormat.length();
                if (m.find()) {
                    nonDigitLoc = loc + 1 + m.start();
                }
                return numericFormat.substring(loc + 1, nonDigitLoc).length();
            }
            return 0;
        }
        return 0;
    }

    public Set<String> getValues() {
        return this.values;
    }

    public List<StringEvaluationResult> getStringEvaluationResults() {
        return this.evaluationResults;
    }

    public int getCount() {
        return this.count;
    }

    public int getMaxLength() {
        return this.maxLength;
    }
}

