/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.AbstractMessageHandler;
import org.pentaho.di.i18n.LanguageChoice;
import org.pentaho.di.i18n.MessageHandler;

public class GlobalMessages
extends AbstractMessageHandler {
    private static String packageNM = GlobalMessages.class.getPackage().getName();
    protected static final ThreadLocal<Locale> threadLocales = new ThreadLocal();
    protected static final LanguageChoice langChoice = LanguageChoice.getInstance();
    protected static final String SYSTEM_BUNDLE_PACKAGE = GlobalMessages.class.getPackage().getName();
    protected static final String BUNDLE_NAME = "messages.messages";
    protected static final Map<String, ResourceBundle> locales = Collections.synchronizedMap(new HashMap());
    protected static final LogChannelInterface log = new LogChannel("i18n");
    public static final String[] localeCodes = new String[]{"en_US", "nl_NL", "zh_CN", "es_ES", "fr_FR", "de_DE", "pt_BR", "pt_PT", "es_AR", "no_NO", "it_IT", "ja_JP", "ko_KR"};
    public static final String[] localeDescr = new String[]{"English (US)", "Nederlands", "Simplified Chinese", "Espa\u00f1ol (Spain)", "Fran\u00e7ais", "Deutsch", "Portuguese (Brazil)", "Portuguese (Portugal)", "Espa\u00f1ol (Argentina)", "Norwegian (Norway)", "Italian (Italy)", "Japanese (Japan)", "Korean (Korea)"};
    protected static GlobalMessages GMinstance = null;

    public static synchronized MessageHandler getInstance() {
        if (GMinstance == null) {
            GMinstance = new GlobalMessages();
        }
        return GMinstance;
    }

    protected static Map<String, ResourceBundle> getLocales() {
        return locales;
    }

    public static synchronized Locale getLocale() {
        Locale rtn = threadLocales.get();
        if (rtn != null) {
            return rtn;
        }
        GlobalMessages.setLocale(langChoice.getDefaultLocale());
        return langChoice.getDefaultLocale();
    }

    public static synchronized void setLocale(Locale newLocale) {
        threadLocales.set(newLocale);
    }

    protected static String getLocaleString(Locale locale) {
        String locString = locale.toString();
        if (locString.length() == 5 && locString.charAt(2) == '_') {
            locString = locString.substring(0, 2).toLowerCase() + "_" + locString.substring(3).toUpperCase();
        }
        return locString;
    }

    protected static String buildHashKey(Locale locale, String packageName) {
        return packageName + "_" + GlobalMessages.getLocaleString(locale);
    }

    protected static String buildBundleName(String packageName) {
        return packageName + "." + BUNDLE_NAME;
    }

    public static ResourceBundle getBundle(String packageName) throws MissingResourceException {
        return GlobalMessages.getBundle(packageName, GlobalMessages.getInstance().getClass());
    }

    public static ResourceBundle getBundle(String packageName, Class<?> resourceClass) throws MissingResourceException {
        try {
            ResourceBundle bundle = GlobalMessages.getBundle(LanguageChoice.getInstance().getDefaultLocale(), packageName, resourceClass);
            return bundle;
        }
        catch (MissingResourceException e) {
            try {
                ResourceBundle bundle = GlobalMessages.getBundle(LanguageChoice.getInstance().getFailoverLocale(), packageName, resourceClass);
                return bundle;
            }
            catch (MissingResourceException e2) {
                throw new MissingResourceException("Unable to find properties file in the default '" + LanguageChoice.getInstance().getDefaultLocale() + "' nor the failore locale '" + LanguageChoice.getInstance().getFailoverLocale() + "'", packageName, packageName);
            }
        }
    }

    public static ResourceBundle getBundle(Locale locale, String packageName) throws MissingResourceException {
        return GlobalMessages.getBundle(locale, packageName, GlobalMessages.getInstance().getClass());
    }

    public static ResourceBundle getBundle(Locale locale, String packageName, Class<?> resourceClass) throws MissingResourceException {
        String filename = GlobalMessages.buildHashKey(locale, packageName);
        filename = "/" + filename.replace('.', '/') + ".properties";
        InputStream inputStream = null;
        try {
            ResourceBundle bundle = locales.get(filename);
            if (bundle == null) {
                inputStream = resourceClass.getResourceAsStream(filename);
                if (inputStream == null) {
                    inputStream = ClassLoader.getSystemResourceAsStream(filename);
                }
                if (inputStream != null) {
                    bundle = new PropertyResourceBundle(inputStream);
                    locales.put(filename, bundle);
                } else {
                    throw new MissingResourceException("Unable to find properties file [" + filename + "]", locale.toString(), packageName);
                }
            }
            ResourceBundle resourceBundle = bundle;
            return resourceBundle;
        }
        catch (IOException e) {
            throw new MissingResourceException("Unable to find properties file [" + filename + "] : " + e.toString(), locale.toString(), packageName);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    protected String findString(String packageName, Locale locale, String key, Object[] parameters) throws MissingResourceException {
        return this.findString(packageName, locale, key, parameters, GlobalMessages.getInstance().getClass());
    }

    protected String findString(String packageName, Locale locale, String key, Object[] parameters, Class<?> resourceClass) throws MissingResourceException {
        try {
            ResourceBundle bundle = GlobalMessages.getBundle(locale, packageName + "." + BUNDLE_NAME, resourceClass);
            String unformattedString = bundle.getString(key);
            String string = MessageFormat.format(unformattedString, parameters);
            return string;
        }
        catch (IllegalArgumentException e) {
            String message = "Format problem with key=[" + key + "], locale=[" + locale + "], package=" + packageName + " : " + e.toString();
            log.logError(message);
            log.logError(Const.getStackTracker(e));
            throw new MissingResourceException(message, packageName, key);
        }
    }

    protected String calculateString(String packageName, String key, Object[] parameters) {
        return this.calculateString(packageName, key, parameters, GlobalMessages.getInstance().getClass());
    }

    protected String calculateString(String packageName, String key, Object[] parameters, Class<?> resourceClass) {
        String string = null;
        try {
            string = this.findString(packageName, langChoice.getDefaultLocale(), key, parameters, resourceClass);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (string != null) {
            return string;
        }
        try {
            string = this.findString(SYSTEM_BUNDLE_PACKAGE, langChoice.getDefaultLocale(), key, parameters, resourceClass);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (string != null) {
            return string;
        }
        try {
            string = this.findString(packageName, langChoice.getFailoverLocale(), key, parameters, resourceClass);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (string != null) {
            return string;
        }
        try {
            string = this.findString(SYSTEM_BUNDLE_PACKAGE, langChoice.getFailoverLocale(), key, parameters, resourceClass);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (string != null) {
            return string;
        }
        string = "!" + key + "!";
        String message = "Message not found in the preferred and failover locale: key=[" + key + "], package=" + packageName;
        log.logDetailed(Const.getStackTracker(new KettleException(message)));
        return string;
    }

    @Override
    public String getString(String key) {
        Object[] parameters = null;
        return this.calculateString(packageNM, key, parameters);
    }

    @Override
    public String getString(String packageName, String key) {
        Object[] parameters = new Object[]{};
        return this.calculateString(packageName, key, parameters);
    }

    @Override
    public String getString(String packageName, String key, String ... parameters) {
        return this.calculateString(packageName, key, parameters);
    }

    @Override
    public String getString(String packageName, String key, Class<?> resourceClass, String ... parameters) {
        return this.calculateString(packageName, key, parameters, resourceClass);
    }
}

