/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metastore.stores.xml;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.pentaho.metastore.api.BaseMetaStore;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.IMetaStoreAttribute;
import org.pentaho.metastore.api.IMetaStoreElement;
import org.pentaho.metastore.api.IMetaStoreElementType;
import org.pentaho.metastore.api.exceptions.MetaStoreDependenciesExistsException;
import org.pentaho.metastore.api.exceptions.MetaStoreElementExistException;
import org.pentaho.metastore.api.exceptions.MetaStoreElementTypeExistsException;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.api.exceptions.MetaStoreNamespaceExistsException;
import org.pentaho.metastore.api.security.IMetaStoreElementOwner;
import org.pentaho.metastore.api.security.MetaStoreElementOwnerType;
import org.pentaho.metastore.stores.xml.XmlMetaStoreAttribute;
import org.pentaho.metastore.stores.xml.XmlMetaStoreElement;
import org.pentaho.metastore.stores.xml.XmlMetaStoreElementOwner;
import org.pentaho.metastore.stores.xml.XmlMetaStoreElementType;
import org.pentaho.metastore.stores.xml.XmlUtil;

public class XmlMetaStore
extends BaseMetaStore
implements IMetaStore {
    private String rootFolder;
    private File rootFile;

    public XmlMetaStore() throws MetaStoreException {
        this(System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID());
    }

    public XmlMetaStore(String rootFolder) throws MetaStoreException {
        this.rootFolder = rootFolder + File.separator + "metastore";
        this.rootFile = new File(this.rootFolder);
        if (!this.rootFile.exists() && !this.rootFile.mkdirs()) {
            throw new MetaStoreException("Unable to create XML meta store root folder: " + this.rootFolder);
        }
        this.setName(this.rootFolder);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof XmlMetaStore)) {
            return false;
        }
        return ((XmlMetaStore)obj).name.equalsIgnoreCase(this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<String> getNamespaces() throws MetaStoreException {
        this.lockStore();
        try {
            File[] files = this.listFolders(this.rootFile);
            ArrayList<String> namespaces = new ArrayList<String>();
            for (File file : files) {
                namespaces.add(file.getName());
            }
            ArrayList<String> arrayList = namespaces;
            return arrayList;
        }
        finally {
            this.unlockStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean namespaceExists(String namespace) throws MetaStoreException {
        this.lockStore();
        try {
            String spaceFolder = XmlUtil.getNamespaceFolder(this.rootFolder, namespace);
            File spaceFile = new File(spaceFolder);
            boolean bl = spaceFile.exists();
            return bl;
        }
        finally {
            this.unlockStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void createNamespace(String namespace) throws MetaStoreException, MetaStoreNamespaceExistsException {
        this.lockStore();
        try {
            String spaceFolder = XmlUtil.getNamespaceFolder(this.rootFolder, namespace);
            File spaceFile = new File(spaceFolder);
            if (spaceFile.exists()) {
                throw new MetaStoreNamespaceExistsException("The namespace with name '" + namespace + "' already exists.");
            }
            if (!spaceFile.mkdir()) {
                throw new MetaStoreException("Unable to create XML meta store namespace folder: " + spaceFolder);
            }
        }
        finally {
            this.unlockStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void deleteNamespace(String namespace) throws MetaStoreException, MetaStoreElementTypeExistsException {
        this.lockStore();
        try {
            String spaceFolder = XmlUtil.getNamespaceFolder(this.rootFolder, namespace);
            File spaceFile = new File(spaceFolder);
            if (!spaceFile.exists()) {
                return;
            }
            List<IMetaStoreElementType> elementTypes = this.getElementTypes(namespace, false);
            if (!elementTypes.isEmpty()) {
                ArrayList<String> dependencies = new ArrayList<String>();
                for (IMetaStoreElementType elementType : elementTypes) {
                    dependencies.add(elementType.getId());
                }
                throw new MetaStoreDependenciesExistsException(dependencies, "Unable to delete the XML meta store namespace with name '" + namespace + "' as it still contains dependencies");
            }
            if (!spaceFile.delete()) {
                throw new MetaStoreException("Unable to delete XML meta store namespace folder, check to see if it's empty");
            }
        }
        finally {
            this.unlockStore();
        }
    }

    @Override
    public synchronized List<IMetaStoreElementType> getElementTypes(String namespace) throws MetaStoreException {
        return this.getElementTypes(namespace, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized List<IMetaStoreElementType> getElementTypes(String namespace, boolean lock) throws MetaStoreException {
        if (lock) {
            this.lockStore();
        }
        try {
            File[] elementTypeFolders;
            ArrayList<IMetaStoreElementType> elementTypes = new ArrayList<IMetaStoreElementType>();
            String spaceFolder = XmlUtil.getNamespaceFolder(this.rootFolder, namespace);
            File spaceFolderFile = new File(spaceFolder);
            for (File elementTypeFolder : elementTypeFolders = this.listFolders(spaceFolderFile)) {
                String elementTypeId = elementTypeFolder.getName();
                XmlMetaStoreElementType elementType = this.getElementType(namespace, elementTypeId, false);
                elementTypes.add(elementType);
            }
            ArrayList<IMetaStoreElementType> arrayList = elementTypes;
            return arrayList;
        }
        finally {
            if (lock) {
                this.unlockStore();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<String> getElementTypeIds(String namespace) throws MetaStoreException {
        this.lockStore();
        try {
            File[] elementTypeFolders;
            ArrayList<String> ids = new ArrayList<String>();
            String spaceFolder = XmlUtil.getNamespaceFolder(this.rootFolder, namespace);
            File spaceFolderFile = new File(spaceFolder);
            for (File elementTypeFolder : elementTypeFolders = this.listFolders(spaceFolderFile)) {
                String elementTypeId = elementTypeFolder.getName();
                ids.add(elementTypeId);
            }
            ArrayList<String> arrayList = ids;
            return arrayList;
        }
        finally {
            this.unlockStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized XmlMetaStoreElementType getElementType(String namespace, String elementTypeId, boolean lock) throws MetaStoreException {
        if (lock) {
            this.lockStore();
        }
        try {
            String elementTypeFile = XmlUtil.getElementTypeFile(this.rootFolder, namespace, elementTypeId);
            XmlMetaStoreElementType elementType = new XmlMetaStoreElementType(namespace, elementTypeFile);
            elementType.setMetaStoreName(this.getName());
            XmlMetaStoreElementType xmlMetaStoreElementType = elementType;
            return xmlMetaStoreElementType;
        }
        finally {
            if (lock) {
                this.unlockStore();
            }
        }
    }

    @Override
    public synchronized XmlMetaStoreElementType getElementType(String namespace, String elementTypeId) throws MetaStoreException {
        return this.getElementType(namespace, elementTypeId, true);
    }

    @Override
    public synchronized XmlMetaStoreElementType getElementTypeByName(String namespace, String elementTypeName) throws MetaStoreException {
        for (IMetaStoreElementType elementType : this.getElementTypes(namespace)) {
            if (elementType.getName() == null || !elementType.getName().equalsIgnoreCase(elementTypeName)) continue;
            return (XmlMetaStoreElementType)elementType;
        }
        return null;
    }

    @Override
    public IMetaStoreAttribute newAttribute(String id, Object value) throws MetaStoreException {
        return new XmlMetaStoreAttribute(id, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void createElementType(String namespace, IMetaStoreElementType elementType) throws MetaStoreException, MetaStoreElementTypeExistsException {
        this.lockStore();
        try {
            String elementTypeFolder;
            File elementTypeFolderFile;
            if (elementType.getId() == null) {
                elementType.setId(elementType.getName());
            }
            if ((elementTypeFolderFile = new File(elementTypeFolder = XmlUtil.getElementTypeFolder(this.rootFolder, namespace, elementType.getId()))).exists()) {
                throw new MetaStoreElementTypeExistsException(this.getElementTypes(namespace, false), "The specified element type already exists with the same ID");
            }
            if (!elementTypeFolderFile.mkdir()) {
                throw new MetaStoreException("Unable to create XML meta store element type folder '" + elementTypeFolder + "'");
            }
            String elementTypeFilename = XmlUtil.getElementTypeFile(this.rootFolder, namespace, elementType.getId());
            XmlMetaStoreElementType xmlType = new XmlMetaStoreElementType(namespace, elementType.getId(), elementType.getName(), elementType.getDescription());
            xmlType.setFilename(elementTypeFilename);
            xmlType.save();
            xmlType.setMetaStoreName(this.getName());
        }
        finally {
            this.unlockStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateElementType(String namespace, IMetaStoreElementType elementType) throws MetaStoreException {
        this.lockStore();
        try {
            String elementTypeFolder = XmlUtil.getElementTypeFolder(this.rootFolder, namespace, elementType.getId());
            File elementTypeFolderFile = new File(elementTypeFolder);
            if (!elementTypeFolderFile.exists()) {
                throw new MetaStoreException("The specified element type with ID '" + elementType.getId() + "' doesn't exists so we can't update it.");
            }
            String elementTypeFilename = XmlUtil.getElementTypeFile(this.rootFolder, namespace, elementType.getId());
            XmlMetaStoreElementType xmlType = new XmlMetaStoreElementType(namespace, elementType.getId(), elementType.getName(), elementType.getDescription());
            xmlType.setFilename(elementTypeFilename);
            xmlType.save();
        }
        finally {
            this.unlockStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void deleteElementType(String namespace, IMetaStoreElementType elementType) throws MetaStoreException, MetaStoreDependenciesExistsException {
        this.lockStore();
        try {
            String elementTypeFilename = XmlUtil.getElementTypeFile(this.rootFolder, namespace, elementType.getName());
            File elementTypeFile = new File(elementTypeFilename);
            if (!elementTypeFile.exists()) {
                return;
            }
            List<IMetaStoreElement> elements = this.getElements(namespace, elementType, false);
            if (!elements.isEmpty()) {
                ArrayList<String> dependencies = new ArrayList<String>();
                for (IMetaStoreElement element : elements) {
                    dependencies.add(element.getId());
                }
                throw new MetaStoreDependenciesExistsException(dependencies, "Unable to delete element type with name '" + elementType.getName() + "' in namespace '" + namespace + "' because there are still elements present");
            }
            if (!elementTypeFile.delete()) {
                throw new MetaStoreException("Unable to delete element type XML file '" + elementTypeFilename + "'");
            }
            String elementTypeFolder = XmlUtil.getElementTypeFolder(this.rootFolder, namespace, elementType.getName());
            File elementTypeFolderFile = new File(elementTypeFolder);
            if (!elementTypeFolderFile.delete()) {
                throw new MetaStoreException("Unable to delete element type XML folder '" + elementTypeFolder + "'");
            }
        }
        finally {
            this.unlockStore();
        }
    }

    @Override
    public List<IMetaStoreElement> getElements(String namespace, IMetaStoreElementType elementType) throws MetaStoreException {
        return this.getElements(namespace, elementType, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized List<IMetaStoreElement> getElements(String namespace, IMetaStoreElementType elementType, boolean lock) throws MetaStoreException {
        if (lock) {
            this.lockStore();
        }
        try {
            File[] elementTypeFiles;
            ArrayList<IMetaStoreElement> elements = new ArrayList<IMetaStoreElement>();
            String elementTypeFolder = XmlUtil.getElementTypeFolder(this.rootFolder, namespace, elementType.getName());
            File elementTypeFolderFile = new File(elementTypeFolder);
            for (File elementTypeFile : elementTypeFiles = this.listFiles(elementTypeFolderFile)) {
                String elementId = elementTypeFile.getName();
                elementId = elementId.substring(0, elementId.length() - 4);
                elements.add(this.getElement(namespace, elementType, elementId, false));
            }
            ArrayList<IMetaStoreElement> arrayList = elements;
            return arrayList;
        }
        finally {
            if (lock) {
                this.unlockStore();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<String> getElementIds(String namespace, IMetaStoreElementType elementType) throws MetaStoreException {
        this.lockStore();
        try {
            File[] elementTypeFiles;
            ArrayList<String> elementIds = new ArrayList<String>();
            String elementTypeFolder = XmlUtil.getElementTypeFolder(this.rootFolder, namespace, elementType.getName());
            File elementTypeFolderFile = new File(elementTypeFolder);
            for (File elementTypeFile : elementTypeFiles = this.listFiles(elementTypeFolderFile)) {
                String elementId = elementTypeFile.getName();
                elementId = elementId.substring(0, elementId.length() - 4);
                elementIds.add(elementId);
            }
            ArrayList<String> arrayList = elementIds;
            return arrayList;
        }
        finally {
            this.unlockStore();
        }
    }

    @Override
    public IMetaStoreElement getElement(String namespace, IMetaStoreElementType elementType, String elementId) throws MetaStoreException {
        return this.getElement(namespace, elementType, elementId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized IMetaStoreElement getElement(String namespace, IMetaStoreElementType elementType, String elementId, boolean lock) throws MetaStoreException {
        if (lock) {
            this.lockStore();
        }
        try {
            String elementFilename = XmlUtil.getElementFile(this.rootFolder, namespace, elementType.getName(), elementId);
            File elementFile = new File(elementFilename);
            if (!elementFile.exists()) {
                IMetaStoreElement iMetaStoreElement = null;
                return iMetaStoreElement;
            }
            XmlMetaStoreElement xmlMetaStoreElement = new XmlMetaStoreElement(elementFilename);
            return xmlMetaStoreElement;
        }
        finally {
            if (lock) {
                this.unlockStore();
            }
        }
    }

    @Override
    public IMetaStoreElement getElementByName(String namespace, IMetaStoreElementType elementType, String name) throws MetaStoreException {
        for (IMetaStoreElement element : this.getElements(namespace, elementType)) {
            if (element.getName() == null || !element.getName().equalsIgnoreCase(name)) continue;
            return element;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void createElement(String namespace, IMetaStoreElementType elementType, IMetaStoreElement element) throws MetaStoreException, MetaStoreElementExistException {
        this.lockStore();
        try {
            String elementFilename;
            File elementFile;
            if (element.getId() == null) {
                element.setId(element.getName());
            }
            if ((elementFile = new File(elementFilename = XmlUtil.getElementFile(this.rootFolder, namespace, elementType.getName(), element.getId()))).exists()) {
                throw new MetaStoreElementExistException(this.getElements(namespace, elementType, false), "The specified element already exists with the same ID: '" + element.getId() + "'");
            }
            XmlMetaStoreElement xmlElement = new XmlMetaStoreElement(element);
            xmlElement.setFilename(elementFilename);
            xmlElement.save();
            element.setId(xmlElement.getName());
        }
        finally {
            this.unlockStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateElement(String namespace, IMetaStoreElementType elementType, String elementId, IMetaStoreElement element) throws MetaStoreException {
        if (elementType.getMetaStoreName() == null || !elementType.getMetaStoreName().equals(this.getName())) {
            throw new MetaStoreException("The element type '" + elementType.getName() + "' needs to explicitly belong to the meta store in which you are updating.");
        }
        this.lockStore();
        try {
            String elementFilename = XmlUtil.getElementFile(this.rootFolder, namespace, elementType.getName(), element.getName());
            File elementFile = new File(elementFilename);
            if (!elementFile.exists()) {
                throw new MetaStoreException("The specified element to update doesn't exist with ID: '" + elementId + "'");
            }
            XmlMetaStoreElement xmlElement = new XmlMetaStoreElement(element);
            xmlElement.setFilename(elementFilename);
            xmlElement.setIdWithFilename(elementFilename);
            xmlElement.save();
        }
        finally {
            this.unlockStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void deleteElement(String namespace, IMetaStoreElementType elementType, String elementId) throws MetaStoreException {
        this.lockStore();
        try {
            String elementFilename = XmlUtil.getElementFile(this.rootFolder, namespace, elementType.getName(), elementId);
            File elementFile = new File(elementFilename);
            if (!elementFile.exists()) {
                return;
            }
            if (!elementFile.delete()) {
                throw new MetaStoreException("Unable to delete element with ID '" + elementId + "' in filename '" + elementFilename + "'");
            }
        }
        finally {
            this.unlockStore();
        }
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public void setRootFolder(String rootFolder) {
        this.rootFolder = rootFolder;
    }

    protected File[] listFolders(File folder) {
        File[] folders = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isHidden() && file.isDirectory();
            }
        });
        if (folders == null) {
            folders = new File[]{};
        }
        return folders;
    }

    protected File[] listFiles(File folder) {
        File[] files = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isHidden() && file.isFile();
            }
        });
        if (files == null) {
            files = new File[]{};
        }
        return files;
    }

    @Override
    public IMetaStoreElementType newElementType(String namespace) throws MetaStoreException {
        return new XmlMetaStoreElementType(namespace, null, null, null);
    }

    @Override
    public IMetaStoreElement newElement() throws MetaStoreException {
        return new XmlMetaStoreElement();
    }

    @Override
    public IMetaStoreElement newElement(IMetaStoreElementType elementType, String id, Object value) throws MetaStoreException {
        return new XmlMetaStoreElement(elementType, id, value);
    }

    @Override
    public IMetaStoreElementOwner newElementOwner(String name, MetaStoreElementOwnerType ownerType) throws MetaStoreException {
        return new XmlMetaStoreElementOwner(name, ownerType);
    }

    protected void lockStore() throws MetaStoreException {
        boolean waiting = true;
        long totalTime = 0L;
        while (waiting) {
            File lockFile = new File(this.rootFile, ".lock");
            try {
                if (lockFile.createNewFile()) {
                    return;
                }
            }
            catch (IOException e) {
                throw new MetaStoreException("Unable to create lock file: " + lockFile.toString(), e);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if ((totalTime += 100L) <= 10000L) continue;
            throw new MetaStoreException("Maximum wait time of 10 seconds exceed while acquiring lock");
        }
    }

    protected void unlockStore() {
        File lockFile = new File(this.rootFile, ".lock");
        lockFile.delete();
    }
}

