/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.avro.ipc.NettyServer;
import org.apache.avro.ipc.NettyTransceiver;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.avro.test.Mail;
import org.apache.avro.test.Message;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestNettyServer {
    static final long CONNECT_TIMEOUT_MILLIS = 2000L;
    private static Server server;
    private static Transceiver transceiver;
    private static Mail proxy;
    private static MailImpl mailService;

    @BeforeClass
    public static void initializeConnections() throws Exception {
        System.out.println("starting server...");
        mailService = new MailImpl();
        SpecificResponder responder = new SpecificResponder(Mail.class, (Object)mailService);
        server = new NettyServer((Responder)responder, new InetSocketAddress(0));
        server.start();
        int serverPort = server.getPort();
        System.out.println("server port : " + serverPort);
        transceiver = new NettyTransceiver(new InetSocketAddress(serverPort), Long.valueOf(2000L));
        proxy = (Mail)SpecificRequestor.getClient(Mail.class, (Transceiver)transceiver);
    }

    @AfterClass
    public static void tearDownConnections() throws Exception {
        transceiver.close();
        server.close();
    }

    @Test
    public void testRequestResponse() throws Exception {
        for (int x = 0; x < 5; ++x) {
            this.verifyResponse(proxy.send(this.createMessage()));
        }
    }

    private void verifyResponse(String result) {
        junit.framework.Assert.assertEquals((String)"Sent message to [wife] from [husband] with body [I love you!]", (String)result.toString());
    }

    @Test
    public void testOneway() throws Exception {
        for (int x = 0; x < 5; ++x) {
            proxy.fireandforget(this.createMessage());
        }
        TestNettyServer.mailService.awaitMessages();
        TestNettyServer.mailService.assertAllMessagesReceived();
    }

    @Test
    public void testMixtureOfRequests() throws Exception {
        mailService.reset();
        for (int x = 0; x < 5; ++x) {
            Message createMessage = this.createMessage();
            proxy.fireandforget(createMessage);
            this.verifyResponse(proxy.send(createMessage));
        }
        TestNettyServer.mailService.awaitMessages();
        TestNettyServer.mailService.assertAllMessagesReceived();
    }

    @Test
    public void testConnectionsCount() throws Exception {
        NettyTransceiver transceiver2 = new NettyTransceiver(new InetSocketAddress(server.getPort()), Long.valueOf(2000L));
        Mail proxy2 = (Mail)SpecificRequestor.getClient(Mail.class, (Transceiver)transceiver2);
        proxy.fireandforget(this.createMessage());
        proxy2.fireandforget(this.createMessage());
        junit.framework.Assert.assertEquals((int)2, (int)((NettyServer)server).getNumActiveConnections());
        transceiver2.close();
        junit.framework.Assert.assertEquals((int)1, (int)((NettyServer)server).getNumActiveConnections());
    }

    private Message createMessage() {
        Message msg = Message.newBuilder().setTo("wife").setFrom("husband").setBody("I love you!").build();
        return msg;
    }

    @Test
    public void testBadRequest() throws IOException {
        int port = server.getPort();
        String msg = "GET /status HTTP/1.1\n\n";
        InetSocketAddress sockAddr = new InetSocketAddress("127.0.0.1", port);
        Socket sock = new Socket();
        sock.connect(sockAddr);
        OutputStream out = sock.getOutputStream();
        out.write(msg.getBytes(Charset.forName("UTF-8")));
        out.flush();
        byte[] buf = new byte[2048];
        int bytesRead = sock.getInputStream().read(buf);
        junit.framework.Assert.assertTrue((String)"Connection should have been closed", (bytesRead == -1 ? 1 : 0) != 0);
    }

    public static class MailImpl
    implements Mail {
        private CountDownLatch allMessages = new CountDownLatch(5);

        @Override
        public String send(Message message) {
            return "Sent message to [" + message.getTo().toString() + "] from [" + message.getFrom().toString() + "] with body [" + message.getBody().toString() + "]";
        }

        @Override
        public void fireandforget(Message message) {
            this.allMessages.countDown();
        }

        private void awaitMessages() throws InterruptedException {
            this.allMessages.await(2L, TimeUnit.SECONDS);
        }

        private void assertAllMessagesReceived() {
            Assert.assertEquals((long)0L, (long)this.allMessages.getCount());
        }

        public void reset() {
            this.allMessages = new CountDownLatch(5);
        }
    }
}

