/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc;

import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.avro.ipc.NettyServer;
import org.apache.avro.ipc.NettyTransceiver;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.TestNettyServer;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.avro.test.Mail;
import org.apache.avro.test.Message;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.SocketChannel;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.ssl.SslHandler;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestNettyServerWithSSL {
    public static final String TEST_CERTIFICATE = "servercert.p12";
    public static final String TEST_CERTIFICATE_PASSWORD = "s3cret";
    static final long CONNECT_TIMEOUT_MILLIS = 2000L;
    private static Server server;
    private static Transceiver transceiver;
    private static Mail proxy;
    private static MailImpl mailService;

    @BeforeClass
    public static void initializeConnections() throws Exception {
        System.out.println("starting server...");
        mailService = new MailImpl();
        SpecificResponder responder = new SpecificResponder(Mail.class, (Object)mailService);
        NioServerSocketChannelFactory channelFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        server = new NettyServer((Responder)responder, new InetSocketAddress(0), (ChannelFactory)channelFactory, (ChannelPipelineFactory)new SSLChannelPipelineFactory(), null);
        server.start();
        int serverPort = server.getPort();
        System.out.println("server port : " + serverPort);
        transceiver = new NettyTransceiver(new InetSocketAddress(serverPort), (ChannelFactory)new SSLChannelFactory(), Long.valueOf(2000L));
        proxy = (Mail)SpecificRequestor.getClient(Mail.class, (Transceiver)transceiver);
    }

    @AfterClass
    public static void tearDownConnections() throws Exception {
        transceiver.close();
        server.close();
    }

    @Test
    public void testRequestResponse() throws Exception {
        for (int x = 0; x < 5; ++x) {
            this.verifyResponse(proxy.send(this.createMessage()));
        }
    }

    private void verifyResponse(String result) {
        junit.framework.Assert.assertEquals((String)"Sent message to [wife] from [husband] with body [I love you!]", (String)result.toString());
    }

    @Test
    public void testOneway() throws Exception {
        for (int x = 0; x < 5; ++x) {
            proxy.fireandforget(this.createMessage());
        }
        TestNettyServerWithSSL.mailService.awaitMessages();
        TestNettyServerWithSSL.mailService.assertAllMessagesReceived();
    }

    @Test
    public void testMixtureOfRequests() throws Exception {
        mailService.reset();
        for (int x = 0; x < 5; ++x) {
            Message createMessage = this.createMessage();
            proxy.fireandforget(createMessage);
            this.verifyResponse(proxy.send(createMessage));
        }
        TestNettyServerWithSSL.mailService.awaitMessages();
        TestNettyServerWithSSL.mailService.assertAllMessagesReceived();
    }

    private Message createMessage() {
        Message msg = Message.newBuilder().setTo("wife").setFrom("husband").setBody("I love you!").build();
        return msg;
    }

    private static class SSLChannelPipelineFactory
    implements ChannelPipelineFactory {
        private SSLChannelPipelineFactory() {
        }

        private SSLContext createServerSSLContext() {
            try {
                KeyStore ks = KeyStore.getInstance("PKCS12");
                ks.load(TestNettyServer.class.getResource(TestNettyServerWithSSL.TEST_CERTIFICATE).openStream(), TestNettyServerWithSSL.TEST_CERTIFICATE_PASSWORD.toCharArray());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.getAlgorithm());
                kmf.init(ks, TestNettyServerWithSSL.TEST_CERTIFICATE_PASSWORD.toCharArray());
                SSLContext serverContext = SSLContext.getInstance("TLS");
                serverContext.init(kmf.getKeyManagers(), null, null);
                return serverContext;
            }
            catch (Exception e) {
                throw new Error("Failed to initialize the server-side SSLContext", e);
            }
        }

        private String getAlgorithm() {
            String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
            if (algorithm == null) {
                algorithm = "SunX509";
            }
            return algorithm;
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            SSLEngine sslEngine = this.createServerSSLContext().createSSLEngine();
            sslEngine.setUseClientMode(false);
            pipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
            return pipeline;
        }
    }

    private static class BogusTrustManager
    implements X509TrustManager {
        private BogusTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String s) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class SSLChannelFactory
    extends NioClientSocketChannelFactory {
        public SSLChannelFactory() {
            super((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        }

        public SocketChannel newChannel(ChannelPipeline pipeline) {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{new BogusTrustManager()}, null);
                SSLEngine sslEngine = sslContext.createSSLEngine();
                sslEngine.setUseClientMode(true);
                pipeline.addFirst("ssl", (ChannelHandler)new SslHandler(sslEngine));
                return super.newChannel(pipeline);
            }
            catch (Exception ex) {
                throw new RuntimeException("Cannot create SSL channel", ex);
            }
        }
    }

    public static class MailImpl
    implements Mail {
        private CountDownLatch allMessages = new CountDownLatch(5);

        @Override
        public String send(Message message) {
            return "Sent message to [" + message.getTo().toString() + "] from [" + message.getFrom().toString() + "] with body [" + message.getBody().toString() + "]";
        }

        @Override
        public void fireandforget(Message message) {
            this.allMessages.countDown();
        }

        private void awaitMessages() throws InterruptedException {
            this.allMessages.await(2L, TimeUnit.SECONDS);
        }

        private void assertAllMessagesReceived() {
            Assert.assertEquals((long)0L, (long)this.allMessages.getCount());
        }

        public void reset() {
            this.allMessages = new CountDownLatch(5);
        }
    }
}

