/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.emr.job;

import com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient;
import com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsResult;
import com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig;
import com.amazonaws.services.elasticmapreduce.model.JobFlowDetail;
import com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowResult;
import com.amazonaws.services.elasticmapreduce.model.StepConfig;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.UserAuthenticator;
import org.apache.commons.vfs.auth.StaticUserAuthenticator;
import org.apache.commons.vfs.impl.DefaultFileSystemConfigBuilder;
import org.apache.log4j.Appender;
import org.pentaho.amazon.AbstractAmazonJobEntry;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.hadoop.HadoopConfigurationBootstrap;
import org.pentaho.di.core.logging.Log4jFileAppender;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.hadoopjobexecutor.JarUtility;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.hadoop.shim.spi.HadoopShim;
import org.w3c.dom.Node;

@JobEntry(id="EMRJobExecutorPlugin", name="Amazon EMR Job Executor", categoryDescription="Big Data", description="Execute MapReduce jobs in Amazon EMR", image="EMR.png")
public class AmazonElasticMapReduceJobExecutor
extends AbstractAmazonJobEntry
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = AmazonElasticMapReduceJobExecutor.class;
    private JarUtility util = new JarUtility();

    public String getMainClass(URL localJarUrl) throws Exception {
        HadoopShim shim = HadoopConfigurationBootstrap.getHadoopConfigurationProvider().getActiveConfiguration().getHadoopShim();
        Class<?> mainClass = this.util.getMainClassFromManifest(localJarUrl, shim.getClass().getClassLoader());
        if (mainClass != null) {
            return mainClass.getName();
        }
        List<Class<?>> classesWithMains = this.util.getClassesInJarWithMain(localJarUrl.toExternalForm(), shim.getClass().getClassLoader());
        if (!classesWithMains.isEmpty()) {
            return classesWithMains.get(0).getName();
        }
        throw new RuntimeException("Could not find main class in: " + localJarUrl.toExternalForm());
    }

    public Result execute(Result result, int arg1) throws KettleException {
        Log4jFileAppender appender;
        block23: {
            appender = null;
            String logFileName = "pdi-" + this.getName();
            try {
                appender = LogWriter.createFileAppender((String)logFileName, (boolean)true, (boolean)false);
                LogWriter.getInstance().addAppender((Appender)appender);
                this.log.setLogLevel(this.parentJob.getLogLevel());
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"AmazonElasticMapReduceJobExecutor.FailedToOpenLogFile", (String[])new String[]{logFileName, e.toString()}));
                this.logError(Const.getStackTracker((Throwable)e));
            }
            try {
                AmazonElasticMapReduceClient emrClient = new AmazonElasticMapReduceClient(this.awsCredentials);
                FileObject jarFile = KettleVFS.getFileObject((String)this.buildFilename(this.jarUrl));
                File tmpFile = File.createTempFile("customEMR", "jar");
                tmpFile.deleteOnExit();
                FileOutputStream tmpFileOut = new FileOutputStream(tmpFile);
                IOUtils.copy((InputStream)jarFile.getContent().getInputStream(), (OutputStream)tmpFileOut);
                URL localJarUrl = tmpFile.toURI().toURL();
                String mainClass = this.getMainClass(localJarUrl);
                AmazonS3Client s3Client = new AmazonS3Client(this.awsCredentials);
                FileSystemOptions opts = new FileSystemOptions();
                DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(opts, (UserAuthenticator)new StaticUserAuthenticator(null, this.awsCredentials.getAWSAccessKeyId(), this.awsCredentials.getAWSSecretKey()));
                FileObject stagingDirFileObject = KettleVFS.getFileObject((String)this.stagingDir, (VariableSpace)this.getVariables(), (FileSystemOptions)opts);
                String stagingBucketName = stagingDirFileObject.getName().getBaseName();
                if (!s3Client.doesBucketExist(stagingBucketName)) {
                    s3Client.createBucket(stagingBucketName);
                }
                try {
                    s3Client.deleteObject(stagingBucketName, jarFile.getName().getBaseName());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                s3Client.putObject(new PutObjectRequest(stagingBucketName, jarFile.getName().getBaseName(), tmpFile));
                String stagingS3JarUrl = "s3://" + stagingBucketName + "/" + jarFile.getName().getBaseName();
                String stagingS3BucketUrl = "s3://" + stagingBucketName;
                RunJobFlowRequest runJobFlowRequest = null;
                RunJobFlowResult runJobFlowResult = null;
                if (StringUtil.isEmpty((String)this.hadoopJobFlowId)) {
                    runJobFlowRequest = this.createJobFlow(stagingS3BucketUrl, stagingS3JarUrl, mainClass);
                    runJobFlowResult = emrClient.runJobFlow(runJobFlowRequest);
                } else {
                    ArrayList<String> jarStepArgs = new ArrayList<String>();
                    if (!StringUtil.isEmpty((String)this.cmdLineArgs)) {
                        StringTokenizer st = new StringTokenizer(this.cmdLineArgs, " ");
                        while (st.hasMoreTokens()) {
                            String token = st.nextToken();
                            this.logBasic("adding args: " + token);
                            jarStepArgs.add(token);
                        }
                    }
                    HadoopJarStepConfig hadoopJarStep = new HadoopJarStepConfig();
                    hadoopJarStep.setJar(stagingS3JarUrl);
                    hadoopJarStep.setMainClass(mainClass);
                    hadoopJarStep.setArgs(jarStepArgs);
                    StepConfig stepConfig = new StepConfig();
                    stepConfig.setName("custom jar: " + this.jarUrl);
                    stepConfig.setHadoopJarStep(hadoopJarStep);
                    ArrayList<StepConfig> steps = new ArrayList<StepConfig>();
                    steps.add(stepConfig);
                    AddJobFlowStepsRequest addJobFlowStepsRequest = new AddJobFlowStepsRequest();
                    addJobFlowStepsRequest.setJobFlowId(this.hadoopJobFlowId);
                    addJobFlowStepsRequest.setSteps(steps);
                    emrClient.addJobFlowSteps(addJobFlowStepsRequest);
                }
                String loggingIntervalS = this.environmentSubstitute(this.loggingInterval);
                int logIntv = 60;
                try {
                    logIntv = Integer.parseInt(loggingIntervalS);
                }
                catch (NumberFormatException ex) {
                    this.logError("Unable to parse logging interval '" + loggingIntervalS + "' - using " + "default of 60");
                }
                if (!this.blocking) break block23;
                try {
                    if (this.log.isBasic()) {
                        String executionState = "RUNNING";
                        ArrayList<String> jobFlowIds = new ArrayList<String>();
                        String id = this.hadoopJobFlowId;
                        if (StringUtil.isEmpty((String)this.hadoopJobFlowId)) {
                            id = runJobFlowResult.getJobFlowId();
                            jobFlowIds.add(id);
                        }
                        while (AmazonElasticMapReduceJobExecutor.isRunning(executionState)) {
                            DescribeJobFlowsRequest describeJobFlowsRequest = new DescribeJobFlowsRequest();
                            describeJobFlowsRequest.setJobFlowIds(jobFlowIds);
                            DescribeJobFlowsResult describeJobFlowsResult = emrClient.describeJobFlows(describeJobFlowsRequest);
                            boolean found = false;
                            for (JobFlowDetail jobFlowDetail : describeJobFlowsResult.getJobFlows()) {
                                if (!jobFlowDetail.getJobFlowId().equals(id)) continue;
                                executionState = jobFlowDetail.getExecutionStatusDetail().getState();
                                found = true;
                            }
                            if (!found) break;
                            this.logBasic(this.hadoopJobName + " execution status: " + executionState);
                            try {
                                if (!AmazonElasticMapReduceJobExecutor.isRunning(executionState)) continue;
                                Thread.sleep(logIntv * 1000);
                            }
                            catch (InterruptedException ie) {}
                        }
                        if ("FAILED".equalsIgnoreCase(executionState)) {
                            result.setStopped(true);
                            result.setNrErrors(1L);
                            result.setResult(false);
                            S3Object outObject = s3Client.getObject(stagingBucketName, id + "/steps/1/stdout");
                            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                            IOUtils.copy((InputStream)outObject.getObjectContent(), (OutputStream)outStream);
                            this.logError(outStream.toString());
                            S3Object errorObject = s3Client.getObject(stagingBucketName, id + "/steps/1/stderr");
                            ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
                            IOUtils.copy((InputStream)errorObject.getObjectContent(), (OutputStream)errorStream);
                            this.logError(errorStream.toString());
                        }
                    }
                }
                catch (Exception e) {
                    this.logError(e.getMessage(), e);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                result.setStopped(true);
                result.setNrErrors(1L);
                result.setResult(false);
                this.logError(t.getMessage(), t);
            }
        }
        if (appender != null) {
            LogWriter.getInstance().removeAppender((Appender)appender);
            appender.close();
            ResultFile resultFile = new ResultFile(1, appender.getFile(), this.parentJob.getJobname(), this.getName());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
        }
        return result;
    }

    public RunJobFlowRequest createJobFlow(String stagingS3BucketUrl, String stagingS3Jar, String mainClass) {
        ArrayList<String> jarStepArgs = new ArrayList<String>();
        if (!StringUtil.isEmpty((String)this.cmdLineArgs)) {
            StringTokenizer st = new StringTokenizer(this.cmdLineArgs, " ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                this.logBasic("adding args: " + token);
                jarStepArgs.add(token);
            }
        }
        HadoopJarStepConfig hadoopJarStep = new HadoopJarStepConfig();
        hadoopJarStep.setJar(stagingS3Jar);
        hadoopJarStep.setMainClass(mainClass);
        hadoopJarStep.setArgs(jarStepArgs);
        StepConfig stepConfig = new StepConfig();
        stepConfig.setName("custom jar: " + this.jarUrl);
        stepConfig.setHadoopJarStep(hadoopJarStep);
        ArrayList<StepConfig> steps = new ArrayList<StepConfig>();
        steps.add(stepConfig);
        String numInstancesS = this.environmentSubstitute(this.numInstances);
        int numInsts = 2;
        try {
            numInsts = Integer.parseInt(numInstancesS);
        }
        catch (NumberFormatException e) {
            this.logError("Unable to parse number of instances to use '" + numInstancesS + "' - " + "using 2 instances...");
        }
        JobFlowInstancesConfig instances = new JobFlowInstancesConfig();
        instances.setInstanceCount(Integer.valueOf(numInsts));
        instances.setMasterInstanceType(AmazonElasticMapReduceJobExecutor.getInstanceType(this.masterInstanceType));
        instances.setSlaveInstanceType(AmazonElasticMapReduceJobExecutor.getInstanceType(this.slaveInstanceType));
        instances.setHadoopVersion("0.20");
        RunJobFlowRequest runJobFlowRequest = new RunJobFlowRequest();
        runJobFlowRequest.setSteps(steps);
        runJobFlowRequest.setLogUri(stagingS3BucketUrl);
        runJobFlowRequest.setName(this.hadoopJobName);
        runJobFlowRequest.setInstances(instances);
        return runJobFlowRequest;
    }

    public static String getInstanceType(String unparsedInstanceType) {
        return unparsedInstanceType.substring(unparsedInstanceType.lastIndexOf("[") + 1, unparsedInstanceType.lastIndexOf("]"));
    }

    public static boolean isRunning(String state) {
        if ("COMPLETED".equalsIgnoreCase(state)) {
            return false;
        }
        if ("FAILED".equalsIgnoreCase(state)) {
            return false;
        }
        return !"TERMINATED".equalsIgnoreCase(state);
    }

    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        super.loadXML(entrynode, databases, slaveServers);
        this.hadoopJobName = XMLHandler.getTagValue((Node)entrynode, (String)"hadoop_job_name");
        this.hadoopJobFlowId = XMLHandler.getTagValue((Node)entrynode, (String)"hadoop_job_flow_id");
        this.jarUrl = XMLHandler.getTagValue((Node)entrynode, (String)"jar_url");
        this.accessKey = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"access_key"));
        this.secretKey = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"secret_key"));
        this.stagingDir = XMLHandler.getTagValue((Node)entrynode, (String)"staging_dir");
        this.numInstances = XMLHandler.getTagValue((Node)entrynode, (String)"num_instances");
        this.masterInstanceType = XMLHandler.getTagValue((Node)entrynode, (String)"master_instance_type");
        this.slaveInstanceType = XMLHandler.getTagValue((Node)entrynode, (String)"slave_instance_type");
        this.cmdLineArgs = XMLHandler.getTagValue((Node)entrynode, (String)"command_line_args");
        this.blocking = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"blocking"));
        this.loggingInterval = XMLHandler.getTagValue((Node)entrynode, (String)"logging_interval");
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(1024);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"hadoop_job_name", (String)this.hadoopJobName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"hadoop_job_flow_id", (String)this.hadoopJobFlowId));
        retval.append("      ").append(XMLHandler.addTagValue((String)"jar_url", (String)this.jarUrl));
        retval.append("      ").append(XMLHandler.addTagValue((String)"access_key", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.accessKey)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"secret_key", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.secretKey)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"staging_dir", (String)this.stagingDir));
        retval.append("      ").append(XMLHandler.addTagValue((String)"num_instances", (String)this.numInstances));
        retval.append("      ").append(XMLHandler.addTagValue((String)"master_instance_type", (String)this.masterInstanceType));
        retval.append("      ").append(XMLHandler.addTagValue((String)"slave_instance_type", (String)this.slaveInstanceType));
        retval.append("      ").append(XMLHandler.addTagValue((String)"command_line_args", (String)this.cmdLineArgs));
        retval.append("      ").append(XMLHandler.addTagValue((String)"blocking", (boolean)this.blocking));
        retval.append("      ").append(XMLHandler.addTagValue((String)"logging_interval", (String)this.loggingInterval));
        retval.append("      ").append(XMLHandler.addTagValue((String)"hadoop_job_name", (String)this.hadoopJobName));
        return retval.toString();
    }

    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        if (rep == null) {
            throw new KettleException("Unable to save to a repository. The repository is null.");
        }
        super.loadRep(rep, id_jobentry, databases, slaveServers);
        this.setHadoopJobName(rep.getJobEntryAttributeString(id_jobentry, "hadoop_job_name"));
        this.setHadoopJobFlowId(rep.getJobEntryAttributeString(id_jobentry, "hadoop_job_flow_id"));
        this.setJarUrl(rep.getJobEntryAttributeString(id_jobentry, "jar_url"));
        this.setAccessKey(Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "access_key")));
        this.setSecretKey(Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "secret_key")));
        this.setStagingDir(rep.getJobEntryAttributeString(id_jobentry, "staging_dir"));
        this.setNumInstances(rep.getJobEntryAttributeString(id_jobentry, "num_instances"));
        this.setMasterInstanceType(rep.getJobEntryAttributeString(id_jobentry, "master_instance_type"));
        this.setSlaveInstanceType(rep.getJobEntryAttributeString(id_jobentry, "slave_instance_type"));
        this.setCmdLineArgs(rep.getJobEntryAttributeString(id_jobentry, "command_line_args"));
        this.setBlocking(rep.getJobEntryAttributeBoolean(id_jobentry, "blocking"));
        this.setLoggingInterval(rep.getJobEntryAttributeString(id_jobentry, "logging_interval"));
    }

    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        if (rep == null) {
            throw new KettleException("Unable to save to a repository. The repository is null.");
        }
        super.saveRep(rep, id_job);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "hadoop_job_name", this.hadoopJobName);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "hadoop_job_flow_id", this.hadoopJobFlowId);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "jar_url", this.jarUrl);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "secret_key", Encr.encryptPasswordIfNotUsingVariables((String)this.secretKey));
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "access_key", Encr.encryptPasswordIfNotUsingVariables((String)this.accessKey));
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "staging_dir", this.stagingDir);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "num_instances", this.numInstances);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "master_instance_type", this.masterInstanceType);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "slave_instance_type", this.slaveInstanceType);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "command_line_args", this.cmdLineArgs);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "blocking", this.blocking);
        rep.saveJobEntryAttribute(id_job, this.getObjectId(), "logging_interval", this.loggingInterval);
    }

    public String buildFilename(String filename) {
        filename = this.environmentSubstitute(filename);
        return filename;
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return true;
    }

    public String getDialogClassName() {
        String className = this.getClass().getCanonicalName();
        className = className.replaceFirst("\\.job\\.", ".ui.");
        className = className + "Dialog";
        return className;
    }
}

