/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.sql.Driver;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.Hive2DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.plugins.DatabaseMetaPlugin;
import org.pentaho.di.core.row.ValueMetaInterface;

@DatabaseMetaPlugin(type="IMPALA", typeDescription="Impala")
public class ImpalaDatabaseMeta
extends Hive2DatabaseMeta
implements DatabaseInterface {
    protected static final String JAR_FILE = "hive-jdbc-cdh4.2.0-release-pentaho.jar";
    protected static final String DRIVER_CLASS_NAME = "org.apache.hive.jdbc.HiveDriver";
    protected static final int DEFAULT_PORT = 21050;
    protected Integer driverMajorVersion;
    protected Integer driverMinorVersion;

    public ImpalaDatabaseMeta() throws Throwable {
    }

    ImpalaDatabaseMeta(int majorVersion, int minorVersion) throws Throwable {
        this.driverMajorVersion = majorVersion;
        this.driverMinorVersion = minorVersion;
    }

    @Override
    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    @Override
    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    @Override
    public String getDriverClass() {
        return DRIVER_CLASS_NAME;
    }

    @Override
    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean useAutoinc, boolean addFieldname, boolean addCr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 4: {
                retval = retval + "BOOLEAN";
                break;
            }
            case 3: {
                retval = retval + "STRING";
                break;
            }
            case 2: {
                retval = retval + "STRING";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (precision == 0) {
                    if (length > 9) {
                        if (length < 19) {
                            retval = retval + "BIGINT";
                            break;
                        }
                        retval = retval + "FLOAT";
                        break;
                    }
                    retval = retval + "INT";
                    break;
                }
                retval = length > 15 ? retval + "FLOAT" : retval + "DOUBLE";
            }
        }
        return retval;
    }

    @Override
    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " MODIFY " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) throws KettleDatabaseException {
        if (Const.isEmpty((String)port)) {
            Integer.toString(this.getDefaultDatabasePort());
        }
        return "jdbc:hive2://" + hostname + ":" + port + "/" + databaseName + ";auth=noSasl";
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{JAR_FILE};
    }

    @Override
    public String getSelectCountStatement(String tableName) {
        return "select count(1) from " + tableName;
    }

    @Override
    public String generateColumnAlias(int columnIndex, String suggestedName) {
        if (this.isDriverVersion(0, 6)) {
            return suggestedName;
        }
        return "_col" + String.valueOf(columnIndex);
    }

    @Override
    protected synchronized void initDriverInfo() {
        Integer majorVersion = 0;
        Integer minorVersion = 0;
        try {
            Class<?> driverClass = Class.forName(DRIVER_CLASS_NAME);
            if (driverClass != null) {
                Driver driver = (Driver)driverClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                majorVersion = driver.getMajorVersion();
                minorVersion = driver.getMinorVersion();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.driverMajorVersion = majorVersion;
        this.driverMinorVersion = minorVersion;
    }

    @Override
    protected boolean isDriverVersion(int majorVersion, int minorVersion) {
        if (this.driverMajorVersion == null) {
            this.initDriverInfo();
        }
        if (majorVersion < this.driverMajorVersion) {
            return true;
        }
        return majorVersion == this.driverMajorVersion && minorVersion <= this.driverMinorVersion;
    }

    @Override
    public String getStartQuote() {
        return "";
    }

    @Override
    public String getEndQuote() {
        return "";
    }

    public int getDefaultDatabasePort() {
        return 21050;
    }

    @Override
    public String[] getTableTypes() {
        return null;
    }

    @Override
    public String[] getViewTypes() {
        return new String[]{"VIEW", "VIRTUAL_VIEW"};
    }
}

