/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.job.BlockableJobConfig;
import org.pentaho.di.job.JobEntrySerializationHelper;
import org.pentaho.di.job.JobEntryUtils;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

public abstract class AbstractJobEntry<T extends BlockableJobConfig>
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    protected T jobConfig = this.createJobConfig();

    protected AbstractJobEntry() {
    }

    public T getJobConfig() {
        ((BlockableJobConfig)this.jobConfig).setJobEntryName(this.getName());
        return this.jobConfig;
    }

    public void setJobConfig(T jobConfig) {
        this.jobConfig = jobConfig;
        this.setName(((BlockableJobConfig)jobConfig).getJobEntryName());
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return true;
    }

    public String getXML() {
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append(super.getXML());
        JobEntrySerializationHelper.write(this.getJobConfig(), 1, buffer);
        return buffer.toString();
    }

    public void loadXML(Node node, List<DatabaseMeta> databaseMetas, List<SlaveServer> slaveServers, Repository repository) throws KettleXMLException {
        super.loadXML(node, databaseMetas, slaveServers);
        T loaded = this.createJobConfig();
        JobEntrySerializationHelper.read(loaded, node);
        this.setJobConfig(loaded);
    }

    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        super.loadRep(rep, id_jobentry, databases, slaveServers);
        T loaded = this.createJobConfig();
        JobEntrySerializationHelper.loadRep(loaded, rep, id_jobentry, databases, slaveServers);
        this.setJobConfig(loaded);
    }

    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        JobEntrySerializationHelper.saveRep(this.getJobConfig(), rep, id_job, this.getObjectId());
    }

    public Result execute(Result result, int i) throws KettleException {
        if (!this.isValid(this.getJobConfig())) {
            this.setJobResultFailed(result);
            return result;
        }
        final Result jobResult = result;
        result.setResult(true);
        Thread t = new Thread(this.getExecutionRunnable(jobResult));
        t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                AbstractJobEntry.this.handleUncaughtThreadException(t, e, jobResult);
            }
        });
        t.start();
        if (JobEntryUtils.asBoolean(((BlockableJobConfig)this.getJobConfig()).getBlockingExecution(), this.variables)) {
            while (!this.parentJob.isStopped() && t.isAlive()) {
                try {
                    t.join(JobEntryUtils.asLong(((BlockableJobConfig)this.getJobConfig()).getBlockingPollingInterval(), this.variables));
                }
                catch (InterruptedException ex) {
                    // empty catch block
                    break;
                }
            }
            if (t.isAlive()) {
                t.interrupt();
                this.setJobResultFailed(result);
            }
            try {
                t.join(10000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return result;
    }

    public void setJobResultFailed(Result jobResult) {
        jobResult.setNrErrors(1L);
        jobResult.setResult(false);
    }

    public boolean isValid(T config) {
        List<String> warnings = this.getValidationWarnings(config);
        for (String warning : warnings) {
            this.logError(warning);
        }
        return warnings.isEmpty();
    }

    public VariableSpace getVariableSpace() {
        return this.variables;
    }

    protected abstract T createJobConfig();

    public abstract List<String> getValidationWarnings(T var1);

    protected abstract Runnable getExecutionRunnable(Result var1) throws KettleException;

    protected abstract void handleUncaughtThreadException(Thread var1, Throwable var2, Result var3);
}

