/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metastore.stores.memory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pentaho.metastore.api.IMetaStoreAttribute;

public class MemoryMetaStoreAttribute
implements IMetaStoreAttribute {
    protected String id;
    protected Object value;
    protected Map<String, IMetaStoreAttribute> children;

    public MemoryMetaStoreAttribute() {
        this(null, null);
    }

    public MemoryMetaStoreAttribute(String id, Object value) {
        this.id = id;
        this.value = value;
        this.children = new HashMap<String, IMetaStoreAttribute>();
    }

    public MemoryMetaStoreAttribute(IMetaStoreAttribute attribute) {
        this(attribute.getId(), attribute.getValue());
        for (IMetaStoreAttribute childElement : attribute.getChildren()) {
            this.addChild(new MemoryMetaStoreAttribute(childElement));
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public List<IMetaStoreAttribute> getChildren() {
        return new ArrayList<IMetaStoreAttribute>(this.children.values());
    }

    public void setChildren(List<IMetaStoreAttribute> children) {
        this.children.clear();
        for (IMetaStoreAttribute child : children) {
            this.children.put(child.getId(), child);
        }
    }

    @Override
    public void addChild(IMetaStoreAttribute attribute) {
        this.children.put(attribute.getId(), attribute);
    }

    @Override
    public void deleteChild(String attributeId) {
        Iterator<IMetaStoreAttribute> iterator = this.children.values().iterator();
        while (iterator.hasNext()) {
            IMetaStoreAttribute next = iterator.next();
            if (!next.getId().equals(attributeId)) continue;
            iterator.remove();
            break;
        }
    }

    @Override
    public void clearChildren() {
        this.children.clear();
    }

    @Override
    public IMetaStoreAttribute getChild(String id) {
        return this.children.get(id);
    }
}

