/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metastore.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.IMetaStoreAttribute;
import org.pentaho.metastore.api.IMetaStoreElement;
import org.pentaho.metastore.api.IMetaStoreElementType;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

public class MetaStoreUtil {
    public static void verifyNamespaceCreated(IMetaStore metaStore, String namespace) throws MetaStoreException {
        if (!metaStore.namespaceExists(namespace)) {
            metaStore.createNamespace(namespace);
        }
    }

    public static String getChildString(IMetaStoreAttribute attribute, String id) {
        IMetaStoreAttribute child = attribute.getChild(id);
        if (child == null) {
            return null;
        }
        return MetaStoreUtil.getAttributeString(child);
    }

    public static String getAttributeString(IMetaStoreAttribute attribute) {
        if (attribute.getValue() == null) {
            return null;
        }
        return attribute.getValue().toString();
    }

    public String[] getElementNames(String namespace, IMetaStore metaStore, IMetaStoreElementType elementType) throws MetaStoreException {
        ArrayList<String> names = new ArrayList<String>();
        List<IMetaStoreElement> elements = metaStore.getElements(namespace, elementType);
        for (IMetaStoreElement element : elements) {
            names.add(element.getName());
        }
        Collections.sort(names);
        return names.toArray(new String[names.size()]);
    }
}

