/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.win32.LITEM;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMLINK;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Link
extends Control {
    String text;
    TextLayout layout;
    Color linkColor;
    Color disabledColor;
    Point[] offsets;
    Point selection;
    String[] ids;
    int[] mnemonics;
    int focusIndex;
    int mouseDownIndex;
    int font;
    static final RGB LINK_FOREGROUND = new RGB(0, 51, 153);
    static final int LinkProc;
    static final TCHAR LinkClass;

    static {
        LinkClass = new TCHAR(0, "SysLink", true);
        if (OS.COMCTL32_MAJOR >= 6) {
            WNDCLASS wNDCLASS = new WNDCLASS();
            OS.GetClassInfo(0, LinkClass, wNDCLASS);
            LinkProc = wNDCLASS.lpfnWndProc;
            int n = OS.GetModuleHandle(null);
            int n2 = OS.GetProcessHeap();
            wNDCLASS.hInstance = n;
            wNDCLASS.style &= 0xFFFFBFFF;
            wNDCLASS.style |= 8;
            int n3 = LinkClass.length() * TCHAR.sizeof;
            int n4 = OS.HeapAlloc(n2, 8, n3);
            OS.MoveMemory(n4, LinkClass, n3);
            wNDCLASS.lpszClassName = n4;
            OS.RegisterClass(wNDCLASS);
            OS.HeapFree(n2, 0, n4);
        } else {
            LinkProc = 0;
        }
    }

    public Link(Composite composite, int n) {
        super(composite, n);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            return 0;
        }
        if (LinkProc != 0) {
            switch (n2) {
                case 15: {
                    if (n3 == 0) break;
                    OS.SendMessage(n, 792, n3, 0);
                    return 0;
                }
            }
            return OS.CallWindowProc(LinkProc, n, n2, n3, n4);
        }
        return OS.DefWindowProc(n, n2, n3, n4);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            n5 = OS.GetDC(this.handle);
            int n6 = OS.SendMessage(this.handle, 49, 0, 0);
            int n7 = OS.SelectObject(n5, n6);
            if (this.text.length() > 0) {
                TCHAR tCHAR = new TCHAR(this.getCodePage(), this.parse(this.text), false);
                RECT rECT = new RECT();
                int n8 = 3072;
                if (n != -1) {
                    n8 |= 0x10;
                    rECT.right = n;
                }
                OS.DrawText(n5, tCHAR, tCHAR.length(), rECT, n8);
                n4 = rECT.right - rECT.left;
                n3 = rECT.bottom;
            } else {
                TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                OS.GetTextMetrics(n5, tEXTMETRIC);
                n4 = 0;
                n3 = tEXTMETRIC.tmHeight;
            }
            if (n6 != 0) {
                OS.SelectObject(n5, n7);
            }
            OS.ReleaseDC(this.handle, n5);
        } else {
            n5 = this.layout.getWidth();
            if (n == 0) {
                this.layout.setWidth(1);
                Rectangle rectangle = this.layout.getBounds();
                n4 = 0;
                n3 = rectangle.height;
            } else {
                this.layout.setWidth(n);
                Rectangle rectangle = this.layout.getBounds();
                n4 = rectangle.width;
                n3 = rectangle.height;
            }
            this.layout.setWidth(n5);
        }
        if (n != -1) {
            n4 = n;
        }
        if (n2 != -1) {
            n3 = n2;
        }
        n5 = this.getBorderWidth();
        return new Point(n4 += n5 * 2, n3 += n5 * 2);
    }

    void createHandle() {
        super.createHandle();
        this.state |= 0x100;
        if (OS.COMCTL32_MAJOR < 6) {
            this.layout = new TextLayout(this.display);
            this.linkColor = !OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) ? Color.win32_new(this.display, OS.GetSysColor(OS.COLOR_HOTLIGHT)) : new Color(this.display, LINK_FOREGROUND);
            this.disabledColor = Color.win32_new(this.display, OS.GetSysColor(OS.COLOR_GRAYTEXT));
            this.offsets = new Point[0];
            this.ids = new String[0];
            this.mnemonics = new int[0];
            this.selection = new Point(-1, -1);
            this.mouseDownIndex = -1;
            this.focusIndex = -1;
        }
    }

    void createWidget() {
        super.createWidget();
        this.text = "";
        if (OS.COMCTL32_MAJOR < 6) {
            if ((this.style & 0x8000000) != 0) {
                this.layout.setOrientation(0x4000000);
            }
            this.initAccessible();
        }
    }

    void drawWidget(GC gC, RECT rECT) {
        Rectangle[] rectangleArray;
        this.drawBackground(gC.handle, rECT);
        int n = this.selection.x;
        int n2 = this.selection.y;
        if (n > n2) {
            n = this.selection.y;
            n2 = this.selection.x;
        }
        n2 = -1;
        n = -1;
        if (!OS.IsWindowEnabled(this.handle)) {
            gC.setForeground(this.disabledColor);
        }
        this.layout.draw(gC, 0, 0, n, n2, null, null);
        if (this.hasFocus() && this.focusIndex != -1) {
            rectangleArray = this.getRectangles(this.focusIndex);
            int n3 = 0;
            while (n3 < rectangleArray.length) {
                Rectangle rectangle = rectangleArray[n3];
                gC.drawFocus(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                ++n3;
            }
        }
        if (this.hooks(9) || this.filters(9)) {
            rectangleArray = new Event();
            rectangleArray.gc = gC;
            rectangleArray.x = rECT.left;
            rectangleArray.y = rECT.top;
            rectangleArray.width = rECT.right - rECT.left;
            rectangleArray.height = rECT.bottom - rECT.top;
            this.sendEvent(9, (Event)rectangleArray);
            rectangleArray.gc = null;
        }
    }

    void enableWidget(boolean bl) {
        if (OS.COMCTL32_MAJOR >= 6) {
            LITEM lITEM = new LITEM();
            lITEM.mask = 3;
            lITEM.stateMask = 2;
            lITEM.state = bl ? 2 : 0;
            while (OS.SendMessage(this.handle, 1794, 0, lITEM) != 0) {
                ++lITEM.iLink;
            }
        } else {
            TextStyle textStyle = new TextStyle(null, bl ? this.linkColor : this.disabledColor, null);
            textStyle.underline = true;
            int n = 0;
            while (n < this.offsets.length) {
                Point point = this.offsets[n];
                this.layout.setStyle(textStyle, point.x, point.y);
                ++n;
            }
            this.redraw();
        }
        super.enableWidget(bl);
    }

    void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = Link.this.parse(Link.this.text);
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.childID = -1;
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = Link.this.display.map((Control)Link.this.getParent(), null, Link.this.getBounds());
                accessibleControlEvent.x = rectangle.x;
                accessibleControlEvent.y = rectangle.y;
                accessibleControlEvent.width = rectangle.width;
                accessibleControlEvent.height = rectangle.height;
            }

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 30;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0x100000;
                if (Link.this.hasFocus()) {
                    accessibleControlEvent.detail |= 4;
                }
            }

            public void getDefaultAction(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.result = SWT.getMessage("SWT_Press");
            }

            public void getSelection(AccessibleControlEvent accessibleControlEvent) {
                if (Link.this.hasFocus()) {
                    accessibleControlEvent.childID = -1;
                }
            }

            public void getFocus(AccessibleControlEvent accessibleControlEvent) {
                if (Link.this.hasFocus()) {
                    accessibleControlEvent.childID = -1;
                }
            }
        });
    }

    String getNameText() {
        return this.getText();
    }

    Rectangle[] getRectangles(int n) {
        int n2 = this.layout.getLineCount();
        Rectangle[] rectangleArray = new Rectangle[n2];
        int[] nArray = this.layout.getLineOffsets();
        Point point = this.offsets[n];
        int n3 = 1;
        while (point.x > nArray[n3]) {
            ++n3;
        }
        int n4 = 1;
        while (point.y > nArray[n4]) {
            ++n4;
        }
        int n5 = 0;
        if (n3 == n4) {
            rectangleArray[n5++] = this.layout.getBounds(point.x, point.y);
        } else {
            rectangleArray[n5++] = this.layout.getBounds(point.x, nArray[n3] - 1);
            rectangleArray[n5++] = this.layout.getBounds(nArray[n4 - 1], point.y);
            if (n4 - n3 > 1) {
                int n6 = n3;
                while (n6 < n4 - 1) {
                    rectangleArray[n5++] = this.layout.getLineBounds(n6);
                    ++n6;
                }
            }
        }
        if (rectangleArray.length != n5) {
            Rectangle[] rectangleArray2 = new Rectangle[n5];
            System.arraycopy(rectangleArray, 0, rectangleArray2, 0, n5);
            rectangleArray = rectangleArray2;
        }
        return rectangleArray;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    boolean mnemonicHit(char c) {
        if (this.mnemonics != null) {
            char c2 = Character.toUpperCase(c);
            String string = this.parse(this.text);
            int n = 0;
            while (n < this.mnemonics.length - 1) {
                char c3;
                if (this.mnemonics[n] != -1 && c2 == Character.toUpperCase(c3 = string.charAt(this.mnemonics[n]))) {
                    if (!this.setFocus()) {
                        return false;
                    }
                    if (OS.COMCTL32_MAJOR >= 6) {
                        int n2 = OS.GetWindowLong(this.handle, -16);
                        LITEM lITEM = new LITEM();
                        lITEM.mask = 3;
                        lITEM.stateMask = 1;
                        while (lITEM.iLink < this.mnemonics.length) {
                            if (lITEM.iLink != n) {
                                OS.SendMessage(this.handle, 1794, 0, lITEM);
                            }
                            ++lITEM.iLink;
                        }
                        lITEM.iLink = n;
                        lITEM.state = 1;
                        OS.SendMessage(this.handle, 1794, 0, lITEM);
                        OS.SetWindowLong(this.handle, -16, n2);
                    } else {
                        this.focusIndex = n;
                        this.redraw();
                    }
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    boolean mnemonicMatch(char c) {
        if (this.mnemonics != null) {
            char c2 = Character.toUpperCase(c);
            String string = this.parse(this.text);
            int n = 0;
            while (n < this.mnemonics.length - 1) {
                char c3;
                if (this.mnemonics[n] != -1 && c2 == Character.toUpperCase(c3 = string.charAt(this.mnemonics[n]))) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    String parse(String string) {
        int n;
        int n2;
        int n3 = string.length();
        this.offsets = new Point[n3 / 4];
        this.ids = new String[n3 / 4];
        this.mnemonics = new int[n3 / 4 + 1];
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[n3];
        string.getChars(0, string.length(), cArray, 0);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n4 < n3) {
            n2 = Character.toLowerCase(cArray[n4]);
            block0 : switch (n5) {
                case 0: {
                    if (n2 != 60) break;
                    n8 = n4;
                    ++n5;
                    break;
                }
                case 1: {
                    if (n2 != 97) break;
                    ++n5;
                    break;
                }
                case 2: {
                    switch (n2) {
                        case 104: {
                            n5 = 7;
                            break block0;
                        }
                        case 62: {
                            n9 = n4 + 1;
                            ++n5;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace((char)n2)) break;
                    n5 = 13;
                    break;
                }
                case 3: {
                    if (n2 != 60) break;
                    n10 = n4;
                    ++n5;
                    break;
                }
                case 4: {
                    n5 = n2 == 47 ? n5 + 1 : 3;
                    break;
                }
                case 5: {
                    n5 = n2 == 97 ? n5 + 1 : 3;
                    break;
                }
                case 6: {
                    if (n2 == 62) {
                        this.mnemonics[n6] = this.parseMnemonics(cArray, n7, n8, stringBuffer);
                        n = stringBuffer.length();
                        this.parseMnemonics(cArray, n9, n10, stringBuffer);
                        this.offsets[n6] = new Point(n, stringBuffer.length() - 1);
                        if (this.ids[n6] == null) {
                            this.ids[n6] = new String(cArray, n9, n10 - n9);
                        }
                        ++n6;
                        n10 = n11 = n4 + 1;
                        n9 = n11;
                        n8 = n11;
                        n7 = n11;
                        n5 = 0;
                        break;
                    }
                    n5 = 3;
                    break;
                }
                case 7: {
                    n5 = n2 == 114 ? n5 + 1 : 0;
                    break;
                }
                case 8: {
                    n5 = n2 == 101 ? n5 + 1 : 0;
                    break;
                }
                case 9: {
                    n5 = n2 == 102 ? n5 + 1 : 0;
                    break;
                }
                case 10: {
                    n5 = n2 == 61 ? n5 + 1 : 0;
                    break;
                }
                case 11: {
                    if (n2 == 34) {
                        ++n5;
                        n11 = n4 + 1;
                        break;
                    }
                    n5 = 0;
                    break;
                }
                case 12: {
                    if (n2 != 34) break;
                    this.ids[n6] = new String(cArray, n11, n4 - n11);
                    n5 = 2;
                    break;
                }
                case 13: {
                    if (Character.isWhitespace((char)n2)) {
                        n5 = 0;
                        break;
                    }
                    if (n2 != 61) break;
                    ++n5;
                    break;
                }
                case 14: {
                    n5 = n2 == 34 ? n5 + 1 : 0;
                    break;
                }
                case 15: {
                    if (n2 != 34) break;
                    n5 = 2;
                    break;
                }
                default: {
                    n5 = 0;
                }
            }
            ++n4;
        }
        if (n7 < n3) {
            n2 = this.parseMnemonics(cArray, n7, n8, stringBuffer);
            n = this.parseMnemonics(cArray, Math.max(n8, n9), n3, stringBuffer);
            if (n == -1) {
                n = n2;
            }
            this.mnemonics[n6] = n;
        } else {
            this.mnemonics[n6] = -1;
        }
        if (this.offsets.length != n6) {
            Point[] pointArray = new Point[n6];
            System.arraycopy(this.offsets, 0, pointArray, 0, n6);
            this.offsets = pointArray;
            String[] stringArray = new String[n6];
            System.arraycopy(this.ids, 0, stringArray, 0, n6);
            this.ids = stringArray;
            int[] nArray = new int[n6 + 1];
            System.arraycopy(this.mnemonics, 0, nArray, 0, n6 + 1);
            this.mnemonics = nArray;
        }
        return stringBuffer.toString();
    }

    int parseMnemonics(char[] cArray, int n, int n2, StringBuffer stringBuffer) {
        int n3 = -1;
        int n4 = n;
        while (n4 < n2) {
            if (cArray[n4] == '&') {
                if (n4 + 1 < n2 && cArray[n4 + 1] == '&') {
                    stringBuffer.append(cArray[n4]);
                    ++n4;
                } else {
                    n3 = stringBuffer.length();
                }
            } else {
                stringBuffer.append(cArray[n4]);
            }
            ++n4;
        }
        return n3;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.layout != null) {
            this.layout.dispose();
        }
        this.layout = null;
        if (this.linkColor != null) {
            this.linkColor.dispose();
        }
        this.linkColor = null;
        this.disabledColor = null;
        this.offsets = null;
        this.ids = null;
        this.mnemonics = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        if (OS.COMCTL32_MAJOR >= 6) {
            boolean bl = OS.IsWindowEnabled(this.handle);
            if (string.length() == 0) {
                string = " ";
            }
            TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
            OS.SetWindowText(this.handle, tCHAR);
            this.parse(this.text);
            this.enableWidget(bl);
        } else {
            this.layout.setText(this.parse(this.text));
            this.focusIndex = this.offsets.length > 0 ? 0 : -1;
            this.selection.y = -1;
            this.selection.x = -1;
            int n = OS.GetWindowLong(this.handle, -16);
            n = this.offsets.length > 0 ? (n |= 0x10000) : (n &= 0xFFFEFFFF);
            OS.SetWindowLong(this.handle, -16, n);
            boolean bl = OS.IsWindowEnabled(this.handle);
            TextStyle textStyle = new TextStyle(null, bl ? this.linkColor : this.disabledColor, null);
            textStyle.underline = true;
            int n2 = 0;
            while (n2 < this.offsets.length) {
                Point point = this.offsets[n2];
                this.layout.setStyle(textStyle, point.x, point.y);
                ++n2;
            }
            TextStyle textStyle2 = new TextStyle(null, null, null);
            textStyle2.underline = true;
            int n3 = 0;
            while (n3 < this.mnemonics.length) {
                int n4 = this.mnemonics[n3];
                if (n4 != -1) {
                    this.layout.setStyle(textStyle2, n4, n4);
                }
                ++n3;
            }
            this.redraw();
        }
    }

    int widgetStyle() {
        int n = super.widgetStyle();
        return n | 0x10000;
    }

    TCHAR windowClass() {
        return OS.COMCTL32_MAJOR >= 6 ? LinkClass : this.display.windowClass;
    }

    int windowProc() {
        return LinkProc != 0 ? LinkProc : this.display.windowProc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    LRESULT WM_CHAR(int n, int n2) {
        LRESULT lRESULT = super.WM_CHAR(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR < 6) {
            if (this.focusIndex == -1) {
                return lRESULT;
            }
            switch (n) {
                case 13: 
                case 32: {
                    Event event = new Event();
                    event.text = this.ids[this.focusIndex];
                    this.sendSelectionEvent(13, event, true);
                    return lRESULT;
                }
                case 9: {
                    boolean bl;
                    boolean bl2 = bl = OS.GetKeyState(16) >= 0;
                    if (bl) {
                        if (this.focusIndex >= this.offsets.length - 1) return lRESULT;
                        ++this.focusIndex;
                        this.redraw();
                        return lRESULT;
                    }
                    if (this.focusIndex <= 0) return lRESULT;
                    --this.focusIndex;
                    this.redraw();
                }
                default: {
                    return lRESULT;
                }
            }
        } else {
            switch (n) {
                case 9: 
                case 13: 
                case 32: {
                    int n3 = this.callWindowProc(this.handle, 256, n, n2);
                    return new LRESULT(n3);
                }
            }
        }
        return lRESULT;
    }

    LRESULT WM_GETDLGCODE(int n, int n2) {
        boolean bl;
        int n3;
        int n4;
        LRESULT lRESULT = super.WM_GETDLGCODE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n5 = 0;
        if (OS.COMCTL32_MAJOR >= 6) {
            LITEM lITEM = new LITEM();
            lITEM.mask = 3;
            lITEM.stateMask = 1;
            n4 = 0;
            while (OS.SendMessage(this.handle, 1795, 0, lITEM) != 0) {
                if ((lITEM.state & 1) != 0) {
                    n4 = lITEM.iLink;
                }
                ++lITEM.iLink;
            }
            n3 = lITEM.iLink;
            n5 = this.callWindowProc(this.handle, 135, n, n2);
        } else {
            n4 = this.focusIndex;
            n3 = this.offsets.length;
        }
        if (n3 == 0) {
            return new LRESULT(n5 | 0x100);
        }
        boolean bl2 = bl = OS.GetKeyState(16) >= 0;
        if (bl && n4 < n3 - 1) {
            return new LRESULT(n5 | 2);
        }
        if (!bl && n4 > 0) {
            return new LRESULT(n5 | 2);
        }
        return lRESULT;
    }

    LRESULT WM_GETFONT(int n, int n2) {
        LRESULT lRESULT = super.WM_GETFONT(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n3 = this.callWindowProc(this.handle, 49, n, n2);
        if (n3 != 0) {
            return new LRESULT(n3);
        }
        if (this.font == 0) {
            this.font = this.defaultFont();
        }
        return new LRESULT(this.font);
    }

    LRESULT WM_KEYDOWN(int n, int n2) {
        LRESULT lRESULT = super.WM_KEYDOWN(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            switch (n) {
                case 9: 
                case 13: 
                case 32: {
                    return LRESULT.ZERO;
                }
            }
        }
        return lRESULT;
    }

    LRESULT WM_KILLFOCUS(int n, int n2) {
        LRESULT lRESULT = super.WM_KILLFOCUS(n, n2);
        if (OS.COMCTL32_MAJOR < 6) {
            this.redraw();
        }
        return lRESULT;
    }

    LRESULT WM_LBUTTONDOWN(int n, int n2) {
        LRESULT lRESULT = super.WM_LBUTTONDOWN(n, n2);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR < 6) {
            if (this.focusIndex != -1) {
                this.setFocus();
            }
            int n3 = OS.GET_X_LPARAM(n2);
            int n4 = OS.GET_Y_LPARAM(n2);
            int n5 = this.layout.getOffset(n3, n4, null);
            int n6 = this.selection.x;
            int n7 = this.selection.y;
            this.selection.x = n5;
            this.selection.y = -1;
            if (n6 != -1 && n7 != -1) {
                if (n6 > n7) {
                    int n8 = n6;
                    n6 = n7;
                    n7 = n8;
                }
                Rectangle rectangle = this.layout.getBounds(n6, n7);
                this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
            }
            int n9 = 0;
            while (n9 < this.offsets.length) {
                Rectangle[] rectangleArray = this.getRectangles(n9);
                int n10 = 0;
                while (n10 < rectangleArray.length) {
                    Rectangle rectangle = rectangleArray[n10];
                    if (rectangle.contains(n3, n4)) {
                        if (n9 != this.focusIndex) {
                            this.redraw();
                        }
                        this.focusIndex = this.mouseDownIndex = n9;
                        return lRESULT;
                    }
                    ++n10;
                }
                ++n9;
            }
        }
        return lRESULT;
    }

    LRESULT WM_LBUTTONUP(int n, int n2) {
        LRESULT lRESULT = super.WM_LBUTTONUP(n, n2);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR < 6) {
            if (this.mouseDownIndex == -1) {
                return lRESULT;
            }
            int n3 = OS.GET_X_LPARAM(n2);
            int n4 = OS.GET_Y_LPARAM(n2);
            Rectangle[] rectangleArray = this.getRectangles(this.mouseDownIndex);
            int n5 = 0;
            while (n5 < rectangleArray.length) {
                Rectangle rectangle = rectangleArray[n5];
                if (rectangle.contains(n3, n4)) {
                    Event event = new Event();
                    event.text = this.ids[this.mouseDownIndex];
                    this.sendSelectionEvent(13, event, true);
                    break;
                }
                ++n5;
            }
        }
        this.mouseDownIndex = -1;
        return lRESULT;
    }

    LRESULT WM_NCHITTEST(int n, int n2) {
        LRESULT lRESULT = super.WM_NCHITTEST(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            return new LRESULT(1);
        }
        return lRESULT;
    }

    LRESULT WM_MOUSEMOVE(int n, int n2) {
        LRESULT lRESULT = super.WM_MOUSEMOVE(n, n2);
        if (OS.COMCTL32_MAJOR < 6) {
            int n3 = OS.GET_X_LPARAM(n2);
            int n4 = OS.GET_Y_LPARAM(n2);
            if (OS.GetKeyState(1) < 0) {
                int n5 = this.selection.y;
                this.selection.y = this.layout.getOffset(n3, n4, null);
                if (this.selection.y != n5) {
                    int n6 = this.selection.y;
                    if (n5 > n6) {
                        int n7 = n5;
                        n5 = n6;
                        n6 = n7;
                    }
                    Rectangle rectangle = this.layout.getBounds(n5, n6);
                    this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
                }
            } else {
                int n8 = 0;
                while (n8 < this.offsets.length) {
                    Rectangle[] rectangleArray = this.getRectangles(n8);
                    int n9 = 0;
                    while (n9 < rectangleArray.length) {
                        Rectangle rectangle = rectangleArray[n9];
                        if (rectangle.contains(n3, n4)) {
                            this.setCursor(this.display.getSystemCursor(21));
                            return lRESULT;
                        }
                        ++n9;
                    }
                    ++n8;
                }
                this.setCursor(null);
            }
        }
        return lRESULT;
    }

    LRESULT WM_PAINT(int n, int n2) {
        if (OS.COMCTL32_MAJOR >= 6) {
            return super.WM_PAINT(n, n2);
        }
        PAINTSTRUCT pAINTSTRUCT = new PAINTSTRUCT();
        GCData gCData = new GCData();
        gCData.ps = pAINTSTRUCT;
        gCData.hwnd = this.handle;
        GC gC = this.new_GC(gCData);
        if (gC != null) {
            int n3 = pAINTSTRUCT.right - pAINTSTRUCT.left;
            int n4 = pAINTSTRUCT.bottom - pAINTSTRUCT.top;
            if (n3 != 0 && n4 != 0) {
                RECT rECT = new RECT();
                OS.SetRect(rECT, pAINTSTRUCT.left, pAINTSTRUCT.top, pAINTSTRUCT.right, pAINTSTRUCT.bottom);
                this.drawWidget(gC, rECT);
            }
            gC.dispose();
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_PRINTCLIENT(int n, int n2) {
        LRESULT lRESULT = super.WM_PRINTCLIENT(n, n2);
        if (OS.COMCTL32_MAJOR < 6) {
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            GCData gCData = new GCData();
            gCData.device = this.display;
            gCData.foreground = this.getForegroundPixel();
            GC gC = GC.win32_new(n, gCData);
            this.drawWidget(gC, rECT);
            gC.dispose();
        }
        return lRESULT;
    }

    LRESULT WM_SETFOCUS(int n, int n2) {
        LRESULT lRESULT = super.WM_SETFOCUS(n, n2);
        if (OS.COMCTL32_MAJOR < 6) {
            this.redraw();
        }
        return lRESULT;
    }

    LRESULT WM_SETFONT(int n, int n2) {
        if (OS.COMCTL32_MAJOR < 6) {
            this.layout.setFont(Font.win32_new(this.display, n));
        }
        if (n2 != 0) {
            OS.InvalidateRect(this.handle, null, true);
        }
        this.font = n;
        return super.WM_SETFONT(this.font, n2);
    }

    LRESULT WM_SIZE(int n, int n2) {
        LRESULT lRESULT = super.WM_SIZE(n, n2);
        if (OS.COMCTL32_MAJOR < 6) {
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            this.layout.setWidth(rECT.right > 0 ? rECT.right : -1);
            this.redraw();
        }
        return lRESULT;
    }

    LRESULT wmColorChild(int n, int n2) {
        LRESULT lRESULT = super.wmColorChild(n, n2);
        if (OS.COMCTL32_MAJOR >= 6 && !OS.IsWindowEnabled(this.handle)) {
            OS.SetTextColor(n, OS.GetSysColor(OS.COLOR_GRAYTEXT));
            if (lRESULT == null) {
                int n3 = this.getBackgroundPixel();
                OS.SetBkColor(n, n3);
                int n4 = this.findBrush(n3, 0);
                return new LRESULT(n4);
            }
        }
        return lRESULT;
    }

    LRESULT wmNotifyChild(NMHDR nMHDR, int n, int n2) {
        if (OS.COMCTL32_MAJOR >= 6) {
            switch (nMHDR.code) {
                case -4: 
                case -2: {
                    NMLINK nMLINK = new NMLINK();
                    OS.MoveMemory(nMLINK, n2, NMLINK.sizeof);
                    Event event = new Event();
                    event.text = this.ids[nMLINK.iLink];
                    this.sendSelectionEvent(13, event, true);
                }
            }
        }
        return super.wmNotifyChild(nMHDR, n, n2);
    }
}

