/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import java.text.NumberFormat;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.data.category.CategoryDataset;

public class LogCategoryItemLabelGenerator
extends StandardCategoryItemLabelGenerator {
    private static final long serialVersionUID = 1L;

    public LogCategoryItemLabelGenerator() {
        super("{2}", NumberFormat.getInstance());
    }

    public LogCategoryItemLabelGenerator(String labelFormat) {
        super(labelFormat, NumberFormat.getInstance());
    }

    protected Object[] createItemArray(CategoryDataset dataset, int row, int column) {
        Object[] objects = super.createItemArray(dataset, row, column);
        Number value = dataset.getValue(row, column);
        objects[2] = LogCategoryItemLabelGenerator.formatValue(value);
        return objects;
    }

    public static String formatValue(Number number) {
        if (number == null) {
            return null;
        }
        double rawValue = number.doubleValue();
        double value = Math.abs(rawValue);
        if (value < 1000.0) {
            return NumberFormat.getNumberInstance().format(rawValue);
        }
        if (value < 1000000.0) {
            return NumberFormat.getNumberInstance().format(rawValue / 1000.0) + "K";
        }
        if (value < 1.0E9) {
            return NumberFormat.getNumberInstance().format(rawValue / 1000000.0) + "M";
        }
        if (value < 1.0E9) {
            return NumberFormat.getNumberInstance().format(rawValue / 1000000.0) + "M";
        }
        if (value < 1.0E12) {
            return NumberFormat.getNumberInstance().format(rawValue / 1.0E9) + "B";
        }
        return NumberFormat.getNumberInstance().format(rawValue / 1.0E12) + "T";
    }
}

