/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.legacy.charts;

import java.util.Locale;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.SpiderWebPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.DefaultIntervalXYDataset;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.util.TableOrder;
import org.pentaho.plugin.jfreereport.reportcharts.AreaChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.BarChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.BarLineChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.BubbleChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.ExtendedXYLineChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.LineChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.MultiPieChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.PieChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.RadarChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.RingChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.ScatterPlotChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.WaterfallChartExpressions;
import org.pentaho.plugin.jfreereport.reportcharts.XYAreaChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.XYAreaLineChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.XYBarChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.XYLineChartExpression;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.filter.types.ContentFieldType;
import org.pentaho.reporting.engine.classic.core.filter.types.ElementTypeUtils;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;

public class LegacyChartType
extends ContentFieldType {
    private transient ElementMetaData elementType;

    public LegacyChartType() {
        super("legacy-chart");
    }

    public Object getDesignValue(ExpressionRuntime runtime, ReportElement element) {
        Expression theExpression = element.getAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value");
        return this.createChart(theExpression);
    }

    private XYZDataset createXYZDataset() {
        DefaultXYZDataset xyzDataset = new DefaultXYZDataset();
        double bs = 3.0;
        xyzDataset.addSeries((Comparable)((Object)"First"), (double[][])new double[][]{{1.0, 2.0, 3.0}, {2.0, 1.0, 3.0}, {0.30000000000000004, 0.6000000000000001, 0.30000000000000004}});
        xyzDataset.addSeries((Comparable)((Object)"Second"), (double[][])new double[][]{{1.0, 2.0, 3.0}, {3.0, 0.0, 1.0}, {0.6000000000000001, 0.30000000000000004, 0.44999999999999996}});
        return xyzDataset;
    }

    private PieDataset createPieDataset() {
        DefaultPieDataset dataset = new DefaultPieDataset();
        dataset.setValue((Comparable)((Object)"Part 1"), 23.0);
        dataset.setValue((Comparable)((Object)"Part 2"), 35.0);
        dataset.setValue((Comparable)((Object)"Part 3"), 42.0);
        return dataset;
    }

    private XYDataset createIntervalXYDataset() {
        DefaultIntervalXYDataset dataset = new DefaultIntervalXYDataset();
        dataset.addSeries((Comparable)((Object)"First"), (double[][])new double[][]{{1.0, 2.0, 3.0}, {3.0, 1.0, 2.0}, {1.0, 2.0, 1.0}, {4.0, 4.0, 4.0}, {3.0, 3.0, 3.0}, {4.0, 4.0, 4.0}});
        return dataset;
    }

    private CategoryDataset createDataset() {
        String series1 = "First";
        String series2 = "Second";
        String series3 = "Third";
        String category1 = "Category 1";
        String category2 = "Category 2";
        String category3 = "Category 3";
        String category4 = "Category 4";
        String category5 = "Category 5";
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(1.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 1"));
        dataset.addValue(5.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 2"));
        dataset.addValue(4.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 3"));
        dataset.addValue(8.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 4"));
        dataset.addValue(7.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 5"));
        dataset.addValue(3.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 1"));
        dataset.addValue(4.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 2"));
        dataset.addValue(3.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 3"));
        dataset.addValue(5.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 4"));
        dataset.addValue(4.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 5"));
        dataset.addValue(1.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 1"));
        dataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 2"));
        dataset.addValue(2.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 3"));
        dataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 4"));
        dataset.addValue(2.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 5"));
        return dataset;
    }

    public Object getValue(ExpressionRuntime runtime, ReportElement element) {
        Object filteredValue;
        if (runtime == null) {
            throw new NullPointerException("Runtime must never be null.");
        }
        if (element == null) {
            throw new NullPointerException("Element must never be null.");
        }
        Object value = ElementTypeUtils.queryStaticValue((ReportElement)element);
        if (value != null && (filteredValue = this.filter(runtime, element, value)) != null) {
            return filteredValue;
        }
        Object nullValue = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value");
        return this.filter(runtime, element, nullValue);
    }

    public void configureDesignTimeDefaults(ReportElement element, Locale locale) {
        BarChartExpression theExpression = new BarChartExpression();
        element.setAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", (Expression)theExpression);
        element.getStyle().setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)new Float(280.0f));
        element.getStyle().setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(190.0f));
    }

    private JFreeChart createChart(Expression aExpression) {
        if (aExpression instanceof BarLineChartExpression) {
            CategoryAxis catAxis = new CategoryAxis("Category");
            NumberAxis barsAxis = new NumberAxis("Value");
            NumberAxis linesAxis = new NumberAxis("Value2");
            CategoryPlot plot = new CategoryPlot(this.createDataset(), catAxis, (ValueAxis)barsAxis, (CategoryItemRenderer)new BarRenderer());
            plot.setRenderer(1, (CategoryItemRenderer)new LineAndShapeRenderer());
            plot.setDataset(1, this.createDataset());
            plot.setRangeAxis(1, (ValueAxis)linesAxis);
            plot.mapDatasetToRangeAxis(1, 1);
            plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
            plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
            return new JFreeChart("Bar Line Chart", (Plot)plot);
        }
        if (aExpression instanceof RingChartExpression) {
            return ChartFactory.createRingChart((String)"Ring Chart", (PieDataset)this.createPieDataset(), (boolean)true, (boolean)false, (boolean)false);
        }
        if (aExpression instanceof AreaChartExpression) {
            return ChartFactory.createAreaChart((String)"Area Chart", (String)"Category", (String)"Value", (CategoryDataset)this.createDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        }
        if (aExpression instanceof BarChartExpression) {
            return ChartFactory.createBarChart((String)"Bar Chart", (String)"Category", (String)"Value", (CategoryDataset)this.createDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        }
        if (aExpression instanceof LineChartExpression) {
            return ChartFactory.createLineChart((String)"Line Chart", (String)"Category", (String)"Value", (CategoryDataset)this.createDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        }
        if (aExpression instanceof MultiPieChartExpression) {
            return ChartFactory.createMultiplePieChart((String)"Multi Pie Chart", (CategoryDataset)this.createDataset(), (TableOrder)TableOrder.BY_COLUMN, (boolean)true, (boolean)false, (boolean)false);
        }
        if (aExpression instanceof PieChartExpression) {
            return ChartFactory.createPieChart((String)"Pie Chart", (PieDataset)this.createPieDataset(), (boolean)true, (boolean)false, (boolean)false);
        }
        if (aExpression instanceof WaterfallChartExpressions) {
            return ChartFactory.createWaterfallChart((String)"Bar Chart", (String)"Category", (String)"Value", (CategoryDataset)this.createDataset(), (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)false, (boolean)false);
        }
        if (aExpression instanceof BubbleChartExpression) {
            return ChartFactory.createBubbleChart((String)"Bubble Chart", (String)"X", (String)"Y", (XYZDataset)this.createXYZDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        }
        if (aExpression instanceof ExtendedXYLineChartExpression) {
            return ChartFactory.createXYLineChart((String)"XY Line Chart", (String)"X", (String)"Y", (XYDataset)this.createXYZDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        }
        if (aExpression instanceof ScatterPlotChartExpression) {
            return ChartFactory.createScatterPlot((String)"Scatter Chart", (String)"X", (String)"Y", (XYDataset)this.createXYZDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        }
        if (aExpression instanceof XYAreaLineChartExpression) {
            NumberAxis catAxis = new NumberAxis("Range");
            NumberAxis barsAxis = new NumberAxis("Value");
            NumberAxis linesAxis = new NumberAxis("Value2");
            XYPlot plot = new XYPlot((XYDataset)this.createXYZDataset(), (ValueAxis)catAxis, (ValueAxis)barsAxis, (XYItemRenderer)new XYAreaRenderer());
            plot.setRenderer(1, (XYItemRenderer)new XYLineAndShapeRenderer());
            plot.setDataset(1, (XYDataset)this.createXYZDataset());
            plot.setRangeAxis(1, (ValueAxis)linesAxis);
            plot.mapDatasetToRangeAxis(1, 1);
            plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
            plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
            return new JFreeChart("XY Area Line Chart", (Plot)plot);
        }
        if (aExpression instanceof XYAreaChartExpression) {
            return ChartFactory.createXYAreaChart((String)"XY Area Chart", (String)"X", (String)"Y", (XYDataset)this.createXYZDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        }
        if (aExpression instanceof XYBarChartExpression) {
            return XYBarChartExpression.createXYBarChart("XY Bar Chart", "X", false, "Y", this.createIntervalXYDataset(), PlotOrientation.VERTICAL, true, false, false);
        }
        if (aExpression instanceof XYLineChartExpression) {
            return ChartFactory.createXYLineChart((String)"XY Line Chart", (String)"X", (String)"Y", (XYDataset)this.createXYZDataset(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        }
        if (aExpression instanceof RadarChartExpression) {
            SpiderWebPlot plot = new SpiderWebPlot(this.createDataset());
            return new JFreeChart("Radar Chart", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        }
        return null;
    }
}

