/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.symbol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolResolver;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymbolTable {
    SymbolTable parentSymbolTable = null;
    Map<String, Symbol> symbols = new HashMap<String, Symbol>();
    List<Symbol> symbolsTable = new ArrayList<Symbol>();
    ClassLoaderResolver clr;
    SymbolResolver resolver;

    public SymbolTable(ClassLoaderResolver clr) {
        this.clr = clr;
    }

    public void setParentSymbolTable(SymbolTable tbl) {
        this.parentSymbolTable = tbl;
    }

    public SymbolTable getParentSymbolTable() {
        return this.parentSymbolTable;
    }

    public ClassLoaderResolver getClassLoaderResolver() {
        return this.clr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Symbol getSymbol(int index) {
        List<Symbol> list = this.symbolsTable;
        synchronized (list) {
            return this.symbolsTable.get(index);
        }
    }

    public void setSymbolResolver(SymbolResolver resolver) {
        this.resolver = resolver;
    }

    public SymbolResolver getSymbolResolver() {
        return this.resolver;
    }

    public Collection<String> getSymbolNames() {
        return new HashSet<String>(this.symbols.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Symbol getSymbol(String name) {
        List<Symbol> list = this.symbolsTable;
        synchronized (list) {
            return this.symbols.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Symbol getSymbolIgnoreCase(String name) {
        List<Symbol> list = this.symbolsTable;
        synchronized (list) {
            for (String key : this.symbols.keySet()) {
                if (!key.equalsIgnoreCase(name)) continue;
                return this.symbols.get(key);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSymbol(String name) {
        List<Symbol> list = this.symbolsTable;
        synchronized (list) {
            return this.symbols.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSymbol(Symbol symbol) {
        List<Symbol> list = this.symbolsTable;
        synchronized (list) {
            if (this.symbols.containsKey(symbol.getQualifiedName())) {
                throw new NucleusException("Symbol " + symbol.getQualifiedName() + " already exists.");
            }
            this.symbols.put(symbol.getQualifiedName(), symbol);
            this.symbolsTable.add(symbol);
            return this.symbolsTable.size();
        }
    }

    public String toString() {
        return "SymbolTable : " + StringUtils.mapToString(this.symbols);
    }

    public Class getType(List tuples) {
        return this.resolver.getType(tuples);
    }
}

