/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.SortColInfo;
import org.apache.pig.SortInfo;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ResourceSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(ResourceSchema.class);
    private ResourceFieldSchema[] fields = new ResourceFieldSchema[0];
    private int[] sortKeys = new int[0];
    private Order[] sortKeyOrders = new Order[0];
    private int version = 0;

    public ResourceSchema() {
    }

    public ResourceSchema(Schema pigSchema) {
        List<Schema.FieldSchema> pigSchemaFields = pigSchema.getFields();
        this.fields = new ResourceFieldSchema[pigSchemaFields.size()];
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i] = new ResourceFieldSchema(pigSchemaFields.get(i));
        }
    }

    public ResourceSchema(LogicalSchema pigSchema) {
        List<LogicalSchema.LogicalFieldSchema> pigSchemaFields = pigSchema.getFields();
        this.fields = new ResourceFieldSchema[pigSchemaFields.size()];
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i] = new ResourceFieldSchema(pigSchemaFields.get(i));
        }
    }

    @InterfaceAudience.Private
    public ResourceSchema(Schema pigSchema, SortInfo sortInfo) {
        this(pigSchema);
        if (sortInfo != null && sortInfo.getSortColInfoList().size() != 0) {
            this.sortKeys = new int[sortInfo.getSortColInfoList().size()];
            this.sortKeyOrders = new Order[sortInfo.getSortColInfoList().size()];
            for (int i = 0; i < sortInfo.getSortColInfoList().size(); ++i) {
                SortColInfo colInfo = sortInfo.getSortColInfoList().get(i);
                int index = colInfo.getColIndex();
                SortColInfo.Order origOrder = colInfo.getSortOrder();
                Order order = origOrder == SortColInfo.Order.ASCENDING ? Order.ASCENDING : Order.DESCENDING;
                this.sortKeys[i] = index;
                this.sortKeyOrders[i] = order;
            }
        }
    }

    @InterfaceAudience.Private
    public ResourceSchema(LogicalSchema pigSchema, SortInfo sortInfo) {
        this(pigSchema);
        if (sortInfo != null && sortInfo.getSortColInfoList().size() != 0) {
            this.sortKeys = new int[sortInfo.getSortColInfoList().size()];
            this.sortKeyOrders = new Order[sortInfo.getSortColInfoList().size()];
            for (int i = 0; i < sortInfo.getSortColInfoList().size(); ++i) {
                SortColInfo colInfo = sortInfo.getSortColInfoList().get(i);
                int index = colInfo.getColIndex();
                SortColInfo.Order origOrder = colInfo.getSortOrder();
                Order order = origOrder == SortColInfo.Order.ASCENDING ? Order.ASCENDING : Order.DESCENDING;
                this.sortKeys[i] = index;
                this.sortKeyOrders[i] = order;
            }
        }
    }

    public int getVersion() {
        return this.version;
    }

    public ResourceSchema setVersion(int version) {
        this.version = version;
        return this;
    }

    public ResourceFieldSchema[] getFields() {
        return this.fields;
    }

    public String[] fieldNames() {
        String[] names = new String[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            names[i] = this.fields[i].getName();
        }
        return names;
    }

    public ResourceSchema setFields(ResourceFieldSchema[] fields) {
        if (fields != null) {
            this.fields = Arrays.copyOf(fields, fields.length);
        }
        return this;
    }

    public int[] getSortKeys() {
        return this.sortKeys;
    }

    public ResourceSchema setSortKeys(int[] sortKeys) {
        if (sortKeys != null) {
            this.sortKeys = Arrays.copyOf(sortKeys, sortKeys.length);
        }
        return this;
    }

    public Order[] getSortKeyOrders() {
        return this.sortKeyOrders;
    }

    public ResourceSchema setSortKeyOrders(Order[] sortKeyOrders) {
        if (sortKeyOrders != null) {
            this.sortKeyOrders = Arrays.copyOf(sortKeyOrders, sortKeyOrders.length);
        }
        return this;
    }

    public static boolean equals(ResourceSchema rs1, ResourceSchema rs2) {
        ResourceFieldSchema[] rfs2;
        if (rs1 == null) {
            return rs2 == null;
        }
        if (rs2 == null) {
            return false;
        }
        if (rs1.getVersion() != rs2.getVersion() || !Arrays.equals(rs1.getSortKeys(), rs2.getSortKeys()) || !Arrays.equals((Object[])rs1.getSortKeyOrders(), (Object[])rs2.getSortKeyOrders())) {
            return false;
        }
        ResourceFieldSchema[] rfs1 = rs1.getFields();
        if (rfs1.length != (rfs2 = rs1.getFields()).length) {
            return false;
        }
        for (int i = 0; i < rfs1.length; ++i) {
            if (rfs1[i].getName() == null && rfs2[i].getName() != null || rfs1[i].getName() != null && rfs2[i].getName() == null) {
                return false;
            }
            if (rfs1[i].getName() == null && rfs2[i].getName() == null) {
                return rfs1[i].getType() == rfs2[i].getType();
            }
            if (!rfs1[i].getName().equals(rfs2[i].getName()) || rfs1[i].getType() != rfs2[i].getType()) {
                return false;
            }
            if (ResourceSchema.equals(rfs1[i].getSchema(), rfs2[i].getSchema())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ResourceSchema.stringifyResourceSchema(sb, this, (byte)0, true);
        return sb.toString();
    }

    private static void stringifyResourceSchema(StringBuilder sb, ResourceSchema rs, byte type, boolean printAlias) {
        if (type == 120) {
            sb.append("{");
        } else if (type == 110) {
            sb.append("(");
        } else if (type == 100) {
            sb.append("[");
        }
        if (rs != null) {
            for (int i = 0; i < rs.getFields().length; ++i) {
                sb.append(rs.getFields()[i].getDescription(printAlias));
                if (i >= rs.getFields().length - 1) continue;
                sb.append(",");
            }
        }
        if (type == 120) {
            sb.append("}");
        } else if (type == 110) {
            sb.append(")");
        } else if (type == 100) {
            sb.append("]");
        }
    }

    public static class ResourceFieldSchema
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String name;
        private byte type;
        private String description;
        private ResourceSchema schema;

        public ResourceFieldSchema() {
        }

        public ResourceFieldSchema(Schema.FieldSchema fieldSchema) {
            this.type = fieldSchema.type;
            this.name = fieldSchema.alias;
            this.description = "autogenerated from Pig Field Schema";
            Schema inner = fieldSchema.schema;
            this.schema = (this.type == 120 || this.type == 110 || this.type == 100) && inner != null ? new ResourceSchema(inner) : null;
        }

        public ResourceFieldSchema(LogicalSchema.LogicalFieldSchema fieldSchema) {
            this.type = fieldSchema.type;
            this.name = fieldSchema.alias;
            this.description = "autogenerated from Pig Field Schema";
            LogicalSchema inner = fieldSchema.schema;
            this.schema = DataType.isSchemaType(this.type) && inner != null ? new ResourceSchema(inner) : null;
        }

        public String getName() {
            return this.name;
        }

        public ResourceFieldSchema setName(String name) {
            this.name = name;
            return this;
        }

        public byte getType() {
            return this.type;
        }

        public ResourceFieldSchema setType(byte type) {
            this.type = type;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public ResourceFieldSchema setDescription(String description) {
            this.description = description;
            return this;
        }

        public ResourceSchema getSchema() {
            return this.schema;
        }

        public ResourceFieldSchema setSchema(ResourceSchema schema) throws IOException {
            this.validateSchema(schema);
            this.schema = schema;
            return this;
        }

        private void validateSchema(ResourceSchema schema) throws IOException {
            if (this.type == 120 && schema != null) {
                ResourceFieldSchema[] subFields = schema.getFields();
                if (subFields.length == 1) {
                    if (subFields[0].type != 110) {
                        ResourceFieldSchema.throwInvalidSchemaException();
                    }
                } else {
                    ResourceFieldSchema.throwInvalidSchemaException();
                }
            }
        }

        public static void throwInvalidSchemaException() throws FrontendException {
            int errCode = 2218;
            throw new FrontendException("Invalid resource schema: bag schema must have tuple as its field", errCode, 4);
        }

        public String toString() {
            return this.getDescription(true);
        }

        public String calcCastString() {
            return this.getDescription(false);
        }

        private String getDescription(boolean printAlias) {
            StringBuilder sb = new StringBuilder();
            if (printAlias && this.name != null) {
                sb.append(this.name).append(":");
            }
            if (DataType.isAtomic(this.type)) {
                sb.append(DataType.findTypeName(this.type));
            } else {
                ResourceSchema.stringifyResourceSchema(sb, this.schema, this.type, printAlias);
            }
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Order {
        ASCENDING,
        DESCENDING;

    }
}

