/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.io.ReadToEndLoader;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.pen.util.ExampleTuple;

public class POLoad
extends PhysicalOperator {
    private static final Log log = LogFactory.getLog(POLoad.class);
    private static final long serialVersionUID = 1L;
    private transient LoadFunc loader = null;
    FileSpec lFile;
    PigContext pc;
    boolean setUpDone = false;
    private String signature;
    private long limit = -1L;

    public POLoad(OperatorKey k) {
        this(k, -1, (FileSpec)null);
    }

    public POLoad(OperatorKey k, FileSpec lFile) {
        this(k, -1, lFile);
    }

    public POLoad(OperatorKey k, int rp, FileSpec lFile) {
        super(k, rp);
        this.lFile = lFile;
    }

    public POLoad(OperatorKey k, LoadFunc lf) {
        this(k);
        this.loader = lf;
    }

    public void setUp() throws IOException {
        this.loader = new ReadToEndLoader((LoadFunc)PigContext.instantiateFuncFromSpec(this.lFile.getFuncSpec()), ConfigurationUtil.toConfiguration(this.pc.getProperties()), this.lFile.getFileName(), 0);
    }

    public void tearDown() throws IOException {
        this.setUpDone = false;
    }

    public Result getNext(Tuple t) throws ExecException {
        if (!this.setUpDone && this.lFile != null) {
            try {
                this.setUp();
            }
            catch (IOException ioe) {
                int errCode = 2081;
                String msg = "Unable to setup the load function.";
                throw new ExecException(msg, errCode, 4, ioe);
            }
            this.setUpDone = true;
        }
        Result res = new Result();
        try {
            res.result = this.loader.getNext();
            if (res.result == null) {
                res.returnStatus = (byte)3;
                this.tearDown();
            } else {
                res.returnStatus = 0;
            }
            if (res.returnStatus == 0) {
                res.result = this.illustratorMarkup(res, res.result, 0);
            }
        }
        catch (IOException e) {
            log.error((Object)("Received error from loader function: " + e));
            return res;
        }
        return res;
    }

    public String name() {
        return this.lFile != null ? this.getAliasString() + "Load" + "(" + this.lFile.toString() + ")" + " - " + this.mKey.toString() : this.getAliasString() + "Load" + "(" + "DummyFil:DummyLdr" + ")" + " - " + this.mKey.toString();
    }

    public boolean supportsMultipleInputs() {
        return false;
    }

    public boolean supportsMultipleOutputs() {
        return false;
    }

    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitLoad(this);
    }

    public FileSpec getLFile() {
        return this.lFile;
    }

    public void setLFile(FileSpec file) {
        this.lFile = file;
    }

    public PigContext getPc() {
        return this.pc;
    }

    public void setPc(PigContext pc) {
        this.pc = pc;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public LoadFunc getLoadFunc() {
        return this.loader;
    }

    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        if (this.illustrator != null) {
            if (!this.illustrator.ceilingCheck()) {
                ((Result)in).returnStatus = (byte)3;
                return null;
            }
            if (this.illustrator.getSchema() == null || this.illustrator.getSchema().size() <= ((Tuple)out).size()) {
                boolean hasNull = false;
                for (int i = 0; i < ((Tuple)out).size(); ++i) {
                    try {
                        if (((Tuple)out).get(i) != null) continue;
                        hasNull = true;
                    }
                    catch (ExecException e) {
                        hasNull = true;
                    }
                    break;
                }
                if (!hasNull) {
                    ExampleTuple tOut = new ExampleTuple((Tuple)out);
                    this.illustrator.getLineage().insert(tOut);
                    this.illustrator.addData(tOut);
                    this.illustrator.getEquivalenceClasses().get(eqClassIndex).add(tOut);
                    return tOut;
                }
                return (Tuple)out;
            }
            return (Tuple)out;
        }
        return (Tuple)out;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }
}

