/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TOBAG
extends EvalFunc<DataBag> {
    @Override
    public DataBag exec(Tuple input) throws IOException {
        try {
            DataBag bag = BagFactory.getInstance().newDefaultBag();
            for (int i = 0; i < input.size(); ++i) {
                Object object = input.get(i);
                if (object instanceof Tuple) {
                    bag.add((Tuple)object);
                    continue;
                }
                Tuple tp2 = TupleFactory.getInstance().newTuple(1);
                tp2.set(0, object);
                bag.add(tp2);
            }
            return bag;
        }
        catch (Exception ee) {
            throw new RuntimeException("Error while creating a bag", ee);
        }
    }

    @Override
    public Schema outputSchema(Schema inputSch) {
        int type = -1;
        Schema innerSchema = null;
        if (inputSch != null) {
            for (Schema.FieldSchema fs : inputSch.getFields()) {
                if (type == -1) {
                    type = fs.type;
                    innerSchema = fs.schema;
                    continue;
                }
                if (type == fs.type && this.nullEquals(innerSchema, fs.schema)) continue;
                type = -1;
                break;
            }
        }
        try {
            if (type == -1) {
                return Schema.generateNestedSchema((byte)120, 1);
            }
            Schema.FieldSchema innerFs = new Schema.FieldSchema(null, innerSchema, (byte)type);
            Schema innerSch = new Schema(innerFs);
            Schema bagSchema = new Schema(new Schema.FieldSchema(null, innerSch, 120));
            return bagSchema;
        }
        catch (FrontendException e) {
            throw new RuntimeException("Bug : exception thrown while creating output schema for TOBAG udf", e);
        }
    }

    private boolean nullEquals(Schema currentSchema, Schema newSchema) {
        if (currentSchema == null) {
            return newSchema == null;
        }
        return currentSchema.equals(newSchema);
    }
}

