/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pig.FuncSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.streaming.StreamingCommand;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanWalker;
import org.apache.pig.newplan.ReverseDependencyOrderWalker;
import org.apache.pig.newplan.logical.expression.BinCondExpression;
import org.apache.pig.newplan.logical.expression.CastExpression;
import org.apache.pig.newplan.logical.expression.ConstantExpression;
import org.apache.pig.newplan.logical.expression.DereferenceExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.expression.MapLookupExpression;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.expression.ScalarExpression;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOCross;
import org.apache.pig.newplan.logical.relational.LODistinct;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplit;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LOStream;
import org.apache.pig.newplan.logical.relational.LOUnion;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.newplan.logical.visitor.UDFFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineageFindRelVisitor
extends LogicalRelationalNodesVisitor {
    Map<Long, FuncSpec> uid2LoadFuncMap = new HashMap<Long, FuncSpec>();
    Map<LogicalRelationalOperator, FuncSpec> rel2InputFuncMap = new HashMap<LogicalRelationalOperator, FuncSpec>();

    public LineageFindRelVisitor(OperatorPlan plan) throws FrontendException {
        super(plan, new DependencyOrderWalker(plan));
    }

    public Map<Long, FuncSpec> getUid2LoadFuncMap() {
        return this.uid2LoadFuncMap;
    }

    @Override
    public void visit(LOLoad load) throws FrontendException {
        LogicalSchema schema = load.getSchema();
        this.setLoadFuncForUids(schema, load.getFileSpec().getFuncSpec());
        this.rel2InputFuncMap.put(load, load.getFileSpec().getFuncSpec());
    }

    @Override
    public void visit(LOStream stream) throws FrontendException {
        this.mapToPredLoadFunc(stream);
        StreamingCommand command = stream.getStreamingCommand();
        StreamingCommand.HandleSpec streamOutputSpec = command.getOutputSpec();
        FuncSpec streamLoaderSpec = new FuncSpec(streamOutputSpec.getSpec());
        this.setLoadFuncForUids(stream.getSchema(), streamLoaderSpec);
        this.rel2InputFuncMap.put(stream, streamLoaderSpec);
    }

    @Override
    public void visit(LOInnerLoad innerLoad) throws FrontendException {
        LOForEach foreach = innerLoad.getLOForEach();
        LogicalRelationalOperator pred = (LogicalRelationalOperator)foreach.getPlan().getPredecessors(foreach).get(0);
        LogicalSchema predSchema = pred.getSchema();
        if (innerLoad.getSchema() != null && innerLoad.getSchema().size() == 1 && innerLoad.getSchema().getField((int)0).type == 50 && this.uid2LoadFuncMap.get(innerLoad.getSchema().getField((int)0).uid) == null && predSchema != null) {
            long inpUid = predSchema.getField((int)innerLoad.getProjection().getColNum()).uid;
            if (this.uid2LoadFuncMap.get(inpUid) != null) {
                this.addUidLoadFuncToMap(innerLoad.getSchema().getField((int)0).uid, this.uid2LoadFuncMap.get(inpUid));
            }
            return;
        }
        if (this.getAssociatedLoadFunc(pred) != null) {
            this.mapRelToPredLoadFunc(innerLoad, pred);
        }
    }

    private void setLoadFuncForUids(LogicalSchema schema, FuncSpec funcSpec) throws VisitorException {
        if (schema == null) {
            return;
        }
        for (LogicalSchema.LogicalFieldSchema fs : schema.getFields()) {
            this.addUidLoadFuncToMap(fs.uid, funcSpec);
            this.setLoadFuncForUids(fs.schema, funcSpec);
        }
    }

    @Override
    public void visit(LOFilter filter) throws FrontendException {
        this.mapToPredLoadFunc(filter);
        this.visitExpression(filter.getFilterPlan());
    }

    private void mapToPredLoadFunc(LogicalRelationalOperator relOp) throws FrontendException {
        OperatorPlan lp = relOp.getPlan();
        List<Operator> preds = lp.getPredecessors(relOp);
        if (lp.getPredecessors(relOp) == null || lp.getPredecessors(relOp).size() == 0) {
            return;
        }
        FuncSpec loadFuncSpec = this.getAssociatedLoadFunc((LogicalRelationalOperator)preds.get(0));
        if (loadFuncSpec == null) {
            return;
        }
        for (int i = 1; i < preds.size(); ++i) {
            if (loadFuncSpec.equals(this.getAssociatedLoadFunc((LogicalRelationalOperator)preds.get(i)))) continue;
            return;
        }
        this.rel2InputFuncMap.put(relOp, loadFuncSpec);
    }

    private FuncSpec getAssociatedLoadFunc(LogicalRelationalOperator relOp) throws FrontendException {
        LogicalSchema schema = relOp.getSchema();
        FuncSpec funcSpec = null;
        if (schema != null) {
            if (schema.size() == 0) {
                return null;
            }
            funcSpec = this.uid2LoadFuncMap.get(schema.getField((int)0).uid);
            if (funcSpec != null) {
                for (int i = 1; i < schema.size(); ++i) {
                    LogicalSchema.LogicalFieldSchema fs = schema.getField(i);
                    if (funcSpec.equals(this.uid2LoadFuncMap.get(fs.uid))) continue;
                    funcSpec = null;
                    break;
                }
            }
        }
        if (funcSpec == null) {
            if (relOp instanceof LOForEach) {
                UDFFinder udfFinder = new UDFFinder(((LOForEach)relOp).getInnerPlan());
                udfFinder.visit();
                if (udfFinder.getUDFList().size() != 0) {
                    return null;
                }
            }
            funcSpec = this.rel2InputFuncMap.get(relOp);
        }
        return funcSpec;
    }

    private void mapRelToPredLoadFunc(LogicalRelationalOperator relOp, Operator pred) {
        if (this.rel2InputFuncMap.get(pred) != null) {
            this.rel2InputFuncMap.put(relOp, this.rel2InputFuncMap.get(pred));
        }
    }

    private void visitExpression(LogicalExpressionPlan expPlan) throws FrontendException {
        LineageFindExpVisitor findLineageExp = new LineageFindExpVisitor(expPlan, this.uid2LoadFuncMap);
        findLineageExp.visit();
    }

    @Override
    public void visit(LOCogroup group) throws FrontendException {
        this.mapToPredLoadFunc(group);
        List<Operator> inputs = group.getInputs((LogicalPlan)this.plan);
        ArrayList<LogicalSchema.LogicalFieldSchema> groupPlanSchemas = new ArrayList<LogicalSchema.LogicalFieldSchema>();
        MultiMap<Integer, LogicalExpressionPlan> plans = group.getExpressionPlans();
        for (LogicalExpressionPlan expPlan : plans.values()) {
            this.visitExpression(expPlan);
            if (expPlan.getSources().size() != 1) {
                throw new AssertionError((Object)"Group plans should have only one output");
            }
            groupPlanSchemas.add(((LogicalExpression)expPlan.getSources().get(0)).getFieldSchema());
        }
        LogicalSchema sch = group.getSchema();
        if (this.getAssociatedLoadFunc(group) != null) {
            this.addUidLoadFuncToMap(sch.getField((int)0).uid, this.rel2InputFuncMap.get(group));
            if (sch.getField((int)0).schema != null) {
                this.setLoadFuncForUids(sch.getField((int)0).schema, this.rel2InputFuncMap.get(group));
            }
        } else {
            this.mapMatchLoadFuncToUid(sch.getField(0), groupPlanSchemas);
        }
        if (sch.size() != inputs.size() + 1) {
            throw new AssertionError((Object)"cogroup schema size not same as number of inputs");
        }
        for (int i = 1; i < sch.size(); ++i) {
            long uid = sch.getField((int)i).uid;
            LogicalRelationalOperator input = (LogicalRelationalOperator)inputs.get(i - 1);
            if (this.getAssociatedLoadFunc(input) == null) continue;
            this.addUidLoadFuncToMap(uid, this.rel2InputFuncMap.get(input));
        }
    }

    @Override
    public void visit(LOJoin join) throws FrontendException {
        this.mapToPredLoadFunc(join);
        MultiMap<Integer, LogicalExpressionPlan> plans = join.getExpressionPlans();
        for (LogicalExpressionPlan expPlan : plans.values()) {
            this.visitExpression(expPlan);
        }
    }

    @Override
    public void visit(LOForEach fe) throws FrontendException {
        this.mapToPredLoadFunc(fe);
        LogicalPlan innerPlan = fe.getInnerPlan();
        PlanWalker newWalker = this.currentWalker.spawnChildWalker(innerPlan);
        this.pushWalker(newWalker);
        this.currentWalker.walk(this);
        this.popWalker();
    }

    @Override
    public void visit(LOGenerate gen) throws FrontendException {
        this.mapToPredLoadFunc(gen);
        List<LogicalExpressionPlan> expPlans = gen.getOutputPlans();
        for (LogicalExpressionPlan expPlan : expPlans) {
            this.visitExpression(expPlan);
        }
        boolean[] flattens = gen.getFlattenFlags();
        for (int i = 0; i < flattens.length; ++i) {
            if (!flattens[i]) continue;
            gen.getSchema();
            if (gen.getOutputPlanSchemas() == null || gen.getOutputPlanSchemas().size() <= i) {
                return;
            }
            LogicalSchema sch = gen.getOutputPlanSchemas().get(i);
            if (sch == null) continue;
            LogicalExpression exp = (LogicalExpression)gen.getOutputPlans().get(i).getSources().get(0);
            FuncSpec funcSpec = this.uid2LoadFuncMap.get(exp.getFieldSchema().uid);
            for (LogicalSchema.LogicalFieldSchema fs : sch.getFields()) {
                this.addUidLoadFuncToMap(fs.uid, funcSpec);
            }
        }
    }

    @Override
    public void visit(LOSort sort) throws FrontendException {
        this.mapToPredLoadFunc(sort);
        List<LogicalExpressionPlan> expPlans = sort.getSortColPlans();
        for (LogicalExpressionPlan expPlan : expPlans) {
            this.visitExpression(expPlan);
        }
    }

    @Override
    public void visit(LODistinct relOp) throws FrontendException {
        this.mapToPredLoadFunc(relOp);
    }

    @Override
    public void visit(LOLimit loLimit) throws FrontendException {
        this.mapToPredLoadFunc(loLimit);
        if (loLimit.getLimitPlan() != null) {
            this.visitExpression(loLimit.getLimitPlan());
        }
    }

    @Override
    public void visit(LOSplit relOp) throws FrontendException {
        this.mapToPredLoadFunc(relOp);
    }

    @Override
    public void visit(LOStore relOp) throws FrontendException {
        this.mapToPredLoadFunc(relOp);
    }

    @Override
    public void visit(LOCross relOp) throws FrontendException {
        this.mapToPredLoadFunc(relOp);
    }

    @Override
    public void visit(LOUnion relOp) throws FrontendException {
        this.mapToPredLoadFunc(relOp);
        LogicalSchema schema = relOp.getSchema();
        if (schema != null) {
            for (LogicalSchema.LogicalFieldSchema logicalFieldSchema : schema.getFields()) {
                this.addUidLoadFuncToMap(logicalFieldSchema.uid, this.rel2InputFuncMap.get(relOp));
            }
        }
    }

    @Override
    public void visit(LOSplitOutput split) throws FrontendException {
        this.mapToPredLoadFunc(split);
        this.visitExpression(split.getFilterPlan());
        LogicalSchema inputSch = ((LogicalRelationalOperator)split.getPlan().getPredecessors(split).get(0)).getSchema();
        LogicalSchema outSchema = split.getSchema();
        if (inputSch == null && outSchema == null) {
            return;
        }
        if (inputSch == null || outSchema == null) {
            String msg = "Bug: in split only one of input/output schema is null " + split;
            throw new VisitorException((Operator)split, msg, 2260, 4);
        }
        if (inputSch.size() != outSchema.size()) {
            String msg = "Bug: input and output schema size of split differ " + split;
            throw new VisitorException((Operator)split, msg, 2261, 4);
        }
        for (int i = 0; i < inputSch.size(); ++i) {
            LogicalSchema.LogicalFieldSchema inField = inputSch.getField(i);
            LogicalSchema.LogicalFieldSchema outField = outSchema.getField(i);
            if (this.uid2LoadFuncMap.get(inField.uid) == null) continue;
            this.addUidLoadFuncToMap(outField.uid, this.uid2LoadFuncMap.get(inField.uid));
        }
    }

    private void addUidLoadFuncToMap(long uid, FuncSpec loadFuncSpec) throws VisitorException {
        if (loadFuncSpec == null) {
            return;
        }
        FuncSpec curFuncSpec = this.uid2LoadFuncMap.get(uid);
        if (curFuncSpec == null) {
            this.uid2LoadFuncMap.put(uid, loadFuncSpec);
        } else if (!curFuncSpec.equals(loadFuncSpec)) {
            String msg = "Bug: uid mapped to two different load functions : " + curFuncSpec + " and " + loadFuncSpec;
            throw new VisitorException(msg, 2262, 4);
        }
    }

    void mapMatchLoadFuncToUid(LogicalSchema.LogicalFieldSchema outFS, List<LogicalSchema.LogicalFieldSchema> inputFieldSchemas) throws VisitorException {
        if (inputFieldSchemas.size() == 0) {
            return;
        }
        for (LogicalSchema.LogicalFieldSchema fs : inputFieldSchemas) {
            if (fs != null) continue;
            return;
        }
        LogicalSchema.LogicalFieldSchema inpFS1 = inputFieldSchemas.get(0);
        FuncSpec funcSpec1 = this.uid2LoadFuncMap.get(inpFS1.uid);
        boolean allInnerSchemaMatch = false;
        if (funcSpec1 != null) {
            boolean allMatch = true;
            allInnerSchemaMatch = true;
            for (LogicalSchema.LogicalFieldSchema fs : inputFieldSchemas) {
                if (!funcSpec1.equals(this.uid2LoadFuncMap.get(fs.uid))) {
                    allMatch = false;
                }
                if (outFS.schema != null && outFS.schema.isEqual(fs.schema)) continue;
                allInnerSchemaMatch = false;
            }
            if (allMatch) {
                this.addUidLoadFuncToMap(outFS.uid, funcSpec1);
            }
        }
        if (allInnerSchemaMatch) {
            List<LogicalSchema.LogicalFieldSchema> outFields = outFS.schema.getFields();
            for (int i = 0; i < outFields.size(); ++i) {
                ArrayList<LogicalSchema.LogicalFieldSchema> inFsList = new ArrayList<LogicalSchema.LogicalFieldSchema>();
                for (LogicalSchema.LogicalFieldSchema fs : inputFieldSchemas) {
                    inFsList.add(fs.schema.getField(i));
                }
                this.mapMatchLoadFuncToUid(outFields.get(i), inFsList);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LineageFindExpVisitor
    extends LogicalExpressionVisitor {
        private Map<Long, FuncSpec> uid2LoadFuncMap;

        public LineageFindExpVisitor(LogicalExpressionPlan plan, Map<Long, FuncSpec> uid2LoadFuncMap) throws FrontendException {
            super(plan, new ReverseDependencyOrderWalker(plan));
            this.uid2LoadFuncMap = uid2LoadFuncMap;
        }

        @Override
        public void visit(ProjectExpression proj) throws FrontendException {
            FuncSpec funcSpec;
            LogicalRelationalOperator inputRel = proj.findReferent();
            if (proj.getFieldSchema() == null) {
                return;
            }
            long uid = proj.getFieldSchema().uid;
            if (this.uid2LoadFuncMap.get(uid) == null && (inputRel.getSchema() == null || inputRel instanceof LOInnerLoad) && (funcSpec = LineageFindRelVisitor.this.rel2InputFuncMap.get(inputRel)) != null) {
                LineageFindRelVisitor.this.addUidLoadFuncToMap(uid, funcSpec);
            }
        }

        @Override
        public void visit(DereferenceExpression deref) throws FrontendException {
            this.updateUidMap(deref, deref.getReferredExpression());
        }

        @Override
        public void visit(MapLookupExpression mapLookup) throws FrontendException {
            this.updateUidMap(mapLookup, mapLookup.getMap());
        }

        private void updateUidMap(LogicalExpression exp, LogicalExpression inp) throws FrontendException {
            long inpUid = inp.getFieldSchema().uid;
            FuncSpec inpLoadFuncSpec = this.uid2LoadFuncMap.get(inpUid);
            LineageFindRelVisitor.this.addUidLoadFuncToMap(exp.getFieldSchema().uid, inpLoadFuncSpec);
        }

        @Override
        public void visit(BinCondExpression binCond) throws FrontendException {
            LogicalExpression lhs = binCond.getLhs();
            LogicalExpression rhs = binCond.getRhs();
            if (this.getNULLConstantInCast(lhs) != null) {
                FuncSpec funcSpec = this.uid2LoadFuncMap.get(rhs.getFieldSchema().uid);
                this.uid2LoadFuncMap.put(binCond.getFieldSchema().uid, funcSpec);
            } else if (this.getNULLConstantInCast(rhs) != null) {
                FuncSpec funcSpec = this.uid2LoadFuncMap.get(lhs.getFieldSchema().uid);
                this.uid2LoadFuncMap.put(binCond.getFieldSchema().uid, funcSpec);
            } else {
                ArrayList<LogicalSchema.LogicalFieldSchema> inFieldSchemas = new ArrayList<LogicalSchema.LogicalFieldSchema>();
                inFieldSchemas.add(lhs.getFieldSchema());
                inFieldSchemas.add(rhs.getFieldSchema());
                LineageFindRelVisitor.this.mapMatchLoadFuncToUid(binCond.getFieldSchema(), inFieldSchemas);
            }
        }

        @Override
        public void visit(ScalarExpression scalarExp) throws FrontendException {
            LogicalRelationalOperator inputRel = (LogicalRelationalOperator)scalarExp.getAttachedLogicalOperator();
            LogicalPlan relPlan = (LogicalPlan)inputRel.getPlan();
            List<Operator> softPreds = relPlan.getSoftLinkPredecessors(inputRel);
            Integer inputColNum = (Integer)((ConstantExpression)scalarExp.getArguments().get(0)).getValue();
            String inputFile = (String)((ConstantExpression)scalarExp.getArguments().get(1)).getValue();
            long outputUid = scalarExp.getFieldSchema().uid;
            boolean foundInput = false;
            for (Operator softPred : softPreds) {
                LOStore inputStore = (LOStore)softPred;
                if (!inputStore.getFileSpec().getFileName().equals(inputFile)) continue;
                if (foundInput) {
                    throw new FrontendException("More than one input found for scalar expression", 2268, 4);
                }
                foundInput = true;
                LogicalSchema sch = inputStore.getSchema();
                if (sch == null) {
                    FuncSpec funcSpec = LineageFindRelVisitor.this.rel2InputFuncMap.get(inputStore);
                    LineageFindRelVisitor.this.addUidLoadFuncToMap(outputUid, funcSpec);
                    continue;
                }
                LogicalSchema.LogicalFieldSchema fs = sch.getField(inputColNum);
                FuncSpec funcSpec = this.uid2LoadFuncMap.get(fs.uid);
                LineageFindRelVisitor.this.addUidLoadFuncToMap(outputUid, funcSpec);
            }
            if (!foundInput) {
                throw new FrontendException("No input found for scalar expression", 2269, 4);
            }
        }

        private Object getNULLConstantInCast(LogicalExpression rel) throws FrontendException {
            if (rel instanceof CastExpression) {
                if (((CastExpression)rel).getExpression() instanceof CastExpression) {
                    return this.getNULLConstantInCast(((CastExpression)rel).getExpression());
                }
                if (((CastExpression)rel).getExpression() instanceof ConstantExpression) {
                    ConstantExpression constExp = (ConstantExpression)((CastExpression)rel).getExpression();
                    if (constExp.getValue() == null) {
                        return constExp;
                    }
                    return null;
                }
            }
            return null;
        }
    }
}

